; BANPKT.ASM - Adapter provides Packet Driver interface over Banyan's VINES
;
; (c) Copyright Daniel D. Lanciani 1992-1994.  All rights reserved.
;
; This unmodified source file and its executable form may be used and
; redistributed freely.  The source may be modified, and the source or
; executable versions built from the modified source may be used and
; redistributed, provided that this notice and the copyright displayed by
; the exectuable remain intact, and provided that the executable displays
; an additional message indicating that it has been modified, and by whom.
;
; Daniel D. Lanciani releases this software "as is", with no express or
; implied warranty, including, but not limited to, the implied warranties
; of merchantability and fitness for a particular purpose.
;
; Please send bug reports to ddl@harvard.harvard.edu or
;
; Dan Lanciani
; 185 Atlantic Road
; Gloucester, MA 01930

version	equ	2	; for driver_info
iftype	equ	71	; for driver_info/access_type
nhand	equ	8	; max active handles
mmatch	equ	8	; max length of header match
pkvec	equ	69h	; default control vector
bsize	equ	1514	; max frame size

hinfo	struc			; per-handle data
nmatch	dw	-1		; header match length
match	db	mmatch dup (?)	; header match bytes
recvo	dw	?		; receiver offset
recvs	dw	?		; receiver segment
hinfo	ends

CODE	segment word public 'CODE'
	assume cs:CODE, ds:CODE, es:nothing, ss:CODE

	org	100h
stack	label	byte
at100h:	jmp	start

copyright db	'BANPKT 1.1', 13, 10
	db	'(c) Copyright Daniel Lanciani 1992-1994.  All rights reserved.'
	db	13, 10, 'This software is provided with NO WARRANTY.', 13, 10
	db	'$'
myname	db	'BANPKT', 0	; for driver_info
class	db	1		; for driver_info
	align	2
savpko	dw	0		; saved vector offset
savpks	dw	0		; saved vector segment
myvec	dw	4 * pkvec	; 4 * my vector
alen	dw	6		; address length
off	dw	12		; header offset for match
rmode	dw	3		; current receiver mode
sendb	db	bsize dup (?)
sendab	dw	0, 0, 0, offset sendb, 0, 0
	dw	1, -1, 0, 0, 0, 0, 0, 0
	dw	-1, 0, 1
sendcb	dw	2, offset sendab, 0, 0, 0
recb	db	bsize dup (?)
recab	dw	0, 0, 0, offset recb, bsize, 5
	dw	1, -1, 0, 0, 0, 0, 0, 0
	dw	-1, 0, 1
reccb	dw	3, offset recab, 0, 0, 0
addrab	dw	6, 0, 0, 0
addrcb	dw	14h, offset addrab, 0, 0, 0
closecb	dw	4, offset sendab + 4, 0, 0, 0
intab	dw	offset upcall, offset stack, -1
intcb	dw	0bh, offset intab, 0, 0, 0
htab	hinfo	nhand dup (<>)	; the handle table
htabe	label	byte
stab	dw	14 dup (0)	; for get_statistics
ptab	db	1, 9, 14, 6	; for get_parameters
	dw	1514, 0, 0, 0, 0

upcall	proc	far
	cld
	cli
	add	stab, 1
	adc	stab + 2, 0
	add	stab + 8, cx
	adc	stab + 10, 0
	mov	bx, offset htab
recv1:	mov	cx, [bx].nmatch
	cmp	cx, -1
	jz	recv5
	jcxz	recv2
	mov	di, offset recb
	add	di, off
	lea	si, [bx].match
	repe	cmpsb
	jnz	recv5
recv2:	push	bx
	mov	cx, recab
	xor	ax, ax
	call	dword ptr [bx].recvo
	pop	bx
	cld
	cli
	mov	ax, cs
	mov	ds, ax
	mov	ax, es
	or	ax, di
	jz	recv7
	push	di
	mov	si, offset recb
	mov	cx, recab
	shr	cx, 1
	rep	movsw
	jnc	recv3
	movsb
recv3:	pop	si
	mov	cx, recab
	mov	ax, es
	mov	ds, ax
	push	bx
	mov	ax, 1
	call	dword ptr cs:[bx].recvo
	pop	bx
	cld
	cli
	mov	ax, cs
	mov	ds, ax
recv5:	add	bx, size hinfo
	cmp	bx, offset htabe
	jnc	recv6
	jmp	recv1
recv7:	cli
	mov	ax, cs
	mov	ds, ax
	add	stab + 24, 1
	adc	stab + 26, 0
	jmp	short recv5
recv6:	mov	bx, offset reccb
	call	doban
	mov	ax, -1
	ret
upcall	endp

doban:	mov	ax, 1
dobani:	int	60h
	ret

nofunc:	mov	dh, 11
	jmp	bad

driver_info:pop	bx
	mov	bx, cs
	mov	ds, bx
	mov	bx, version
	mov	ch, class
	mov	dx, iftype
	xor	cl, cl
	mov	si, offset myname
	mov	al, 6
	jmp	good1

access_type:pop	bx
	push	ds
	push	cs
	pop	ds
	cmp	al, class
	jz	access_type1
	mov	dh, 2
	jmp	short access_type5
access_type1:cmp	bx, iftype
	jz	access_type7
	cmp	bx, -1
	jz	access_type7
;	mov	dh, 3
;	jmp	short access_type5
access_type7:and	dl, dl
	jz	access_type2
	mov	dh, 4
	jmp	short access_type5
access_type2:cmp	cx, mmatch + 1
	jc	access_type3
	mov	dh, 14
	jmp	short access_type5
access_type3:mov	bx, offset htab
access_type4:cmp	[bx].nmatch, -1
	jz	access_type6
	add	bx, size hinfo
	cmp	bx, offset htabe
	jc	access_type4
	mov	dh, 9
access_type5:pop	ds
	jmp	bad1
access_type6:mov	[bx].nmatch, cx
	mov	[bx].recvo, di
	mov	[bx].recvs, es
	mov	di, ds
	mov	es, di
	lea	di, [bx].match
	pop	ds
	rep	movsb
	mov	ax, bx
	push	ax
	push	ds
	mov	ax, cs
	mov	ds, ax
	mov	sendab + 32, 2
	mov	ax, word ptr [bx].match
	mov	sendab + 30, ax
	mov	bx, offset sendcb
	call	doban
	mov	sendab + 32, 1
	pop	ds
	pop	ax
	jmp	good1

release_type:pop	bx
	push	ds
	mov	ax, cs
	mov	ds, ax
	mov	[bx].nmatch, -1
	mov	sendab + 32, 3
	mov	ax, word ptr [bx].match
	mov	sendab + 30, ax
	mov	bx, offset sendcb
	call	doban
	mov	sendab + 32, 1
	pop	ds
	jmp	good1

send_pkt:sti
	mov	ax, cs
	mov	es, ax
	mov	di, offset sendb
	push	cx
	shr	cx, 1
	rep	movsw
	jnc	send_pkt1
	movsb
send_pkt1:pop	cx
	push	ds
	mov	ds, ax
	add	stab + 4, 1
	adc	stab + 6, 0
	add	stab + 12, cx
	adc	stab + 14, 0
	mov	sendab + 8, cx
	mov	bx, offset sendcb
	call	doban
	or	ax, sendcb + 4
	jnz	send_pkt2
	pop	ds
	jmp	good

send_pkt2:add	stab + 20, 1
	adc	stab + 22, 0
	pop	ds
	mov	dh, 12
	jmp	bad

terminate:push	ds
	mov	ax, cs
	mov	ds, ax
	xor	ax, ax
	mov	es, ax
	mov	bx, myvec
	mov	ax, savpko
	mov	es:[bx], ax
	mov	ax, savpks
	mov	es:2[bx], ax
	mov	intab, 0
	mov	bx, offset intcb
	call	doban
	mov	bx, offset closecb
	call	doban
	mov	ax, cs
	mov	es, ax
	mov	ah, 49h
	int	21h
	pop	ds
	jmp	good

get_address:cmp	cx, cs:alen
	jnc	get_address1
	mov	dh, 9
	jmp	bad
get_address1:push	ds
	mov	ax, cs
	mov	ds, ax
	push	es
	push	di
	mov	bx, offset addrcb
	call	doban
	pop	di
	pop	es
	mov	si, offset addrab + 2
	mov	cx, alen
	cld
	rep	movsb
	pop	ds
	mov	cx, alen
	jmp	good

reset_interface:mov	dh, 15
	jmp	bad

get_parameters:mov	di, cs
	mov	es, di
	mov	di, offset ptab
	jmp	good

set_rcv_mode:mov	bx, cx
	dec	bx
	cmp	bx, 6
	jnc	set_rcv_mode1
	mov	cs:rmode, cx
	jmp	good
set_rcv_mode1:mov	dh, 8
	jmp	bad

get_rcv_mode:mov	ax, cs:rmode
	jmp	good

get_statistics:mov	si, cs
	mov	ds, si
	mov	si, offset stab
	jmp	good

set_address:mov	dh, 13
	jmp	bad

funcs	dw	nofunc
	dw	driver_info
	dw	access_type
	dw	release_type
	dw	send_pkt
	dw	terminate
	dw	get_address
	dw	reset_interface
	dw	nofunc
	dw	nofunc

	dw	get_parameters
	dw	nofunc
	dw	nofunc
	dw	nofunc
	dw	nofunc
	dw	nofunc
	dw	nofunc
	dw	nofunc
	dw	nofunc
	dw	nofunc

	dw	set_rcv_mode
	dw	get_rcv_mode
	dw	nofunc
	dw	nofunc
	dw	get_statistics
	dw	set_address

nfuncs	equ	($ - offset funcs) / 2

intpk	proc	far
	jmp	short dopk
	nop
sig	db	'PKT DRVR', 0
dopk:	cli
	cld
	push	bx
	cmp	ah, nfuncs
	jc	dopk1
	jmp	nofunc

dopk1:	mov	bl, ah
	xor	bh, bh
	shl	bx, 1
	jmp	cs:funcs[bx]

bad:	pop	bx
bad1:	stc
	sti
	ret	2
good:	pop	bx
good1:	clc
	sti
	ret	2
intpk	endp

start:	mov	ax, cs
	mov	ds, ax
	cld

	mov	dx, offset copyright
	mov	ah, 9
	int	21h

	mov	bx, 81h
	call	space
	call	number
	jc	start0
	add	ax, ax
	add	ax, ax
	mov	myvec, ax

start0:	xor	ax, ax
	mov	es, ax
	mov	bx, myvec
	les	di, es:[bx]
	add	di, 3
	mov	si, offset sig
	mov	cx, 9
	repe	cmpsb
	jnz	start1
	mov	dx, offset already
pexit:	mov	ah, 9
	int	21h
	int	20h

start1:	mov	cx,  7
	mov	si, 180h
start11:xor	ax, ax
	mov	ds, ax
	lds	ax, [si]
	mov	di, ax
	or	di, di
	jz	start12
	sub	di, 4
	mov	ax, [di]
	cmp	ax, 4142h
	jnz	start12
	mov	ax, 2[di]
	cmp	ax, 564eh
	jz	start13
start12:add	si, 4
	loop	start11
	mov	ax, cs
	mov	ds, ax
	mov	dx, offset noban
	jmp	short pexit

start13:mov	ax, cs
	mov	ds, ax
	mov	ax, si
	shr	ax, 1
	shr	ax, 1
	mov	byte ptr dobani + 1, al

	mov	bx, offset sesscb
	call	doban

	mov	bx, offset sockcb
	call	doban
	or	ax, sockcb + 4
	jz	start14
	mov	dx, offset nosock
	jmp	pexit

start14:mov	ax, sendab + 4
	mov	recab + 4, ax
	mov	intcb + 8, cs
	mov	bx, offset intcb
	call	doban
	or	ax, intcb + 4
	jz	start15
	mov	bx, offset closecb
	call	doban
	mov	dx, offset noint
	jmp	pexit

start15:mov	bx, offset reccb
	call	doban
	or	ax, reccb + 4
	jz	start16
	mov	intab, 0
	mov	bx, offset intcb
	call	doban
	mov	bx, offset closecb
	call	doban
	mov	dx, offset norec
	jmp	pexit

start16:xor	ax, ax
	mov	es, ax
	pushf
	cli
	mov	bx, myvec
	mov	ax, es:[bx]
	mov	savpko, ax
	mov	ax, es:2[bx]
	mov	savpks, ax
	mov	es:[bx], offset intpk
	mov	es:2[bx], cs
	popf

	mov	dx, offset goodins
	mov	ah, 9
	int	21h

	mov	es, ds:[2ch]
	mov	ah, 49h
	int	21h
	mov	word ptr ds:[2ch], 0

	mov	cx, 5
	xor	bx, bx
cloop:	mov	ah, 3eh
	int	21h
	inc	bx
	loop	cloop

	mov	dx, offset start
	int	27h

number:	xor	ax, ax
	mov	cx, -1
	mov	base, 10
	cmp	byte ptr [bx], '0'
	jnz	number1
	xor	cx, cx
	mov	base, 8
	inc	bx
	cmp	byte ptr [bx], 'x'
	jz	@f
	cmp	byte ptr [bx], 'X'
	jnz	number1
@@:	mov	base, 16
	inc	bx
number1:mov	dl, byte ptr [bx]
	cmp	dl, '0'
	jc	@f
	cmp	dl, '9' + 1
	jnc	@f
	sub	dl, '0'
	jmp	short number2
@@:	cmp	dl, 'a'
	jc	@f
	cmp	dl, 'f' + 1
	jnc	@f
	sub	dl, 'a' - 10
	jmp	short number2
@@:	cmp	dl, 'A'
	jc	number3
	cmp	dl, 'F' + 1
	jnc	number2
	sub	dl, 'A' - 10
number2:xor	dh, dh
	cmp	dx, base
	jnc	number3
	xor	cx, cx
	push	dx
	mov	dx, base
	mul	dx
	pop	dx
	add	ax, dx
	inc	bx
	jmp	short number1
number3:add	cx, 1
	ret

space:	cmp	byte ptr [bx], ' '
	jz	space1
	cmp	byte ptr [bx], 9
	jz	space1
	ret
space1:	inc	bx
	jmp	short space

base	dw	10
already	db	'A driver is already installed at this vector.', 13, 10, '$'
noban	db	'Vines is not loaded.', 13, 10, '$'
nosock	db	'Cannot allocate Vines socket.', 13, 10, '$'
noint	db	'Cannot set Vines interrupt.', 13, 10, '$'
norec	db	'Cannot start Vines receive.', 13, 10, '$'
goodins	db	'BANPKT is installed and ready.', 13, 10, '$'
sesscb	dw	8, 2, 0, 0, 0
sockad	dw	1, -1, 0, 0, 0, 0, 0, 0
sockab	dw	offset sendab + 4, 8, 3, -1, offset sockad, 0
sockcb	dw	1, offset sockab, 0, 0, 0

CODE	ends
	end	at100h
