1 REM ***** Initialization *****
2 PRINT : PRINT "VALIDCC - Credit Card Number Verification Utility V1.0"
3 PRINT "          Non-copyright 1994 (NC) MHK."
4 LET M = 0: REM *** Multiplier for card number checking method ***
5 LET CS = 0: REM *** Temporary serial check number ***
6 LET A$ = "": REM *** Original card number ***
7 LET B$ = "": REM *** Filtered card number (ONLY NUMBERS) ***
8 LET CT$ = "": REM *** Credit card type ***

10 REM ***** Card number query *****
11 LET B$ = ""
12 PRINT : PRINT "                                       1-----------3-56"
13 INPUT "Input Credit Card Number [? for HELP]"; A$
14 IF LEFT$(A$, 1) = "?" THEN GOTO 20
15 FOR X = 1 TO LEN(A$)
16 IF MID$(A$, X, 1) >= "0" AND MID$(A$, X, 1) <= "9" OR MID$(A$, X, 1) = "-" THEN :  ELSE GOTO 44
17 IF MID$(A$, X, 1) >= "0" AND MID$(A$, X, 1) <= "9" THEN B$ = B$ + MID$(A$, X, 1)
18 NEXT X
19 GOTO 40

20 REM ***** Help *****
21 PRINT : PRINT "SOME HELP:"
22 PRINT : PRINT "Each credit card number consists of a series of 13, 15 or 16 numbers."
23 PRINT "Credit card  type is  identified from  the first number of  the serial and each"
24 PRINT "type has a certain number  of numbers in the serial. Here is  the list of cards"
25 PRINT "identified by this program:"
26 PRINT : PRINT "    1ST #:   CREDIT CARD COMPANY:   Numbers:"
27 PRINT "        3    American Express       15"
28 PRINT "        4    VISA                   13 or 16"
29 PRINT "        5    MasterCard             16"
30 PRINT "        6    Discover               16"
31 GOTO 10

40 REM ***** Errors *****
41 IF LEN(B$) = 0 THEN PRINT "No card number given! Please re-enter."; CHR$(7): GOTO 10
42 IF LEFT$(B$, 1) < "3" OR LEFT$(B$, 1) > "6" THEN PRINT "Unknown credit card number!"; CHR$(7): GOTO 72
43 GOTO 50
44 PRINT "Invalid character in card number!"; CHR$(7): GOTO 72
45 PRINT "Invalid serial number length for "; CT$; "! Try ? for HELP."; CHR$(7): GOTO 72

50 REM ***** Initial credit card number check *****
51 IF LEFT$(B$, 1) = "3" THEN CT$ = "American Express (AMEX)": IF NOT LEN(B$) = 15 THEN GOTO 45
52 IF LEFT$(B$, 1) = "4" THEN CT$ = "VISA": IF LEN(B$) = 13 OR LEN(B$) = 16 THEN :  ELSE GOTO 45
53 IF LEFT$(B$, 1) = "5" THEN CT$ = "MasterCard (MC)": IF NOT LEN(B$) = 16 THEN GOTO 45
54 IF LEFT$(B$, 1) = "6" THEN CT$ = "Discover (DISC)": IF NOT LEN(B$) = 16 THEN GOTO 45

60 REM ***** Validity check method *****
61 FOR X = LEN(B$) - 1 TO 1 STEP -1
62 IF M = 2 THEN M = 1 ELSE M = 2
63 IF VAL(MID$(B$, X, 1)) * M > 9 THEN CS = CS + VAL(MID$(B$, X, 1)) * M - 9 ELSE CS = CS + VAL(MID$(B$, X, 1)) * M
64 NEXT X

70 REM ***** Validation information *****
71 IF (CS + VAL(RIGHT$(B$, 1))) MOD 10 = 0 THEN PRINT "OK. Number checked as a valid "; CT$; " number.":  ELSE PRINT CHR$(7); "Serial "; B$; " is an INVALID "; CT$; " number!!!"; CHR$(7)
72 PRINT

