/*
 * Rainy prompt.
 *
 * This program causes the characters on the screen to 'rain' down, and
 * pile up at the bottom of the screen. The original screen is saved, and
 * restored when the program terminates. It makes a novel "delay" function
 * for "batch" files.
 *
 * Arguments are (# of raindrops), and an optional "prompt" string.
 * Returns an ERRORLEVEL of zero (0), if a key was pressed to exit,
 * or -1 if all drops fell without keyboard action.
 *
 * Copyright 1994-1995 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc rain -fop
 */
#include <stdio.h>
#include <window.h>

static unsigned bottom = 24*160;

main(int argc, char *argv[])
{
	int i;

	if(argc < 2)
		abort("Use: rain <drops> [prompt text]");

/* Open window, obtain arguments & make rain */
	wopen(0, 0, 80, 25, WSAVE|REVERSE);
	wcursor_off();
	if(argc > 2) {		/* Prompt text given */
		bottom = 23*160;
		wgotoxy(0, 24);
		for(i=2; i < argc; ++i)
			wprintf("%s ", argv[i]);
		wcleol(); }
	i = atoi(argv[1]);
	while(i--) {
		if(drop_column(random(80))) {
			wclose();
			exit(0); } }
	wclose();
	exit(-1);
}

/*
 * Locate the lowest character in a specific screen column, which is not
 * already resting on the bottom, and drop it down.
 */
drop_column(int x)
{
	x = (x + x) + bottom;

	/* Locate the lowest blank character first */
	while(x >= 0) {
		if(peek(W_BASE, x) == ' ')
			goto found1;
		x -= 160; }
	/* No space to drop in this column */
	return wtstc();

found1: /* Locate a higher character to 'drop' */
	while(x >= 0) {
		if(peek(W_BASE, x) != ' ')
			goto found2;
		x -= 160; }
	/* No character to move at this column */
	return wtstc();

found2: /* Lower character to bottom of screen */
	while((x < bottom) && (peek(W_BASE, x+160) == ' ')) {
		poke(W_BASE, x+160, peek(W_BASE, x));
		poke(W_BASE, x, ' ');
		delay(50);
		x += 160;
		if(wtstc())
			return 1; }
	return 0;
}
