/*
 * Editor:      TDE, the Thomson-Davis Editor
 * Filename:    letters.h
 * Compiled by: Byrial Jensen
 *
 * This file contains various defines of letters etc., collected to
 * to ease making versions for other languages.
 * It is used with changed versions of several of the TDE source files
 */

/* Respond letters */

#define L_BLOCK         'B'        /* cp. block13 */
#define L_FILE          'F'

#define L_ABORT         'A'        /* cp. criterr_screen in criterr.h */
#define L_FAIL          'Q'
#define L_RETRY         'R'

/*
 * dos file attributes
 */
#define L_DOS_ARCHIVE   'A'        /* cp. utils14 */
#define L_DOS_SYSTEM    'S'
#define L_DOS_HIDDEN    'H'
#define L_DOS_READ_ONLY 'R'

/*
 * unix file attributes
 */
#define L_UNIX_READ     'r'        /* cp. utils14 */
#define L_UNIX_WRITE    'w'
#define L_UNIX_EXECUTE  'x'

#define L_PROMPT        'P'        /* cp. find1 */
#define L_NO_PROMPT     'N'

#define L_REPLACE       'R'        /* cp. find2 */
#define L_SKIP          'S'
#define L_EXIT          'E'

#define L_QUIT          'Q'        /* cp. find3 */
#define L_CONTINUE      'C'

#define L_ASCENDING     'A'        /* cp. utils4 */
#define L_DESCENDING    'D'

#define L_FORWARD       'F'        /* cp. utils5 */
#define L_BACKWARD      'B'

#define L_YES           'Y'        /* in multiple prompts */
#define L_NO            'N'

#define L_LEFT          'L'        /* cp. block18 */
#define L_RIGHT         'R'

#define L_BEGINNING     'B'        /* cp. diff_prompt3 */
#define L_CURRENT       'C'

#define L_OVERWRITE     'O'        /* cp. block7 */
#define L_APPEND        'A'


#define BLOCK14_LINE_SLOT 14    /* positions for data in messages */
#define BLOCK14_SUM_SLOT  25
#define UTILS13_NO_SLOT   7

/*
 * Here comes positions for texts in the dirlist window.
 * All positions are relative to the window frame.
 */
#if defined( __UNIX__ )
 #define DIR1_ROW   1   /* dir1: Directory : */
 #define DIR1_COL   3
 #define DIR4_ROW   2   /* dir4: Selected file : */
 #define DIR4_COL   3
 #define DIR5_ROW   3   /* dir5: File size : */
 #define DIR5_COL   3
 #define DIR6_ROW   3   /* dir6: File count: */
 #define DIR6_COL  44
 #define DIR7_ROW  15   /* dir7: Cursor key move. Enter selects ... */
 #define DIR7_COL   8
#else
 #define DIR4_ROW   1   /* dir4: Selected file : */
 #define DIR4_COL   3
 #define DIR5_ROW   2   /* dir5: File size : */
 #define DIR5_COL   3
 #define DIR6_ROW   2   /* dir6: File count: */
 #define DIR6_COL  44
 #define DIR7_ROW  14   /* dir7: Cursor key move. Enter selects ... */
 #define DIR7_COL   8
#endif


/*
 * The characters used to draw the dirlist frame
 */
#if defined( __UNIX__ )
 #define HORIZONTAL_LINE   '-'
 #define VERTICAL_LINE     '|'
 #define CORNER_LEFT_UP    '+'
 #define CORNER_RIGHT_UP   '+'
 #define CORNER_LEFT_DOWN  '+'
 #define CORNER_RIGHT_DOWN '+'
#else
 #define HORIZONTAL_LINE   ''
 #define VERTICAL_LINE     ''
 #define CORNER_LEFT_UP    ''
 #define CORNER_RIGHT_UP   ''
 #define CORNER_LEFT_DOWN  ''
 #define CORNER_RIGHT_DOWN ''
#endif

/*
 * Some mode letters in bottom screen line
 */
#define MODE_TRAILING   'T'
#define MODE_CONTROL_Z  'Z'
#define MODE_INSERT     'i'
#define MODE_OVERWRITE  'o'

#define REG_ALPHANUM    'a'   /* Regular expression predefined macros */
#define REG_WHITESPACE  'b'
#define REG_ALPHA       'c'
#define REG_DECIMAL     'd'
#define REG_HEX         'h'
#define REG_LOWER       'l'
#define REG_UPPER       'u'

#define EOF_TEXT        "<=======   End of File   =======>"

/*
 * Use this sign for window letters after the alphabet string
 * has been exhausted.
 */
#define LAST_WINDOWLETTER       '+'


/* Moved from tdestr.h: */
/*
 * characters used in tdeasm.c to display eol and column pointer in ruler
 */
#if defined( __UNIX__ )
 #define EOL_CHAR        0x1c
 #define RULER_PTR       0x21
 #define RULER_FILL      0x2e
 #define RULER_TICK      0x2b
 #define LM_CHAR         0x6c
 #define RM_CHAR_RAG     0x3c
 #define RM_CHAR_JUS     0x7c
 #define PGR_CHAR        0x70
 /*
  * character used two separate vertical screens
  */
 #define VERTICAL_CHAR   0x7c
#else
 #define EOL_CHAR        0x11
 #define RULER_PTR       0x19
 #define RULER_FILL      0x2e
 #define RULER_TICK      0x04
 #define LM_CHAR         0xb4
 #define RM_CHAR_RAG     0x3c
 #define RM_CHAR_JUS     0xc3
 #define PGR_CHAR        0x14
 /*
  * character used two separate vertical screens
  */
 #define VERTICAL_CHAR   0xba
#endif
