------------------------------------------------------------------------------
TIPO DE DOCUMENTO	    : MANUAL DE USUARIO DE X1
LENGUAJE		    : ESPAOL
TIPO DE TEXTO		    : ASCII SIN FORMATO
JUEGO DE CARACTERES	    : IBM-PC ASCII
VERSION DEL PROGRAMA        : X1 v0.94h (beta)
ULTIMA ACTUALIZACION (mm-dd): 960521
ULTIMA NOTA DE REVISION     : TEXTO PRELIMINAR -- PUEDE HABER MODIFICACIONES
TRADUCIDO POR		    : J. Lupin
-------------------------------------------------------------------------------

    IMPORTANTE: No utilice este programa antes de haber ledo, comprendido
    y aceptado los trminos dispuestos en la licencia de uso.


		     ============================
			MANUAL DE USUARIO DE X1
			  UNA VISION GENERAL
		     ============================

   1.  Requerimientos mnimos de hardware.
   2.  Qu es? (resumen)
   3.  Cmo usar X1 (formato de la lnea de ordenes y repaso de las rdenes
       y opciones)
          Formato de la lnea de rdenes
	  Reglas de sintaxis de la lnea de rdenes
	  Ordenes de X1
	  Funciones de X1
   
   4.  Variables de entorno (mdulo de lenguaje)
   5.  Formatos y mtodos de compresin (visin general y ejemplos)
   6.  Nombres de los ficheros temporales.
   7.  Cdigos de salida.




1. Requisitos
=============

CPU  : 386sx o superior
RAM  : Se recomienda un mnimo de 4Mb de memoria.
S.O. : DOS/Win95 (DOS 3.3 o posterior)
       OS/2 (32-bits)
       NT/Win95

Para conseguir los mejores resultados, se recomienda obtener la versin del
programa especfica para su sistema operativo.

Tenga en cuenta que la memoria que X1 dice detectar es la cantidad de
memoria que el gestor DPMI le dice que existe -que es la memoria realmente
"visible"-.  Dependiendo del administrador de memoria  (DOS,  OS/2...) puede 
incluso estar empleando memoria  virtual  basada  en  disco,  en cuyo caso
el valor visualizado puede ser incluso superior a la  cantidad  de memoria 
fsica instalada en su sistema. Sin  embargo,  desde  el  punto  de vista de 
X1, es de menor importancia cmo  se  administra  la  memoria  que cunta 
memoria le permite emplear el gestor de memoria.


2. Qu es?
===========

Este programa es un compresor, es decir, comprime varios ficheros en un nico 
archivo.  Se maneja, en su totalidad, desde la lnea  de  rdenes  (o prompt 
del sistema)  y  los  procesos  de  compresin  y  extraccin  estn combinados
en un nico programa.  En el compromiso entre velocidad,  memoria y tamao del
archivo, X1 favorece este ltimo aspecto e intenta hacer el mximo uso posible 
de los recursos del sistema en que se ejecuta.

Sus caractersticas principales son:

* Introduccin del nuevo formato propio .X
* Compatible con ARJ,(PK)ZIP,LHA(RC),ZOO,HA,RAR
* Interfaz de usuario con mltiples idiomas.
* Contiene mtodos "experimentales" como resultado de la exploracin de 
  algoritmos de alto rendimiento. "Experimental" no significa inestable, sino
  ms bien que el mtodo puede no ser soportado en versiones futuras de X1.

El interfaz de la lnea de rdenes es similar al de  ZOO  y  HA,  pero  las
letras de las opciones se parecen ms a las de ARJ y LHA, teniendo poco que
ver con PKZIP.  Con un	poco  de  conocimiento	de  los  compresores  ms
populares, debera  ser  posible  pasar  por  alto  algunas  partes  de  la
documentacin.

3. Cmo usarlo	(formato de la lnea de rdenes y repaso de las rdenes y
===============  opciones)

A continuacin sigue es la especificacin del  programa. Si  X1 se comporta 
de forma diferente, entonces se debe bien a un error o a un fallo en 
la implementacin de la	funcin en cuestin, de acuerdo con esta especificacin.

El decir que X1 es un "compresor" producir un nmero de expectativas, basadas
en las capacidades de otros compresores. Consecuentemente, no slo es importante
decir lo que hace, sino tambin lo que NO ha sido implementado.

Si lo mencionado en el texto an no ha sido implementado, la seccin ser 
precedida por un mensaje "**No  implementado**". Estos mensajes irn 
disminuyendo en nmero en futuras versiones en el programa.

Formato de la lnea de rdenes
------------------------------

 X1 orden[<opciones>..] <archivo> [<especificacin de ficheros>..]

 Definiciones:
 
 orden[<opciones>..]  Slo se  permite  una  orden  (el  primer carcter)
		      seguida  por  una  serie  de  opciones -sin  espacios
		      entre orden y opciones ni entre las opciones-.
 <archivo>	      Es el nombre del archivo, la extensin por defecto es ZIP

 <esp. de ficheros>.. Son  los  ficheros a archivar, por defecto se consideran
                      todos  los  ficheros  si no se especifica ninguno. Se 
		      pueden utilizar los comodines (*,?).

Reglas de sintaxis de la lnea de rdenes
------------------------------------------
Ordenes y opciones pueden especificarse bien en maysculas o en minsculas.

Tenga en cuenta que X1 tiene dos opciones de exclusin del trayecto en lugar de
una como suele ser habitual en otros compresores.  Esto es consecuencia de 
las reglas #1 y #2.


   * Regla #1 (inclusin del path):
     -----------------------------
     Por defecto, todos los trayectos mencionados en la lnea de rdenes se
     aaden al archivo -a no ser que se active la opcin X.

   * Regla #2 (inclusin del path):
     -----------------------------
     Por defecto,  todos  los  trayectos  encontrados  durante  la  bsqueda
     recursiva (opcin "R") se aaden al archivo -a no	ser  que  se  active la
     opcin E-.  Esto es algo diferente a como lo hacen los otros compresores.

   * Regla #3 (varias especificaciones con respecto al mismo directorio):
     -------------------------------------------------------------------
     Con especificaciones sin un path explcito, se asume el path de  la
     especificacin anterior.

     Sea "x1 a test <arg[1]> .. <arg[i]> <arg[i+1]>.."

     Si <arg[i+1]> no contiene el carcter "\" ("/") o ":" entonces se asume
     que trabaja en el mismo  directorio  que <arg[i]> (que a su vez puede
     trabajar bajo el bajo el mismo directorio que <arg[i-1]>, etc.)

     Qu significa esto?  Significa que:
		       "x1 a prueba \dir1\dir2\*.c *.h"
     hace lo mismo  que:
		       "x1 a prueba \dir1\dir2\*.c \dir1\dir2\*.h"

     Qu NO significa esto?  Bien,
		       "x1 a prueba dir1\*.c dir2\*.h"
     << NO >> hace lo mismo que
     ^^^^^^^^
		       "x1 a prueba dir1\*.c dir1\dir2\*.h"
     porque "dir2\*.h" contiene un "\".

     Igualmente,
		       "x1 a prueba dir1 *.c"
     no funciona como
		       "x1 a prueba dir1\*.* dir\*.c"

     que realmente no tendra sentido.

     La justificacin para este convenio es nica y exclusivamente el
     ahorrar pulsaciones (obsrvese que no hizo falta repetir "\dir1\dir2\"
     en la lnea de rdenes en el primer ejemplo.

     Efectos laterales o inconvenientes?  Si quiere los ficheros del
     directorio actual, debe especificarlos TODOS antes de incluir los
     directorios. Sin embargo este convenio no debera restringir al
     usuario de ninguna manera.


     Regla #4 (directorios includos en el archivo):
     ----------------------------------------------

     Especificar un nombre de directorio en la lnea de rdenes implica  la
     compresin de todos los ficheros de ese directorio. Obsrvese que
		    "x1 a prueba \dir1\dir2"
     produce el mismo resultado que
		    "x1 a prueba \dir1\dir2\" y que
		    "x1 a prueba \dir1\dir2\*.*"
     Si se indica la opcin de recursin, TODOS los ficheros por debajo de
     \dir1\dir2 sern tambin procesados.

     Pero cuidado! Si los nombres de fichero son idnticos a los nombres
     de trayecto puede no ser obvio cul ser el resultado final...


				  ===========
				  = ORDENES =
				  ===========

H (visualiza comentarios de ayuda)
---------------------------------

Esta orden slo se emplea en el contexto "x1 ?", y visualizar un breve 
resumen de las rdenes y opciones. La pgina que se muestra NO ES la misma 
que sale cuando se ejecuta el programa sin parmetros. Si no se especifican 
parmetros, slo  se listan las rdenes posibles (entre ellas, "?").

Si la informacin se imprime demasiado deprisa, se recomienda dirigirla a
un fichero ("x1 ? >archivo.lst") que puede ser posteriormente visualizado con 
su visor favorito (F3 en El Comandante Norton) o en su editor favorito.

X1 habla muchos idiomas. Sin embargo, algunas lenguas fueron ms difciles de 
comprender que otras, as que no podemos garantizar que el significado de 
los mensajes sea  cristalino.  En caso de duda, deberan consultarse las 
pginas en ingls, dans, francs, alemn  y  espaol  (en este orden de 
prioridad!)

(En PC) Si la configuracin de pgina de cdigos de su ordenador est mal, 
el resultado ser que  faltarn  caracteres.  Es  recomendable  tomarse  el
tiempo necesario para configurar la pgina de cdigos correctamente.

A (aadir ficheros al archivo)
----------------------------------
Opciones vlidas: $,A,C,E,F,I,K,L,M,N,O,R,S,T,U,V,X,Y,Z

Esta orden tiene dos modos de operacin:
   * crear un archivo y aadir ficheros...
   * actualizar (re-abrir) el archivo y aadir ms ficheros...

Esta orden, bsicamente, comprime y aade los ficheros especificados a un 
archivo. En el caso de que el archivo nombrado no exista se creara uno con 
ese nombre. Si existe, entonces se actualiza. Esto significa que nuevos
ficheros con los mismos nombres que otros ficheros ya existentes en el 
archivo sobreescribirn a stos.  Existen unas pocas excepciones (cuando
se comprimen mdulos slidos), pero su explicacin se encuentra ahora fuera 
de contexto.

Si se omite un directorio base, se asume que el directorio actual ser el
directorio por defecto.

Si no se especifican ficheros en la lnea de rdenes, todos los  ficheros
(en el directorio por defecto) sern aadidos. Esto  significa	que  "x1  a
prueba test.x" comprime todo lo que haya en el directorio por defecto.

De ninguna forma es posible comprimir un archivo que est siendo actualizado 
dentro de s mismo.

Si no se especifica la extensin del archivo comprimido, entonces se supone
la extensin  ZIP.  Si  desea comprimir a otro formato, es necesario
especificar en el archivo la extensin de ese formato (ARJ,LZH,...).  No es
posible comprimir en archivos con extensiones arbitrarias.

Se puede evitar que algunos ficheros sean incluidos con el uso de la opcin
"Z".

Ejemplo (compresin en formato propio ):   x1 a archivo.x   mi_fich.doc
Ejemplo (compresin en formato ZIP):	   x1 a archivo.zip mi_fich.doc


C (aadir comentarios al archivo)
--------------------------------
**No implementado**
Opciones vlidas: I,C

Esta orden aade comentarios a un archivo. Pueden incluirse comentarios en los
formatos ARJ,ZIP,ZOO y X pero no en los LHA y HA, debido a diferencias en las 
estructuras de encabezamiento.


D (borrar ficheros de un archivo)
--------------------------------
Opciones vlidas: I,S,Z

Para ser borrada, la entrada correspondiente en el archivo tiene que ser igual 
que un argumento de la lnea de rdenes (se ignoran maysculas y minsculas)

Si una especificacin no contiene un trayecto, entonces surte efecto para
todas las entradas del archivo, sin tener en  cuenta  sus directorios. Esto
quiere decir que

		"x1 d prueba.x *.pas"
borrar incluso las entradas "dir1\dir2\*.pas" en el fichero (si las hay).
Por otro lado,
		"x1 d prueba.x dir1\dir2\*.pas"

slo eliminar el ltimo tipo de ficheros.

Si se solicita el borrado de todos los ficheros, entonces el mismo archivo
es eliminado (borrado).

Los nombres de fichero pueden ser excludos del borrado con la opcin "Z".

Ejemplos:
(borrado de mltiples entradas):  x1 d archivo.x *.pas *.doc
(borrado de un archivo completo): x1 d archivo *.*



E (extraer ficheros sin trayecto)
--------------------------------
Opciones vlidas: $,A,F,I,N,O,T,W,Y,Z

Esta rden es idntica a "X" con la opcin "E".  Est includa aqu slo
debido al consenso general entre programas compresores de utilizar esta orden.

Durante la descompresin o extraccin, la fecha y hora de los ficheros son 
restauradas junto con los contenidos.  Se lleva a cabo un control de CRC para 
verificar que la operacin ha tenido xito. Sin embargo, el fichero se verifica
ANTES de escribir al disco, en lugar de	una comprobacin de lectura y 
verificacin.

Los ficheros se pueden extraer a un directorio especificado por el usuario u 
otra unidad, pero por defecto, los ficheros se descomprimen en el directorio 
actual.  Todas las extracciones se hacen sin trayectos (es decir se 
descomprime todo en un nico directorio)

Cuando se extrae a un directorio especfico, entonces el nombre de directorio 
debe terminar con "/" o "\" como en "x1 e prueba.x c:\dir\".  Si no se termina 
el nombre de  directorio con tal carcter entonces X1 asumir que se intenta 
extraer del archivo un nico fichero.

Cuando se extrae a un directorio que no existe (especificado en la lnea de
rdenes), se advertir al usuario de ello y se le consultar antes de tomar 
ninguna accin.  El mensaje de advertencia presenta distintas soluciones desde
"si" (crear directorio por esta vez) a "nunca"  (no  crear  nunca directorios).  
El usuario responde tecleando la letra entre parntesis. Las letras y mensajes 
pueden cambiar para diferentes mdulos de idiomas. Es posible responder 
automticamente a las preguntas activando una de las opciones "Y" o "N".

Cuando se extrae a una unidad en concreto, se permite que la especificacin 
termine con ":" como en el ejemplo "x1 e prueba.x a:".  Esto se debe a que se 
asume que ningn nombre vlido de fichero termina en tal carcter. Si se dan 
varios directorios o unidades de destino "x1 e prueba.x a: b: c:" entonces
la ltima unidad (o directorio) especificada ser empleada en la extraccin.

Si se intenta extraer un fichero con el mismo nombre que un directorio ya 
existente el fichero extrado se pasar por alto (a no ser que  se  active
la opcin de "Sobreescritura Inteligente" con la opcin "W").

En el caso de que se intente extraer un fichero con el nombre de otro ya 
existente, se advertir al usuario de esta incidencia y se le consultar antes
de tomarse ninguna accin.  La nica excepcin a esta regla son los ficheros
de tamao nulo (0 octetos), ya que se considera que no contienen ninguna 
informacin valiosa y se pueden sobreescribir sin advertencias. La pregunta
que se formula al usuario permite diferentes respuestas, desde "s" 
(sobreescribe el fichero por esta vez) a "nunca" (no sobreescribir jams).
El usuario debe responder introduciendo la letra entre parntesis. 

Por ejemplo:
(extraer archivo):	x1 e archivo.x file_id.diz


F (refrescar los ficheros ya existentes en el archive)
------------------------------------------------------
**No implementado**
Opciones vlidas: E,F,I,X

Esta orden cambia un fichero que se encuentra dentro del archivo comprimido por
una versin ms moderna, de ser posible.  Esto significa que los nombres y el 
nmero total de ficheros dentro del archivo permanece constante. Slo cambia el
contenido de los ficheros ya archivados.

A la hora de buscar ficheros ms modernos que los existentes, slo se comprueban
la fecha y hora. Si los ficheros son ms antiguos -o tienen igual fecha y hora
aunque tamao diferente- entonces no se tienen en cuenta a la hora de refrescar.

Podran surgir conflictos en caso de que el archivo contenga entradas con 
trayectos completos.  Debera ser necesario especificar estas entradas 
explcitamente? La respuesta escogida es: no!.  En vez de eso hay es 
necesario excluirlas con la opcin "E" -si por  algn  motivo  no  deben
refrescarse como los otros ficheros.

De forma similar a la orden "A", si no	hay  ficheros  especificados en la
lnea de rdenes, se intentan refrescar todos los ficheros presentes en el
archivo.  Esto significa que "x1 f prueba.x" intenta refrescar todos los 
ficheros en "prueba.x", mientras que "x1 f prueba.x *.pas" slo intenta 
refrescar los  ficheros  *.pas  (incluyendo  posiblemente los ficheros 
dir1/dir2/*.pas).  Para excluir que estos ltimos  sean  excluidos hay utilizar
"x1 fz prueba.x *.pas dir1/dir2/*.pas" 

Ejemplo:
(refrescar todos los ficheros) "x1 f prueba.x"

L (listado del contenido del archivo)
-------------------------------------
Opciones vlidas: E,I,O,Z

Esta orden muestra la informacin usual acerca de los contenidos del archivo, 
incluyendo:

* trayecto completo
* tamao original y comprimido
* ndice de compresin (% comprimido/descomprimido)
* fecha (de la forma da-mes-ao)
* hora (de la forma horas-minutos-segundos)
* CRC (16-32 bits)
* atributos del fichero, al estilo DOS.
* mtodo de compresin (identificado por un nmero en lugar de un nombre)

Un asterisco "*" aadido al final de un nombre indica que el fichero est
encriptado y por tanto no puede ser extrado.

Se intenta "encajar" en las columnas los nombres de los trayectos completos. 
Si hay espacio completo para los nombres largos se muestran en la misma lnea
que la informacin adicional. En caso contrario, se pone una lnea para el 
nombre del fichero y la informacin adicional se mueve a la lnea siguiente.

Es posible mostrar todos los archivos de formatos especficos con "x1 l *.lzh"
o de todos los archivos reconocidos por el compresor "x1 l *" (que slo 
comprueba ficheros con una extensin conocida  ARJ,ZIP,etc..)  Es posible 
mostrar slo ficheros especficos "x1 l *.zip file_id.diz" o mltiples 
ficheros como en "x1 l *.zip *.nfo *.diz". 

Si la informacin se muestra demasiado deprisa,	se recomienda dirigir la
salida a un fichero ("x1 l *.zip > archivo.lst")  que puede ser luego
visualizado con su visor favorito (F3 en El Comandante Norton) o en su editor 
favorito.

Por ejemplo:
(listar todos los *.ARJ, *.ZIP...):	x1 l *


T (comprobar la integridad del contenido de un archivo)
-------------------------------------------------------
Opciones vlidas: E,F,I,O,Z

Esta orden en realidad tiene dos modos de operacin o motivos:
* verificar que el archivador no ha cometido errores durante la compresin.
* buscar errores infligidos en el archivo durante la transmisin (errores
  del medio de almacenamiento o del canal de transmisin)

Con mucho, el primer tipo de error es el ms alarmante.  Por eso es el error 
que se comprueba usualmente.  As, los datos del archivo se desempaquetan 
en memoria.

Para asegurar el xito de la posible extraccin, se proporciona una funcin de 
validacin mediante un test de CRC (cdigo de redundancia cclica). Aunque el 
proceso no es 100% seguro, es usualmente suficiente para la mayor parte de 
casos prcticos.

Es posible comprobar los contenidos completos de varios archivos: "x1 t *.zip",
ficheros individuales en un grupo de archivos "x1 t *.zip *.doc" o ficheros 
individuales en archivos individuales "x1 t archivo.x leeme.doc"

Si se asume que el compresor ha hecho su trabajo apropiadamente, entonces
se puede hacer una comprobacin de CRC ms simple y rpida.  Esta comprobacin 
se hace con la opcin F.  Cmo saber si el compresor ha hecho su trabajo bien? 
Bien, intntese una comprobacin de CRC	tradicional una sola vez (inmediatamen-
te despus de la compresin).  Si no hay errores, despus slo pueden esperarse
errores de CRC debidos a la transmision o almacenamiento defectuosos.

Se informa al usuario acerca de diferencias entre el CRC almacenado y el valor 
de CRC calculado.  En caso de errores, es muy poco probable  que los datos 
puedan ser recuperados (a no ser que se haya empleado alguna forma de ECC  
-cdigo corrector de errores-). Es posible a menudo actualizar ficheros con 
errores de CRC, pero no podemos recomendarlo.

Si se trabaja con archivos slidos, las comprobaciones de CRC pueden tardar un 
tiempo superior al normal.  Esto se produce debido al hecho de que la extraccin
puede presuponer la descompresin de otro fichero. En modo slido, los datos se
comprimen en su conjunto como un flujo continuo y esto reduce la accesibilidad.

Ejemplo:
(comprobar todos los ficheros): "x1 t prueba.x"

P (proteger el archivo contra errores)
--------------------------------------
Opciones vlidas: I,L

Esta orden hace que se aada al archivo un cdigo  corrector de errores (ECC), 
lo cual debera proteger al archivo, hasta cierto punto, de posibles errores 
posteriores de transmisin o almacenamiento.

No es posible aadir un mismo tipo de ECC ms de una vez.  En lugar de utilizar
mtodos simples ms de una vez se recomienda usar una tcnica ms sofisticada 
que implique un mayor gasto en tamao.

Al igual que los mtodos de compresin sobre datos tienen diferentes 
rendimientos, los mtodos de correccin de errores deben ser optimizados para
clases concretas de errores.  A no ser que se proceda as, el resultado ser
un costo mayor con un resultado pobre.  Por tanto, en el futuro estarn 
disponibles una gama ms amplia de mtodos de proteccin contra errores.

El mtodo de proteccin por defecto es el "ECC de nivel 1".

ECC de nivel 1:

Este tipo de cdigo de ECC est pensado para el usuario casual,	que quiere 
una seguridad baja con slo un mnimo de coste en trmino de tamao extra. Slo 
puede compensar la prdida de un sector! El tamao del sector es configurable, 
por defecto es de 512 octetos. Si se quiere compensar para errores de ms de 
un sector, se deben utilizar mayores niveles de proteccin. Si se protege un 
sector de N octetos de longitud, el  coste  de tamao adicional ser de N+48 
octetos. Los 48 octetos cubren una cabecera incluyendo su propio CRC, un CRC 
del fichero completo y vectores de prueba empleados para localizar errores ms 
rpidamente. Los datos del  ECC sern colocados en un bloque continuo al 
comienzo del fichero.

ECC de nivel 2:
An por implementar.

*ATENCION* Los mtodos correctores  de errores slo corrigen un nmero limitado
de errores. Un mtodo slo corregir errores de acuerdo con su especificacin, 
por tanto no espere la correccin de errores ms all de la misma. La correccin
de errores slo proporciona una  seguridad  limitada. Es importante no tener 
una f ciega en los mtodos.

Ejemplo:
Para proteger contra la prdida de un nico sector de 512 octetos (disco floppy)
la orden a usar es "x1 p prueba.zip"  "xm1 p prueba.zip". Para aadir una 
proteccin ECC1 de 1024 octetos por sector (que son 2x512, de aqu m2) la 
orden a usar es "x1 pm2 test.zip"

R (reparar el archivo ante posibles errores)
--------------------------------------------
Opciones vlidas: I

Esta orden tiene dos propsitos o modos de operacin:
* Reparar errores en el archivo.
* Slo verificar que el archivo est libre de errores.
  Una comprobacin de CRC slo investiga las entradas de ficheros comprimidas
  en el archivo  -no la existencia de ECCs  posiblemente  errneos-.  
  Obviamente  el  "test extendido" puede (debe) ser nicamente llevado a cabo 
  si hay en efecto un ECC que comprobar.

Reparacin de un archivo con proteccin ECC:
Esta operacin elimina los errores -bien en los datos del ECC o en los  datos
reales que debe proteger. Un mensaje advertir si los errores no son suscep-
tibles de ser corregidos, en cuyo caso no se tomarn ms acciones.

Reparacin de un archivo sin proteccin ECC:
Este no ha sido nunca el propsito de esta orden. En X1 no hay una funcin 
genrica de "reparacin" de archivos daados. En lugar de eso se insta al 
usuario a que intente la extraccin del archivo  y  re-archive los datos 
de nuevo.  Los  problemas  que  plantea  una  funcin  de  reparacin genrica 
son bien conocidos por el programa "PKZipFix" que viene con el compresor
"PKZIP".  El programa de reparacin slo actualiza la estructura de cabecera 
del archivo  -sin  comprobar la integridad de los ficheros individualmente-.  
Despus de esto se pueden aadir ficheros al archivo. Sin embargo, sin un 
test de integridad, no hay forma de saber si el archivo contiene otros errores.
El no comprobar esta posibilidad puede provocar una falsa sensacin de seguridad.
Parece ms atractivo permitir slo la extraccin del archivo -permitiendo al 
usuario	verificar directamente el nmero de errores. Si hay archivos comprimidos
almacenados dentro del archivo en cuestin, existen la peligrosa posibilidad de 
que haya errores.  En tales casos, lo mejor ese que el usuario intente evaluar
la situacin. Si de alguna forma los usuarios estuviesen interesados (y deseando
pagar), entonces  podra construirse un programa avanzado de recuperacin de 
errores para alguno o todos los formatos diferentes de compresin.  Pero ello 
no cambiar el hecho de que la mayor parte de los errores normalmente son 
irrecuperables.

Ejemplo: "x1 r prueba.x"

U (desproteger archivo - eliminando cdigo corrector de errores)
----------------------------------------------------------------
Opciones vlidas: I

Esta orden deshace la accin efectuada por la orden "P".  Se intentarn borrar
todos los cdigos de ECC disponibles.  Los fallos en la localizacin del 
cdigo ECC pueden deberse a dos razones: que no haya cdigos ECC o que haya 
errores en la cabecera que impidan la localizacin del cdigo ECC.  En el 
segundo caso debera recomendarse el intentar eliminar los errores.

Se recomienda comprobar si hay errores antes de eliminar el cdigo  ECC.
Aunque el proceso se las puede arreglar para localizar el cdigo ECC el archivo
puede an contener errores en otras posiciones del fichero.  No  se hace 
ningn tipo de comprobacin de errores cuando se elimina el cdigo ECC
(para acelerar el proceso).

X (extraccin de ficheros con trayectos completos)
--------------------------------------------------
Opciones vlidas: $,A,E,F,I,N,O,T,W,Y,Z

La diferencia fundamental con la orden "E" es que los ficheros son 
descomprimidos con el trayecto completo (tal y como est almacenado en el 
archivo). Los trayectos completos pueden verse antes de la  extraccin	con
la orden "L".

Los ficheros pueden extraerse a un directorio o unidad especificados por el
usuario pero por defecto los ficheros se descomprimen en el directorio
actual y los subdirectorios posibles son construidos segn se necesite a partir
de este directorio base.  Algunos trayectos no pueden ser empleados como  
extensin del directorio base, y son aquellos  que  contienen  nombres de 
unidad  o especifican trayectos desde  el  directorio  raz.  Tales trayectos
sern posicionados en el disco de acuerdo a sus especificaciones absolutas.

Cuando se extrae a un directorio o unidad especficos,	los  subdirectorios
sern construidos desde la posicin dada. Por ejemplo "x1 x prueba.x a:"
intentar extraer todos los ficheros a A: (e intentar construir los 
subdirectorios desde el directorio actual en esa unidad)

Cuando la extraccin requiera un trayecto no existente en el disco, la situacin
se trata como cuando se  extrae a un directorio no existente especificado en 
la lnea de rdenes.  El usuari ser avisado acerca de la incidencia y se le 
consultar antes de tomar acciones.

				  ============
				  = OPCIONES =
				  ============

$ (aadir o extraer etiqueta de volumen)
----------------------------------------
**No implementado**

Compresin:
Aade la etiqueta de volumen del disco (para la	primera especificacin de
ficheros) al archivo.  En el ejemplo "x1 a texto.x *.* a:*.* b:*.* c:*.*"
se aade al archivo la etiqueta de volumen de la unidad actual porque se us 
en la primera especificacin. "x1 a texto.x a:*.* b:*.* c:*.*" hace que se 
almacene la etiqueta de volumen de la unidad "a:".

Extraccin:
Restaura la etiqueta del disco (si est presente) del  archivo al disco
donde los ficheros sern extrados. Dado que slo se permite una etiqueta
de volumen en el archivo, no hay posibilidad de confusin.


A (almacenar/restaurar atributos)
---------------------------------
**No implementado**

Nota general: Esta opcin esta pensada especialmente para los "atributos
especiales" tales como los atributos extendidos de OS/2. Los atributos simples 
como los de MSDOS siempre son restaurados.

Compresin:
Guarda todos los atributos (posiblemente extendidos) en el archivo.

Extraccin:
Restaura los atributos (posiblemente extendidos). Los atributos que dependen 
del sistema operativo empleado slo pueden recuperarse bajo el mismo sistema 
operativo.  En  caso de conflicto, los atributos o bien no se restauran o se 
escoge una sustitucin adecuada y simple.


C (leer los comentarios desde un fichero)
-----------------------------------------
**No implementado**

Slo puede usarse con la orden "C".

Hay dos formas de aadir comentarios a un archivo:
* introducirlas desde el teclado.
* insertar caracteres desde un fichero.

Si el comentario va a ser tecleado, la opcin "C"  no  se  activa.  Si	los
comentarios vienen de un fichero, entonces debe usarse esta opcin.


E (excluir trayecto de los nombres de fichero)
----------------------------------------------

Esta opcin se comporta de forma  distinta  segn  la  orden  que  se  est
ejecutando (A,E,F)

Compresin (A):

Excluye los trayectos que se encuentran en la bsqueda recursiva de 
directorios.  A no ser que se active esta opcin, por defecto el compresor 
incluir todos los trayectos que encuentre.

Extraccin (E):

Esta funcin se asegura de que todos los  ficheros sean extrados en el mismo 
directorio, sin tener en cuenta	los trayectos almacenados en el archivo.

Refrescar (F):

La funcin aqu es evitar renovar ficheros en subdirectorios dentro del
archivo. De lo contrario, todos los ficheros son refrescados sin tener en
cuenta si estn o no en subdirectorios.


F (mover los ficheros dentro/fuera del archivo)
-----------------------------------------------
**No implementado**

Compresin:

Se borran los ficheros del disco tan pronto como hayan  sido comprimidos y 
se establezca que la operacin ha tenido xito, as se garantiza una seguridad 
extra, de modo que si la operacin se interrumpe prematuramente, no debera 
producirse ninguna prdida de datos.

Extraccin:

Se reduce el tamao del archivo, eliminando las  entradas que corresponden a
los ficheros extrados.


I (modo silencioso)
-----------------------
** No implementado **

Esta opcin suprime toda la salida por pantalla, incluyendo la cabecera del 
programa y los indicadores de progreso.  Esta opcin se implementa para permitir
a otros programas llamar a X1 y dejar que el compresor procese los datos sin 
llenar la pantalla de datos irrelevantes.


K (sobreescribir el archivo ya existente)
---------------------------------------
** No implementado **

Compresin:
La funcin es forzar la creacin de un archivo comprimido nuevo. De no utilizar
esta opcin, de existir un archivo con el mismo nombre sera actualizado y se 
aadiran nuevas entradas a las ya existentes.


L<nmero> (nivel de compresin)
------------------------------

Compresin:

Determina un nivel ms detallado de compresin.  Esto puede implicar el uso de 
ms memoria -o una compresin ms rpida y/o degradada-	dependiendo del mtodo 
escogido.

Esta opcin slo tiene efecto en el mtodo 4 del formato de compresin .X. Los
niveles vlidos son 0,1,2 y 3. Cada nivel determina un modelo de memoria distin-
to.


M<mtodo> (mtodo de compresin)
--------------------------------

Compresin:

Especifica el mtodo de compresin a utilizar. El mtodo se especifica como
un nmero entre 0 y 256. Si el nmero no puede asociarse con un mtodo vlido 
de compresin, se visualiza un mensaje de error.


N (Asumir "NO" en todas las preguntas)
-------------------------------------

Extraccin:

La opcin "N" es la opuesta de la opcin "Y".  Responde de antemano a todas las
posibles preguntas de X1 con un "NO".  De esta forma se impide que el programa 
se detenga y pregunte al usuario. Principalmente afecta la posible sobreescri-
tura de ficheros, creacin de directorios, etc. 


O (ordenar ficheros por nombre, tamao, fecha, etc.)
----------------------------------------------------
**No implementada **

Deben siempre aparecer dos caracteres 'O' en la cadena de  opciones en la lnea
de rdenes.  En la seccin 'O...O' aparecern las sub-opciones de clasificacin,
que definen las claves de ordenacin y sus prioridades.	Sin embargo, si la 
opcin 'O' es la ltima opcin que aparece entonces  la  ltima  'O' puede 
obviarse.

Las posibles sub-opciones son:
       A: ascendo
       D: fecha
       E: extensin
       N: nombre
       P: nombre de trayecto
       S: tamao
       T: hora

       B: mejor compresin

As, por ejemplo, OSNO significa: primero ordenar por tamao, y si dos fi-
cheros tienen el mismo tamao, entonces ordena segn el nombre.

Compresin:

Si se comprime creando un nuevo archivo, los ficheros se insertan dentro
del archivo en el orden especificado por las claves de ordenacin. Si se 
actualiza el archivo, las entradas existentes sern actualizadas de acuerdo a 
la ordenacin ya existente, y las nuevas entradas sern ordenadas segn las 
opciones.

Extraccin:
Los ficheros son extrados en el orden determinado por las opciones.

Ejemplo:
Ordenar los ficheros comprimidos por fecha, hora y nombre, en este orden.
			    "x1 aodsno prueba.x *.*"


R (bsqueda recursiva de directorios)
------------------------------------

Compresin:

Sin esta opcin, slo se procesarn los ficheros de los directorios especificados por la
lnea de rdenes.  Se asumir el directorio por defecto all donde no se hayan 
defnido los directorios de forma explcita. Al activar esta opcin, se 
procesarn, adems,  todos los ficheros de los subdirectorios.  Estos 
subdirectorios sern visitados recursivamente en el orden en que se encuentran 
en el disco.  Se expanden los trayectos de los ficheros almacenados en el
archivo segn se vayan visitando los diferentes subdirectorios, a no ser que
se active la opcin "E". Los ficheros se visitan dos veces: primero durante 
una bsqueda inicial y despus cuando se realiza el proceso de compresin.  
La bsqueda inicial se hace para poder estimar un tamao de las cabeceras de 
archivos slidos y para visualizar el indicador de progreso.


S  (cambia la fecha y hora del archivo a la del fichero ms nuevo)
------------------------------------------------------------------
** No implementado **

Compresin:

Aparecen tres posibilidades prcticas cuando se cambia la fecha y hora	del
archivo:

* seleccionar la fecha y hora ms moderna de entre las entradas aadidas al 
  archivo actualizado.
* seleccionar la fecha y hora ms moderna de entre las entradas ya existentes 
  al archivo antes de comenzar a actualizarlo.
* seleccionar la fecha y hora ms moderna de entre todos los ficheros una vez 
  que se ha realizado la actualizacin.

En la implementacin actual, slo se ha includo la ltima tcnica.

Una forma fcil de poner la fecha y hora del archivo, cuando no se desean aadir
entradas extras al fichero es con "x1 lis prueba.x", que hace que se listen 
(pero no visualicen) todos los contenidos del fichero y cambie la fecha
y hora del archivo en el proceso.


T (cambiar la fecha y hora de los ficheros conforme a la hora actual)
-------------------------------------------------------------------
**No implementado**

Compresin:

Esta opcin pone la fecha y hora actuales como la fecha y hora de los ficheros 
aadidos al archivo.  La fecha y hora original de los archivos es ignorada.

Extraccin:

Marca el fichero extrado con la fecha y hora actual, en lugar de la fecha y 
hora almacenadas por el compresor.

Nota: Todos los ficheros en un proceso recibirn la misma fecha y hora. Incluso
aunque los ficheros sen procesados con varios segundos de diferencia, todos 
recibirn la misma fecha y hora, cuando el proceso comenz.


U  (modo de compresin slida)
------------------------------

Compresin:

Si slo se comprime un fichero, esta opcin no tiene efecto. Pero si se van a 
comprimir varios ficheros, con esta opcin sern comprimidos en "modo slido". 
Esto quiere decir que los ficheros son comprimidos como un flujo de datos 
continuo (como si estuviesen concatenados).  Para ficheros relacionados entre 
s debera resultar en una mejor compresin.

Para una compresin ptima, los ficheros deberan ser agrupados inteligente-
mente, de forma que los ficheros que ms tengan que ver entre s sean puestos 
lo ms juntos  posible.  Sin  embargo,  en  la  implementacin actual esto no 
se hace de forma automtica.

V<tamao> (proceso de mltiples volmenes)
------------------------------------------
** No implementada **

Compresin:

Si no especifica ningn <tamao>, la compresin se har mediante un archivo
de mltiples volmenes limitado en tamao por el espacio en disco disponible.
Despus de cada volumen, aparecer una pregunta (a no ser que se haya dado
la opcin "Y") lo cual permite la inserci de un nuevo disco.  La compresin
continuar con otro fragmento del archivo. 

En cualquier caso, el resultado final debiera ser una secuencia de archivos
con igual nombre y con las extensiones .x00, .x01, etc. donde .x00 contiene
el primer fragmento.

No es posible actualizar un archivo multivolumen en modo multivolumen. Pero
es posible actualizar un archivo multivolumen con entradas adicionales 
normales - o actualizar un archivo no-multivolumen con entradas multivolumen.

Extraccin:
Aqu <tamao> no tiene importancia.  Slo debera intentarse la extraccin
sobre una secuencia completa de archivos multivolumen. Si se intenta extraer
un fragmento individual de un archivo multivolumen slo se tendr xito con
las entradas que no pasen de un slo volumen.  


W (sobreescritura inteligente en la extraccin)
-----------------------------------------------
** No implementado **

Extraccin:

Esta opcin trata de solventar de forma inteligente ciertas situaciones donde
los ficheros a extraer sobreescribiran ficheros ya existentes debido a que
tienen el mismo nombre.  Tradicionalmente, estas situaciones se resuelven
al usuario si se desea sobreescribir -e impidiendo la extraccin en caso de
que se responda que no-.  Existe una tercera posibilidad, donde los ficheros
son extrados con nombres ligeramente diferentes. Las extensiones .00X, .01X
(no confundir con los tipos de archivo .X)  se utilizan para la resolucin
de colisiones en la extraccin.

X (exclur el trayecto en los ficheros de la lnea de rdenes)
-------------------------------------------------------------

Compresin:

Por defecto, todos los trayectos escritos en la lnea de rdenes sern
includos en los nombres de ficheros aadidos al archivo. Si se  especifica
un directorio con "x1 a prueba.x dir\*.*" los trayectos "dir\fich1" y 
"dir\fich2" sern almacenados en el archivo. La opcin "X" evita  esto.  
"x1  ax prueba.x dir\*.*" grabar las entradas anteriores como "fich1" y 
"fich2". Tenga en cuenta  que esta opcin no afecta a los nombres de trayecto
almacenados durante la bsqueda recursiva con la opcin "R".  Para eliminar
tales trayectos debe usarse la opcin "E".

Extraccin:

Esta opcin no tiene efecto en este caso.  Debe utilizarse la opcin "E" para 
excluir los trayectos de los ficheros a extraer.


Y  (Responder "SI" a todas las preguntas)
-----------------------------------------

Extraccin:

La opcin "Y" es la contraria de la opcin "N".  Responde de antemano a todas
las posibles preguntas con  un	"s".  De  esta  forma se impide que el programa
se detenga y pregunte al usuario.  Principalmente afecta la posible 
sobreescritura de ficheros, creacin de directorios, etc.


Z<nmero> (excluir los ficheros que seran archivados)
-----------------------------------------------------

Compresin:

Cuando esta opcin no se utiliza, todas las especificaciones de ficheros en la
lnea de rdenes determinan ficheros a incluir en  el archivo.  Cuando esta 
opcin se utiliza pero no es seguida por un nmero ste se supone que es el 1.
Este nmero especifica cuntas de las ltimas especificaciones de ficheros
encontradas en la lnea de rdenes especifican ficheros a excluir. Esta 
convencin no permite la mezcla de mscars de inclusin y de exclusin.  TODAS 
las mscaras de exclusin deben ser especificadas juntas y al final de la
lnea de rdenes.

Por ejemplo en "x1 az3 prueba.x prueba1.* prueba2.* *.bak *.swp *.tmp"
entonces el nmero 3 que sigue a la opcin "Z" dice que las ltimas tres 
especificaciones marcan ficheros que NO deben ser incluidos en el archivo.
El nmero cuenta hacia atrs desde el final de la lnea de  rdenes y por
tanto no se ve afectado por el nmero de mscaras de inclusin.

En caso de que el nmero de opciones de exclusin iguale o exceda al nmero
total de mscaras en la lnea de rdenes, se incluirn los ficheros "*.*" y
los ficheros especificados sern excludos.


4. Variables de entorno
========================

En la versin actual  slo  se  soporta  una  variable  de  entorno,  la
variable "COUNTRY" que se utiliza para la seleccin del  lenguaje-juego  de
caracteres.

En el DOS, se puede emplear la variable de entorno COUNTRY para especificar
el pas y el juego de caracteres activo.  Los caracteres especiales, 
dependientes del idioma, son soportados en el grupo de caracteres ASCII
superior (posiciones 128 hasta 255) y pueden cambiar segn la configuracin.
Segn el juego de caracteres, los caracteres dependientes del idioma pueden
cambiar de posicin en la tabla ASCII, si es que estn disponibles. Cuando se 
necesitan tales caracteres, es importante determinar el juego de caracteres 
en primer lugar.

Por ejemplo, la configuracin para un teclado norteamericano podra ser:

			  COUNTRY=001,437

El "001" determina el idioma para los Estados Unidos,  mientras  que  "437"
especifica la pgina de cdigos 437 (juego de  caracteres  norteamericano).
Consulte en su manual del DOS la lista detallada de nmero y sus asociaciones.
Para X1, entonces, "001" hara que los mensajes se visualizasen en ingls. El  
"437"  hace que los posibles caracteres extendidos sean buscados en las
posiciones correspondientes a la pgina de cdigos 437.

Si por alguna razn prefiere no utilizar la variable COUNTRY, se puede usar
la variable LANGUAGE en su lugar, con la misma sintaxis.

Observese que si una sentencia o frase no est soportada para el idioma actual,
el mensaje original en ingls ser visualizado  (a falta de nada mejor).


5. Formatos y mtodos de compresin (nivel de usuario)
======================================================

En primer lugar una visin general de los formatos de  cabecera  y  mtodos
soportados.

Compresor X1, versin 0.94a ("+" indica que est soportado y "-" lo contrario)
------------------------------------------------------------------------------
    nombre de  capaz de visualizar
    compresor  |   capaz de extraer
	       |   |   capaz de comprimir
	       |   |   |   mtodos soportados de compresin
	       |   |   |   |	  mtodos de descompresin soportados
	       |   |   |   |	  |	     comentarios
	       |   |   |   |	  |	     |
    arj        +   +   +   0,1	  0,1,2,3,4  1,..,4 bsicamente idnticos
    zip        +   +   +   0,1,8  0,1,7,8    1:shrink,7:implode,8:deflate
    lzh/lha    +   +   +   0,5	  0,1,5      no hay soporte de LHA-AMIGA!
    zoo        +   +   +   0,2	  0,2
    ha	       +   +   +   0,1,2  0,1,2
    tar        +   -   -   -	  -
    tgz        +   +   +   8	  8	     requiere cabeceras TAR gzipadas
    hap        +   +   +   0,1    0,1
    rar        +   -  (+)  0      0
    arc        +   -   -   -	  -
    pak        +   -   -   -	  -
    sqz        +   -  (+)  0	  0
    arx        +   -  (+)  0	  0,1 (5)    algoritmos como en LHA1.13
    put        +   +   +   0,5	  0,5	     algorithos como en LHA2.x
    x	       +   +   +   0,1,.. 0,1,..
------------------------------------------------------------------------------
(+) significa que slo almacenar no es tan divertido.

Acerca del modulo ARJ:
---------------------

Un ejemplo de compresin al formato ARJ sera: "x1  a prueba.arj *.*"
Esto hace que todos los archivos en el directorio actual sern comprimidos al 
archivo prueba.arj (por defecto con el mtodo 1)

Slo almacenar (sin comprimir) con: "x1 am0 prueba.arj *.*"

Los ficheros ARJ multivolmenes no son (de momento) soportados.

Acerca del mdulo ZIP:
---------------------

Un ejemplo de compresin al formato ZIP sera: "x1 a prueba.zip *.*"

Esto hace que todos los archivos sean comprimidos por defecto con el mtodo
"deflate" del ZIP, conocido de las versiones 2.x.  Si se requiere compati-
bilidad con versiones anteriores, es posible comprimir con un mtodo ms 
antiguo: "x1 am1 prueba.zip *.*". Esto aplica el mtodo "shrink" de la 
versiones ZIP 0.9 y 1.1.  No espero que se d ningn uso serio a este
mtodo, data de mis primeros y humildes intentos con el formato ZIP, en 1991...

Acerca del modulo LHA:
---------------------

Un ejemplo en la compresin al formato LHA sera: "x1 a prueba.lha *.*" o 
"x1 a prueba.lzh *.*". Las extensiones .lha y .lzh son igualmente soportadas. 
Por defecto se utiliza el mtodo 5.

Acerca del mdulo ZOO:
----------------------

Un ejemplo de compresin al formato ZOO sera: "x1 a prueba.zoo *.*"

ATENCION: El formato ZOO especifica dos tipos de encabezamiento y slo uno
es actualmente soportado por X1 (el tipo 2, que es el ms habitual).  Esto
puede provocar problemas cuando X1 actualice ficheros antiguos creados	con
ZOO (tipo de encabezamiento 1). Tal vez est siendo demasiado cauto, no s...
Envinme por email varios ejemplos con cabeceras antiguas!

Acerca del mdulo HA:
--------------------

Un ejemplo de compresin al formato HA sera: "x1 a prueba.ha *.*"

Esto hace que todos los ficheros por defecto en el directorio actual sean
archivados con el mtodo 1..ASC.  Si se requiere una compresin mayor por medio
de un PPM de 4 orden sera ms apropiado usar (HSC): "x1 am2 prueba.ha *.*"

Dejar que  el ordenador intentase ambos mtodos y eligiese el mejor 
automticamente sera: "x1 am# prueba.ha *.*"

Acerca del mdulo TGZ:
---------------------

Un ejemplo de compresin al formato TAR+GZIP sera: "x1 a prueba.tgz *.*"

Esto hace que todos los  ficheros  sean  "envueltos"  en  cabeceras  TAR  y 
despus comprimidos al formato GZIP. En plataformas que soporten nombres de
ficheros ms largos una extensin ms apropiada para el archivo sera  
"tar.gz." Cuando se listan los contenidos de un tal archivo, se necesita la
total descompresin (en memoria), as que puede ser necesario  un  poco  de
paciencia.

Actualmente, no es posible extraer los contenidos de un fichero  GZIP  como
un nico fichero.

Acerca del mdulo X:
-------------------

Algo que no est directamente relacionado con ningn mtodo de compresin
(pero que distingue al formato X de los dems tipos de archivo) es  el
almacenamiento del doble CRC (capacidad de comprobacin rpida del CRC). Se
calcula el CRC de los datos no comprimidos y comprimidos.  Cuando se quieren 
comprobar los errores de transmisin, con mirar el ltimo campo de CRC es 
suficiente. Dado que el tamao de los datos comprimidos normalmente  es 
menor que el tamao oriignal el trabajo del clculo extra del CRC es
normalmente insignificante. No ralentiza el proceso de forma significativa.

Ntese adems que los archivos .X pueden contener ms de un fichero con el 
mismo nombre.  Esto no puede evitarse cuando hay entradas en modo slido
de por medio.  Si la entrada slida con los nombres duplicados es borrada
entonces los otros ficheros tambin son borrados (ya que estn comprimidos 
juntos) lo cual resultar en la prdida de  datos.  Este  problema poda 
evitarse "pretendiendo" que  un	nombre duplicado simplemente no est ah 
(sin mostrarlo, como en UC2 o en HPACK). Pero pareca razonable que, si 
est realmente ah, el usuario debera poder verlo... un convenio ms!

Nmero de mtodo Nombre Packing example     Comentarios
---------------- ----	------------------- --------
      1 	 XLZ	"x1 am1 prueba.x *.*" Ventana LZ77 de  64K
     (2)          -
     (3)          -
      4 	 XXC	"x1 am4 prueba.x *.*" Posible seleccin de memoria
                                              variable.
                                              Requiere memoria de DOS (1Mb)
     (5)         LZP    "x1 am5 prueba.x *.*"
  mejor mtodo	  -	"x1 am# prueba.x *.*"
---------------  ---	--------------------

NOTA: Para el mejor mtodo se intentarn el mtodo 4 y  despus  el  1.  El
mtodo aceptado finalmente ser el que ofrezca el menor tamao.

ATENCION: El mtodo >4 est  siendo  actualmente  objeto  de  estudio... no
esperar compatibilidad con futuras versiones!

El mdulo X soporta el formato slido. Un ejemplo de compresin en  formato
slido podra ser: "x1 aum1 prueba.x *.*".  Un archivo puede contener varias 
entradas slidas independientes -y pueden ser mezcladas libremente con
entradas normales de un slo fichero-. Una vez creada, un entrada slida no 
puede ser actualizada.

Para verificar un fichero comprimido,  comprobando la integridad por la
capacidad de descompresin: "x1 t prueba.x *.*"

Para verificar un archivo comprimido buscando errores de transmisin: 
"x1 tf prueba.x *.*"

S, esto le  da  a  la	opcin	"F"  (forzar el fichero adentro/afuera) otro
significado (comprobacin rpida de CRC) cuando se comprueban ficheros. Sin
embargo, esto no restringe el uso de la opcin su funcin original, ya que
no tiene sentido "forzar" la entrada o salida de ficheros de un archivo durante
el proceso de test.

Intentar hacer una comprobacin rpida de CRC en otros formatos que no soportan
doble CRC resultar en una comprobacin normal -ms lenta- de CRC.

Unas breves palabras del mtodo 4:

Se emplea la opcin de "nivel de compresin" de la siguiente manera: 
     "x1 am4l2 prueba.x *.*"
     ... significa en realidad compresin de nivel 2 (<4Mb. de memoria)

		Nivel Memoria  Comentario
		  0	640kb  El administrador de memoria puede pedir 1Mb.
		  1	  3Mb  -
		  2	  7Mb  -
		  3	 16Mb  Imposible de probar -no tengo 16Mb. de RAM

Recuerde siempre que el mtodo 4 puede cambiar de nuevo!

6. Nombres temporales de fichero
================================

Mientras se comprime, el programa utiliza un fichero temporal "X???????.SWP" 
(donde ??..?? son caracteres escogidos al azar). Contiene el nuevo archivo
que est siendo construido. Si la  operacin parece tener xito, a este
fichero se le pone el nombre solicitado.

Durante la extraccin, puede ocurrir que una entrada del archivo extrado tenga
el mismo nombre que el propio archivo. En este caso, el archivo original se
renombra temporalmente a un nombre neutro (X???????.SWP) y borrado, una vez
que todas las entradas solicitadas hayan sido extradas.

En ningn caso hay ms de 3 ficheros abiertos (durante la actualizacin  de
un archivo antiguo). Una vez en funcionamiento, el programa utilizar  como
mximo un fichero temporal -y un nico nombre para el mismo, X??????.SWP.

La extensin puede parecer un poco confusa. El fichero temporal  NO  ES  un
fichero de intercambio (swap file).  Al final, este fichero sera renombrado
y sus contenidos no se copian en ningn otro sitio-.  Pero la extensin
debera ser asociada a los ficheros temporales de otros programas (compiladores
Borland) que pueden causar menos resquemor al usuario a la hora de borrarlos.

Dado que los ficheros de intercambio no son necesario, no se soportan 
directorios de trabajo especiales. Para una velocidad ptima, el proceso de
compresin debera tener lugar en una unidad de disco virtual.  Y los ficheros 
resultantes deberan ser copiados al destino deseado.


7. Cdigos de salida
====================

Referencia interna Valor  Comentario
------------------ ----- -----------------------------
 EXIT_OK	     0	   Sin errores
 EXIT_INT_ERR	     1	   Error interno (?)
 EXIT_NO_MEM	     2	   Memoria agotada
 EXIT_NO_DISK	     3	   Espacio de disco agotado
 EXIT_NO_OPEN	     4     No se pudo abrir el archivo
 EXIT_NO_TMP	     5	   No se pudo abrir el fichero temporal
 EXIT_NO_FOUND	     6	   No se pueden encontrar los ficheros
 EXIT_NO_PATH	     7	   No se puede encontrar trayecto
 EXIT_NO_BASE	     8	   No se puede acceder al directorio base
 EXIT_NO_MKDIR	     9	   No se puede crear directorio
 EXIT_BREAK	     10    Interrumpido por el usuario
 EXIT_FILE_ERR	     11    Error de fichero descnocido -- no se pudo leer
 EXIT_BAD_HDR	     12    Directorio del archivo (parcialmente) corrompido
 EXIT_BAD_EXT	     13    Los contenidos del archivo no se corresponden con la
			   extensin
 EXIT_BAD_ARC	     14    Seguro que es un archivo?
 EXIT_LONG_NO	     15    Demasiados argumentos. Formato no soportado.
 EXIT_LONG_PATH      16    Trayecto demasiado largo.
 EXIT_NO_OVERRIDE    17    No se puede anular el trayecto base
 EXIT_NEST	     18    Directorios demasiado anidados
 EXIT_SCRIPT_ERR     19    Errores en el fichero de guin
 EXIT_NOTHING	     20    Nada que hacer
 EXIT_UNSP	     21    Mtodo no soportado en esta versin
 EXIT_COM	     22    Orden desconocida
 EXIT_OPT	     23    Opcin desconocida
 EXIT_OPT_DIR	     24    Opcin desconocida
 EXIT_OPT_WR	     25    Opcin desconocida
 EXIT_OPT_VIEW	     26    Opcin desconocida
 EXIT_WC_FORM	     27    Uso inapropiado de comodines
 EXIT_WC_NAME	     28    Uso inapropiado de comodines
 EXIT_WC_COMPL	     29    Uso inapropiado de comodines
 EXIT_CHG_WRPROT     30    Intento fallido de modificar el archivo
			   (protegido contra escritura)
 EXIT_CHG_DEL	     31    Intento fallido de cambiar el archivo (borrado)
 EXIT_CHG_UNI	     32    Intento fallido de cambiar el archivo
			   (modo slido de compresin)
 EXIT_CHG_MULTI      33    Intento fallido de cambiar el archivo (multivol)
 EXIT_CHG_CR	     34    Intento fallido de cambiar el archivo (encriptado)
 EXIT_CHG_UNCR	     35    Intento fallido de cambiar el archivo (no encriptado)
 EXIT_BAD_KEYFILE    36    Clave incorrecta (encriptacin)
 EXIT_PASS_NO	     37    Identificacin (de usuario) no vlido (encriptacin)
 EXIT_PASS_DIFF      38    Verificacin de password fallida (encriptacin)
 EXIT_SECURITY	     39    Error general de seguridad (encriptacin)
 EXIT_NOCRYPT	     40    Imposible manejar archivo encriptado


------------------------------------------------------------------------------

Stig Valentini, x1develop@internet.dk (1996 - /3/1997)

------------------------------------------------------------------------------
