echo off
REM This utility batch file optimizes program COMpaction.
if "%2" == "" goto help

COMPACK -i %1 %2
:try_again
if errorlevel 16 goto pklite
if errorlevel 15 goto LZEXE
if errorlevel 14 goto driver
if errorlevel 13 goto finish
if errorlevel 12 goto try_EXE2BIN
if errorlevel 11 goto try_EXEPACK
if errorlevel 10 goto try_COM2EXE
if errorlevel 1  goto try_COPY
goto finish

:pklite
rem pklite is a shareware utility available from PKWARE Inc.
pklite -x %1 PACK$.$$$
if exist PACK$.$$$ goto COMPACK
go try_COPY

rem UNLZEXE is a public domain utility.
rem N.B. COMPACK already incorporates header optimization
rem performed by external utilities such as PKWARE's HDROPT.
rem N.B. UNLZEXE may not always work correctly.  Test carefully.
:LZEXE
UNLZEXE %1 PACK$.$$$
goto COMPACK

REM The EXE2BIN utility is included with DOS.
:try_EXE2BIN
EXE2BIN %1 PACK$.$$$
:COMPACK
if errorlevel 1  goto try_COPY
COMPACK PACK$.$$$ %2
del PACK$.$$$
if errorlevel 1  goto try_COPY
goto finish

REM UNPACK.EXE is supplied by V Communications Inc. to reverse EXEPACK
REM Alternatively UPACKEXE (part of LZEXE 0.91 PACKage) could be used.
REM LZEXE is a freeware package by Fabrice Bellard.
:try_EXEPACK
UNPACK %1 PACK$.$$$
goto COMPACK


REM COM2EXE is supplied with the COMPACK PACKage.
:try_COM2EXE
COM2EXE %1 PACK$.$$$
goto COMPACK

:help

echo Copyright (C) 1991 W. J. Collis
echo .
echo This REPACK utility batch file optimizes program compaction by reversing
echo as required any previous less efficient compaction methods.  If
echo further compaction is not possible, REPACK will perform a simple COPY.
echo .
echo Usage:-   REPACK input_program output_program
goto finish

Rem At least we could try to optimize the device header.
:driver
COMPACK -h %1 %2
goto try_again

:try_COPY
del PACK$.$$$
COPY %1 %2 /V
:finish
