/* REXX program to summarize the messages in a Yarn folder
 *
 * usage: foldsum folder
 */
main:
    parse arg folder

    if folder = "" then do
	say "usage: foldsum folder"
	return
    end

    file = folder
    if stream(file, "c", "open read") \= "READY:" then do
	file = value("HOME", , "OS2ENVIRONMENT") || "\mail\" || file
	if stream(file, "c", "open read") \= "READY:" then do
	    say "cannot open" folder
	    return
	end
    end

    subjectWidth = 52
    fromWidth = 20
    linesWidth = 5
    whiteSpace = "2009"X

    say "Folder:" file
    say
    say left("Subject", subjectWidth) left("From", fromWidth) "Lines"
    say copies('-', subjectWidth) copies('-', fromWidth) copies('-', linesWidth)

    nMsgs = 0
    do while chars(file) > 0
	msgSize = readLong(file)
	if msgSize > 1048576 then return /* folder is corrupt */
	msg = charin(file, , msgSize)
	call scanHeaders
	say left(header.!subject, subjectWidth) left(header.!from, fromWidth),
	    right(header.!lines, linesWidth)
	nMsgs = nMsgs + 1
    end
    say "----"
    say nMsgs
return

/* Read 32-bit unsigned integer from stream. */
readLong: procedure
    parse arg file
    b0 = c2d(charin(file))
    b1 = c2d(charin(file))
    b2 = c2d(charin(file))
    b3 = c2d(charin(file))
return b0 + 256*(b1 + 256*(b2 + 256*b3))

/* Get next message line. */
getLine: procedure expose msg cur
    lineEnd = pos('0A'X, msg, cur)
    if lineEnd = 0 then
        line = ""
    else
        line = substr(msg, cur, lineEnd-cur)
    cur = lineEnd + 1
return line

/* Get message author's name from From: header. */
getAuthor: procedure expose header. whiteSpace
    p = pos('(', header.!from)
    if p > 0 then do
	p = p + 1
	e = pos(')', header.!from, p)
	if e < 1 then e = length(header.!from)+1
	header.!from = substr(header.!from, p, e-p)
    end
    else do
	p = pos('"', header.!from)
	if p > 0 then do
	    p = p + 1
	    e = pos('"', header.!from, p)
	    if e < 1 then e = length(header.!from)+1
	    header.!from = substr(header.!from, p, e-p)
	end
	else do
	    p = pos('<', header.!from)
	    if p > 1 then
		header.!from = left(header.!from, p-1)
	end
    end

    p =	verify(header.!from, whiteSpace);
    if p > 0 then
	header.!from = substr(header.!from, p)
return

/* Scan message headers. */
scanHeaders:
    header.!lines = ""
    cur = 1
    line = getLine()
    do while length(line) > 0
	select
	    when abbrev(line, "Subject:") then do
		header.!subject = substr(line, verify(line, whiteSpace, , 10))
	    end
	    when abbrev(line, "From:") then do
		header.!from = substr(line, 7)
		call getAuthor
	    end
	    when abbrev(line, "Lines:") then do
		header.!lines = substr(line, verify(line, whiteSpace, , 8))
	    end
	    otherwise do
		/* nothing */
	    end
	end
	line = getLine()
    end
return
