Program T_Sign;

Var

  InFile,
  OutFile,
  SigFile   : Text;

  InBuffer,
  OutBuffer,
  SigBuffer : Array[1..4096] of Char;

  S1,S2     : String;

  Function StUpCase(S : String) : String;
  Var
    SLen : Byte Absolute S;
    x    : Integer;
  Begin
    For x := 1 To SLen Do S[x]:=UpCase(S[x]);
    StUpCase := S;
  End;


Begin

  WriteLn(#10#10#10#13'TerMail message signing... *FREEWARE* by Bo Bendtsen');
  If ParamCount<>2 Then
  Begin
    WriteLn(#10'Syntax : T-SIGN textfile-to-sign signature-file');
    WriteLn(   'Example: T-SIGN CURRENT.MSG T-SIGN.SIG');
    WriteLn(   '         TM.CFG -> SHIFTF4 T-SIGN !MSG T-SIGN.SIG !R');
    Halt;
  End;

  Assign(SigFile,Paramstr(2));
  SetTextBuf(SigFile,SigBuffer);
  {$I-} Reset(SigFile); {$I+}
  If IOResult<>0 Then
  Begin
    WriteLn(#10'Signature file not found: ',Paramstr(2));
    Halt;
  End;

  Assign(InFile,Paramstr(1));
  SetTextBuf(InFile,InBuffer);
  {$I-} Reset(InFile); {$I+}
  If IOResult<>0 Then
  Begin
    Close(SigFile);
    WriteLn(#10'File to sign not found: ',Paramstr(1));
    Halt;
  End;


  Assign(OutFile,'TMP.SIG');
  SetTextBuf(OutFile,OutBuffer);
  {$I-} Rewrite(OutFile); {$I+}
  If IOResult<>0 Then
  Begin
    Close(InFile);
    Close(SigFile);
    WriteLn(#10'Could not create temporary file TMP.SIG');
    Halt;
  End;

  S2:='';

  While Not Eof(InFile) Do
  Begin
    ReadLn(InFile,S1);
    If Pos('--- TER',StUpcase(S1))<>1 Then WriteLn(OutFile,S1)
    Else Begin
      S2:=S1;
      Break;
    End;
  End;

  While Not Eof(SigFile) Do
  Begin
    ReadLn(SigFile,S1);
    WriteLn(OutFile,S1);
  End;

  If S2<>'' Then WriteLn(OutFile,S2);

  While Not Eof(InFile) Do
  Begin
    ReadLn(InFile,S1);
    WriteLn(OutFile,S1)
  End;

  Close(InFile);
  Close(OutFile);
  Close(SigFile);

  Erase(InFile);
  Rename(OutFile,Paramstr(1));

End.
