{$A+,B-,D-,E+,F-,G-,I+,L-,N-,O-,P-,Q-,R-,S+,T-,V+}
{$M 16384, 0, 16384}
Program SetComX;

 { (C) 07/1993, 01/1996 by Matthias Paul <MPaul@IBH.RWTH-Aachen.de>     }
 { Last edit: 1996-01-03 -mp                                            }
 {                                                                      }
 { Crude mini-utility to change the account of COM devices, reported by }
 { the system BIOS. Sometimes this is necessary for testage purposes or }
 { to force programs to realize that more than the standard 2/4 ports   }
 { are installed.                                                       }
 { Additionally a device driver like COMMBIOS should be loaded to fully }
 { support those extra ports. Additionally information can be found in  }
 { my ACOM package.                                                     }

 Const
  CR         = $0D;   { Carriage Return ^ M                             }
  BS         = $08;   { Backspace       ^ H                             }
  ESC        = $1B;   { ESC             ^ [                             }

 Var
  s : String;
  c : Byte;
  i : Integer;
  b : Byte;
  v : Byte;
  e : Boolean;

 Procedure WriteANSIYellow;
  Begin
   Write(Chr(ESC), '[0;1;33;40m', Chr(CR));
  End; {WriteANSIYellow}

 Procedure WriteANSIWhite;
  Begin
   Write(Chr(ESC), '[0;1;37;40m', Chr(CR));
  End; {WriteANSIWhite}

 Procedure WriteANSIRed;
  Begin
   Write(Chr(ESC), '[0;1;31;40m', Chr(CR));
  End; {WriteANSIRed}

 Procedure WriteLnANSINorm;
  Begin
   WriteLn('    ', Chr(ESC), '[0m', Chr(BS), Chr(BS), Chr(BS), Chr(BS), '    ');
  End; {WriteLnANSINorm}

 Begin
  WriteANSIYellow;
  Write('SETCOMx V1.20 (C) 1993, 1996 by Matthias Paul');
  WriteLnANSINorm;
  e := FALSE;
  s := ParamStr(1);
  Val(s, c, i);
  v := Mem[$0040:$0011];   { equipment entry         }
  b := (v AND $0E) SHR 1;  { account of serial ports }

  If (ParamCount = 1) Then
   If (i = 0) Then
    Begin
     If (c In [0..7]) Then
      Begin
       Mem[$0040:$0011] := (v AND $F1) OR (c SHL 1);
       b := c;
      End
     Else
      Begin
       WriteANSIRed;
       Write(' Error: Parameter value out of range!');
       WriteLnANSINorm;
       e := True;
      End;
    End
   Else
    Begin
     WriteANSIRed;
     Write(' Error: Invalid parameter!');
     WriteLnANSINorm;
     e := True;
    End
  Else
   Begin
    WriteANSIRed;
    Write(' Error: Wrong number of parameters (expecting one parameter)!');
    WriteLnANSINorm;
    e := True;
   End;

  If (e = True) Then
   Begin
    WriteLn(' Syntax: SETCOMX <account of serial ports 0..7>');
    WriteLn;
   End;

  WriteLn(' Equipment entry: ', b, ' serial ports are introduced to the system.');
 End.
