/* File cdpath.c
**
** Program to Generate CDPATH environmental Variable
**
** Usage: CDPATH <filename> <drivelist>
**    where <filename> is name of file to write Command to
**          <drivelist> is list of drives to search
*/
#include <stdio.h>
#include <dos.h>
#include <string.h>

#define  MAX_DIR 68
int npath = 0;		/* No. of path specs in CDPATH */
FILE *fp;

char tmppath[100][MAX_DIR];

/* ################### ORDERPATH ############################# */
void orderpath(void)
{
	int i,	cdpathno = 0;	/* Level of CDPATH# variable */
	static char cdpath[256];
	
	qsort(tmppath[0], npath, sizeof(char) * MAX_DIR, strcmp);

	sprintf(cdpath, "set cdpath=%s",  tmppath[0]);
	
	for (i = 1; i < npath; i++)
	{
		if (strlen(cdpath) + strlen(tmppath[i]) > 254)
		{
			fprintf(fp, "\n%s\n", cdpath);
			printf("\n%s\n", cdpath);
			cdpathno++;
			sprintf(cdpath, "set cdpath%d=%s", cdpathno, tmppath[i]);
		}
		else
		{
			strcat(cdpath, ";");
			strcat(cdpath, tmppath[i]);
		}
	}
	fprintf(fp, "\n%s\n", cdpath);
	printf("\n%s\n", cdpath);
	return;
}
	
/* ####################### PATHFIND ######################### */
int pathfind(char path[])
{
	/* Function recursively searches through drive to find all directories
	** that have subdirectories
	** path: starting directory path
	*/
	struct find_t find;
	char test[MAX_DIR];
	char *ptr;
	int root;

	root = 0;
	strcpy(test, path);
	ptr = strchr(test, '\0');
	if (*(ptr - 1) == '\\')
		strcat(test, "*.*");
	else
	{
		strcat(test, "\\*.*");
		ptr++;
	}

	if (_dos_findfirst(test, 0xffff, &find) == 0)
	{
		if ((find.attrib & _A_SUBDIR) && (find.name[0] != '.'))
		{
			strcpy(ptr, find.name);
			pathfind(test);
			*ptr = '\0';
			if (root == 0)
			{
				strlwr(path);
				strcpy(tmppath[npath++], path);
				root = 1;
			}
		}
		while (_dos_findnext(&find) == 0)
		{
			if ((find.attrib & _A_SUBDIR) && (find.name[0] != '.'))
			{
				strcpy(ptr, find.name);
				pathfind(test);
				*ptr = '\0';
				if (root == 0)
				{
					strlwr(path);
					strcpy(tmppath[npath++], path);
					root = 1;
				}
			}
		}
	}
	return root;
}

/* ########################## CDPATH ############################## */
int main(int argc, char *argv[])
{
	char path[MAX_DIR];
	int i;
	
	if ((argc < 3) || (strchr(argv[1], '?') != (char *)NULL))
	{
		printf("\nUsage:   CDPATH  <filename> <drive> [<drive> ...]\n\n");
		printf("         <filename> is name of file to write command to\n");
		printf("         <drive> is letter of drive to serach\n\n");
		return 0;
	}

	if ((fp = fopen(argv[1], "a")) == (FILE *)NULL)
	{
		printf("\nUnable to open file %s!\007", argv[1]);
		return 0;
	}

	for (i = 2; i < argc; i++)
	{
		path[0] = argv[i][0];
		path[1] = ':';
		path[2] = '\\';
		path[3] = '\0';
		if (pathfind(path) == 0)
		{
			if (npath > 0)
				strcpy(tmppath[npath++], path);
		}
	}
	orderpath();
	return 0;
}

