-- Temporarily save hd_device.management_ip to be used for hd_driver_param
-- below

CREATE TABLE hd_device_temp AS SELECT object_id, management_ip FROM hd_device;

-- Remove column hd_device.management_ip

DROP INDEX idx_device_name;

CREATE TABLE temp AS SELECT object_id, name, driver_url FROM hd_device;
DROP TABLE hd_device;
CREATE TABLE hd_device (
    object_id INTEGER PRIMARY KEY,
    name VARCHAR(512) NOT NULL,
    driver_url VARCHAR(256)
);
INSERT INTO hd_device SELECT * FROM temp;
DROP TABLE temp;

CREATE INDEX idx_device_name ON hd_device(name);

-- Temporarily save hd_operating_system.agent_ip_address to be used for 
-- hd_operating_system_driver_param below

CREATE TABLE hd_os_temp AS SELECT object_id, agent_ip_address FROM hd_operating_system;

-- Remove column hd_operating_system.agent_ip_address

DROP INDEX idx_os_names;

CREATE TABLE temp AS SELECT object_id, name, server_name, driver_url FROM hd_operating_system;
DROP TABLE hd_operating_system;
CREATE TABLE hd_operating_system (
    object_id INTEGER PRIMARY KEY,
    name VARCHAR(256) NOT NULL,
    server_name VARCHAR(256),
    driver_url VARCHAR(256)
);
INSERT INTO hd_operating_system SELECT * FROM temp;
DROP TABLE temp;

CREATE INDEX idx_operating_system_name ON hd_operating_system(name, server_name);

-- Migrate hd_device_auth_info to hd_driver_param

CREATE TABLE hd_driver_param (
    device_object_id INTEGER NOT NULL REFERENCES hd_device(object_id),
    key VARCHAR(256) NOT NULL,
    value BYTEA NOT NULL,
    CONSTRAINT uq_hd_driver_param UNIQUE(device_object_id, key)
);

INSERT INTO hd_driver_param (device_object_id, key, value) SELECT object_id, 'ip-address', DECODE(management_ip, 'escape') FROM hd_device_temp;
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'ipmi-username', DECODE(username, 'escape') FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'ipmi';
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'ipmi-password', password FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'ipmi';
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'ssh-username', DECODE(username, 'escape') FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'ssh';
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'ssh-password', password FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'ssh';
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'telnet-username', DECODE(username, 'escape') FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'telnet';
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'telnet-password', password FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'telnet';
INSERT INTO hd_driver_param (device_object_id, key, value) SELECT device_object_id, 'snmp-community', password FROM hd_auth_info, hd_device_auth_info WHERE hd_device_auth_info.auth_info_id = hd_auth_info.object_id AND hd_device_auth_info.protocol = 'snmp';

DROP INDEX idx_device_auth_info_fks;
DROP TABLE hd_device_auth_info;
DROP TABLE hd_device_temp;

-- Migrate hd_operating_system_auth_info to hd_operating_system_driver_param

CREATE TABLE hd_operating_system_driver_param (
    os_object_id INTEGER NOT NULL REFERENCES hd_operating_system(object_id),
    key VARCHAR(256) NOT NULL,
    value BYTEA NOT NULL,
    CONSTRAINT uq_hd_os_driver_param UNIQUE(os_object_id, key)
);

INSERT INTO hd_operating_system_driver_param (os_object_id, key, value) SELECT object_id, 'ip-address', DECODE(agent_ip_address, 'escape') FROM hd_os_temp;
INSERT INTO hd_operating_system_driver_param (os_object_id, key, value) SELECT os_object_id, 'ssh-username', DECODE(username, 'escape') FROM hd_auth_info, hd_operating_system_auth_info WHERE hd_operating_system_auth_info.auth_info_id = hd_auth_info.object_id AND hd_operating_system_auth_info.protocol = 'ssh';
INSERT INTO hd_operating_system_driver_param (os_object_id, key, value) SELECT os_object_id, 'ssh-password', password FROM hd_auth_info, hd_operating_system_auth_info WHERE hd_operating_system_auth_info.auth_info_id = hd_auth_info.object_id AND hd_operating_system_auth_info.protocol = 'ssh';
INSERT INTO hd_operating_system_driver_param (os_object_id, key, value) SELECT os_object_id, 'snmpv3-username', DECODE(username, 'escape') FROM hd_auth_info, hd_operating_system_auth_info WHERE hd_operating_system_auth_info.auth_info_id = hd_auth_info.object_id AND hd_operating_system_auth_info.protocol = 'snmpv3';
INSERT INTO hd_operating_system_driver_param (os_object_id, key, value) SELECT os_object_id, 'snmpv3-password', password FROM hd_auth_info, hd_operating_system_auth_info WHERE hd_operating_system_auth_info.auth_info_id = hd_auth_info.object_id AND hd_operating_system_auth_info.protocol = 'snmpv3';
INSERT INTO hd_operating_system_driver_param (os_object_id, key, value) SELECT os_object_id, 'snmp-community', password FROM hd_auth_info, hd_operating_system_auth_info WHERE hd_operating_system_auth_info.auth_info_id = hd_auth_info.object_id AND hd_operating_system_auth_info.protocol = 'snmp';

DROP INDEX idx_os_auth_info_fks;
DROP TABLE hd_operating_system_auth_info;
DROP TABLE hd_os_temp;
DROP TABLE hd_auth_info;

-- Increase size of column hd_attribute.value to 2048

CREATE TABLE temp AS SELECT device_object_id, key, value FROM hd_attribute;
DROP TABLE hd_attribute;
CREATE TABLE hd_attribute (
    device_object_id INTEGER NOT NULL REFERENCES hd_device(object_id),
    key VARCHAR(256) NOT NULL,
    value VARCHAR(2048) NOT NULL,
    CONSTRAINT uq_hd_attribute UNIQUE(device_object_id, key)
);
INSERT INTO hd_attribute SELECT * FROM temp;
DROP TABLE temp;

-- Increase size of column hd_operation_group_attribute.value to 2048

CREATE TABLE temp AS SELECT group_object_id, key, value FROM hd_operation_group_attribute;
DROP TABLE hd_operation_group_attribute;
CREATE TABLE hd_operation_group_attribute (
    group_object_id INTEGER NOT NULL REFERENCES hd_operation_group(object_id),
    key VARCHAR(256) NOT NULL,
    value VARCHAR(2048) NOT NULL,
    CONSTRAINT uq_hd_op_group_attribute UNIQUE(group_object_id, key)
);
INSERT INTO hd_operation_group_attribute SELECT * FROM temp;
DROP TABLE temp;

-- Increase size of column hd_operating_system_attribute.value to 2048

CREATE TABLE temp AS SELECT os_object_id, key, value FROM hd_operating_system_attribute;
DROP TABLE hd_operating_system_attribute;
CREATE TABLE hd_operating_system_attribute (
    os_object_id INTEGER NOT NULL REFERENCES hd_operating_system(object_id),
    key VARCHAR(256) NOT NULL,
    value VARCHAR(2048) NOT NULL,
    CONSTRAINT uq_hd_os_attribute UNIQUE(os_object_id, key)
);
INSERT INTO hd_operating_system_attribute SELECT * FROM temp;
DROP TABLE temp;

-- Migrate hd_object_instance to hd_persistent_mbean

CREATE TABLE hd_persistent_mbean (
    object_id INTEGER PRIMARY KEY,
    object_name VARCHAR (512) NOT NULL,
    class_name VARCHAR(512) NOT NULL,
    object_id_ INTEGER NOT NULL,
    time_stamp BIGINT NOT NULL,
    CONSTRAINT uq_hd_persistent_mbean UNIQUE(object_name)
);

INSERT INTO hd_persistent_mbean (object_id, object_name, class_name, object_id_, time_stamp) SELECT hd_object_instance.object_id, object_name, class_name, hd_device.object_id, time_stamp FROM hd_object_instance, hd_device WHERE class_name = 'com.sun.hss.domain.internal.ServerMXBeanImpl' AND hd_device.name = substring(object_name from 37);
INSERT INTO hd_persistent_mbean (object_id, object_name, class_name, object_id_, time_stamp) SELECT hd_object_instance.object_id, object_name, class_name, hd_operating_system.object_id, time_stamp FROM hd_object_instance, hd_operating_system WHERE class_name = 'com.sun.hss.domain.internal.OperatingSystemMXBeanImpl' AND position(hd_operating_system.server_name IN object_name) > 0;

DROP TABLE hd_object_instance;

-- Modify schema version

UPDATE hd_schema_version SET version='1.5';
