#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to run the DDL for N1 Grid Controller Jobs. NOTE
# that the N1GSPS postmaster ***MUST*** be running for
# this script to work. 
#

. /opt/sun/n1gc/bin/n1hss_common.sh

# BASE=/opt/sun/N1_Grid_Service_Provisioning_System_5.0/server/postgres
PSQL=$BASE/bin/psql
USER=roxadmin
PASS=roxOdin
DBNAME=rox
DDL=/opt/sun/n1gc/upgrade/upgrade1.4-1.5.sql
PORT=5433

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

if [ `uname` = "SunOS" ]; then
    /usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER -p $PORT -f $DDL $DBNAME
else
    /usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER $DBNAME -p $PORT -f $DDL
fi

STATUS=$?

if [ $STATUS -eq 0 ]; then
    ${N1HSS_JAVA} -ea -classpath /opt/sun/n1gc/lib/domain.jar:/opt/sun/n1gc/lib/persistence:/opt/sun/n1gc/lib/persistence/c3p0-0.8.4.5.1.jar:/opt/sun/n1gc/lib/persistence/cglib-full-2.0.2.jar:/opt/sun/n1gc/lib/persistence/commons-collections-2.1.1.jar:/opt/sun/n1gc/lib/persistence/commons-logging-1.0.4.jar:/opt/sun/n1gc/lib/persistence/dom4j-1.4.jar:/opt/sun/n1gc/lib/persistence/ehcache-0.9.jar:/opt/sun/n1gc/lib/persistence/jta.jar:/opt/sun/n1gc/lib/persistence/odmg-3.0.jar:/opt/sun/n1gc/lib/persistence/hibernate2.jar:/opt/sun/n1gc/lib/persistence/postgresql.jar com.sun.hss.domain.internal.upgrade.Upgrade1_4To1_5
    exit $?
else
    exit $STATUS
fi

