DROP INDEX idx_port_info_device;
ALTER TABLE hd_device DROP COLUMN manufacturer;
ALTER TABLE hd_device DROP COLUMN model;
ALTER TABLE hd_device DROP COLUMN serial_number;
ALTER TABLE hd_device DROP COLUMN cpu_arch;
ALTER TABLE hd_device DROP COLUMN cpu_count;
ALTER TABLE hd_device DROP COLUMN cpu_speed;
ALTER TABLE hd_device DROP COLUMN memory_size;
ALTER TABLE hd_device DROP COLUMN state;

DROP TABLE hd_port_info;

CREATE TABLE hd_cache_value (
    object_id INTEGER PRIMARY KEY,
    object_name VARCHAR(512) NOT NULL,
    attribute VARCHAR(256),
    value BYTEA,
    time_stamp TIMESTAMP,
    throwable BYTEA
);

CREATE SEQUENCE seq_hd_cache_value_id;

ALTER TABLE hd_operating_system ADD COLUMN support_monitoring INTEGER;
ALTER TABLE hd_operating_system ALTER COLUMN support_monitoring SET DEFAULT 0;
ALTER TABLE hd_operating_system ALTER COLUMN support_monitoring DROP DEFAULT ;
ALTER TABLE hd_operating_system ALTER COLUMN support_monitoring SET NOT NULL;

update hd_schema_version set version='1.3';

CREATE TABLE hd_geprofiles (
   geprofile_id serial,
   name varchar(255) not null,
   type varchar(255) not null,
   appname varchar(255) not null,
   active varchar(5) not null,
   admin_homedir varchar(1024) not null,
   admin_uid integer,
   admin_username varchar(1024) not null,
   execd_port integer, 
   inst_version varchar(1024) not null,
   lnx_nfs_mt_opts varchar(1024) not null,
   loadCritical float8,
   loadWarning float8,
   maxPendTime float8,
   memCritical float8,
   memWarning  float8,
   nfs_mount_point varchar(1024) not null,
   nfs_server_name varchar(1024) not null,
   proxy_host varchar(1024) not null,
   master_port integer,
   sge_cell varchar(1024) not null,
   sge_root varchar(1024) not null,
   sol_nfs_mt_opts varchar(1024) not null,
   primary key (geprofile_id)
);
