#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to run the DDL for upgrading the services tier schema
# NOTE that the N1GSPS postmaster **MUST** be running for this script to work. 
# from 1.1 to 1.2.  
# schema version 1.1 corresponds to N1SM version 1.2.
# schema version 1.2 corresponds to N1SM version 1.3.
#

. /opt/sun/n1gc/bin/n1hss_common.sh

PSQL=$BASE/bin/psql
USER=roxadmin
PASS=roxOdin
DBNAME=rox
DDL="/opt/sun/n1gc/upgrade/services_db_upgrade1.1-1.2.sql"
PORT=5433

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

for ddl in `echo $DDL`
do
    if [ `uname` = "SunOS" ]; then
	/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER -p $PORT -f $ddl $DBNAME
    else
	/usr/bin/env PGPASSWORD=$PASS $PSQL -U $USER $DBNAME -p $PORT -f $ddl
    fi
done

. /opt/sun/n1gc/hd_authorization_manager_db.sh

exit $?
