DROP SEQUENCE seq_hd_firmware_object_id;
DROP TABLE hd_firmware_install_info;
DROP TABLE hd_device_type;
DROP TABLE hd_firmware_package;

CREATE TABLE hd_firmware_package (
    object_id INTEGER NOT NULL PRIMARY KEY,
    name VARCHAR(256) NOT NULL,
    type VARCHAR(256),
    version VARCHAR(32),
    make VARCHAR(256) NOT NULL,
    description VARCHAR(256),
    image_size BIGINT,
    image VARCHAR(1024),
    CONSTRAINT uk_hd_firmware_package UNIQUE(name, version)
);

CREATE TABLE hd_device_type (
    object_id INTEGER NOT NULL PRIMARY KEY,
    make VARCHAR(256) NOT NULL,
    model VARCHAR(256) NOT NULL,
    validated BOOLEAN,
    firmware_package_id INTEGER NOT NULL 
        REFERENCES hd_firmware_package(object_id),
    CONSTRAINT uk_device_type UNIQUE(make, model, validated, firmware_package_id)
);

CREATE TABLE hd_firmware_install_info (
    object_id INTEGER NOT NULL PRIMARY KEY,
    device_object_name  VARCHAR(256) NOT NULL,
    install_date timestamp,
    release_date timestamp,
    type VARCHAR(256),
    version VARCHAR(128),
    provider VARCHAR(256),
    description VARCHAR(256),
    firmware_package_id INTEGER NOT NULL 
        REFERENCES hd_firmware_package(object_id)
);

CREATE SEQUENCE seq_hd_firmware_object_id ;
