#!/bin/sh
#
# Set up environment variables common to all scripts
#
 
if [ `uname` = "SunOS" ]; then
    SPS_SUBDIR=SUNWn1sps
    SCS_SUBDIR=SUNWscs
    N1HSS_JAVA=/usr/bin/java
    CACAO_SUBDIR=SUNWcacao
    JDMK_SUBDIR=SUNWjdmk
else
    SPS_SUBDIR=sun 
    SCS_SUBDIR=sun/scs
    N1HSS_JAVA=/usr/java/jdk1.5.0_02/bin/java
    CACAO_SUBDIR=sun/cacao/share
    JDMK_SUBDIR=sun/jdmk
fi

BASE=/opt/$SPS_SUBDIR/N1_Service_Provisioning_System_5.2/server/postgres
CR_CLI=/opt/$SPS_SUBDIR/N1_Service_Provisioning_System_5.2/cli/bin/cr_cli
ROX_HOME=/opt/$SPS_SUBDIR/N1_Service_Provisioning_System_5.2
CACAO_BASE=/opt/$CACAO_SUBDIR
JDMK_BASE=/opt/$JDMK_SUBDIR/5.1
IPMI_TOOL=/usr/sfw/bin/ipmitool
SCS_HOME=/opt/$SCS_SUBDIR

#use sps password from file , note that keys are hardcoded (cli.*)
AUTH_FILE=/opt/sun/n1gc/etc/auth/.authorization.properties
CLUI_USER=`cat $AUTH_FILE |awk 'BEGIN{FS="="}/cli.user/{print $2}'`
CLUI_PASS=`cat $AUTH_FILE |awk 'BEGIN{FS="="}/cli.pwd/{print $2}'` 

