#!/usr/bin/perl
# getDhcpIfc.pl - get the ip address of the network interface specified 
# in the first parameter (i.e. eth0).
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

my $dhcp_interface = $ARGV[0];
my $cmd;
my $arch = `uname`;
if ($arch =~ "SunOS")
{
  $cmd = '/usr/sbin/ifconfig '.$dhcp_interface.' | grep inet | awk \'{print $2}\'';
}
else
{
  $cmd = '/sbin/ip addr show dev '.$dhcp_interface.' | grep "inet"|grep "'. $dhcp_interface .'"';
}

my $ip = `$cmd`;
chomp($ip);
if($ip =~ /inet\s+(\d+\.\d+\.\d+\.\d+)\//) 
{
   $ip = $1;
}
printf $ip;
