#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to return all deployable appln plans
# inside N1GSPS
#
# echoes ":" delimited set of plan name(s)
#

. /opt/sun/n1gc/bin/n1hss_common.sh

#CLUI=/opt/SUNWn1sps/N1_Grid_Service_Provisioning_System_5.1/cli/bin/cr_cli

#
# List latest versions of all plans
#
PLANS=`$CR_CLI -cmd pdb.p.la -u $CLUI_USER -p $CLUI_PASS | cut -f 3 -d '|' | grep '/' | sed 's/^\///' | grep hotdog | xargs`

#
# Look for plans that have the variables of hdEnabled
#
for plan in $PLANS
do
	$CR_CLI -cmd pdb.p.co -plan NM:${plan} -u admin -p $CLUI_PASS | grep "var name='hdEnabled'" >/dev/null
	if [ $? -eq 0 ]
	then
		HD_PLAN_LIST=`echo ${plan}:${HD_PLAN_LIST}`
	fi
done
HD_PLAN_LIST=`echo $HD_PLAN_LIST | sed 's/\:$//'`
if [ $HD_PLAN_LIST ]
then
        echo $HD_PLAN_LIST
fi

exit 0
