#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# helper script to create/drop notification rule table in CR DB
#

. /opt/sun/n1gc/bin/n1hss_common.sh

if [ $# -eq 0 ]; then
   echo "Usage: $0 [create|delete]"
   exit 1
fi

flag=$1

LOG=/tmp/notification_db.log
PSQL=$BASE/bin/psql
PASSWD=roxOdin
USER=roxadmin
NAME=rox
FILE=/cr/hd_notification_rules.sql
PORT=5433
CMD1="DROP TABLE hd_notification_rules;"
CMD2="DROP SEQUENCE hd_notification_rul_rule_id_seq;"

LD_LIBRARY_PATH=$BASE/lib/
PGHOST=$BASE/socket
export LD_LIBRARY_PATH PGHOST

if [ "$flag" = "create" ]; then
    # create table
    /usr/bin/env PGPASSWORD=$PASSWD $PSQL -U $USER -p $PORT -f $FILE $NAME 2>&1 > $LOG  
    exit $?
else 
    # drop table
    /usr/bin/env PGPASSWORD=$PASSWD $PSQL -U $USER -p $PORT -c "$CMD1" $NAME 2>&1 > $LOG
    /usr/bin/env PGPASSWORD=$PASSWD $PSQL -U $USER -p $PORT -c "$CMD2" $NAME 2>&1 >> $LOG
fi

exit 0
