#!/usr/bin/python2.4
#
# usage: agent-updater.py <agent-filename-fullpath> <os-type> <server-name> <agent-ip>
#
# Note: os-type could be "linux", "solx86" or "solsparc"

import sys;
import commands
import re
import time

#
#   Wait for completion of job and return 1 => Failure
#                                         0 => Success
def wait_for_job_completion(output_data):

	SLEEP_TIME = 10
	x, job_id, y = output_data.split(" ")
	x, job_id, y = job_id.split("\"")
	if job_id.isdigit() != True:
		return 1
	print "Job id: ", job_id
	count = 0;
	print "Waiting for job to complete",
	while True:
		data = commands.getoutput("n1sh show job " + job_id)
		job_status = re.search("Status:.*Completed|Status:.*Err", data)
		if job_status == None:
			print ".",
			time.sleep(SLEEP_TIME)
		else:
			print " "
			if job_status.group().find("Completed") != -1:
				return 0
			else:
				return 1

#
# get fname from full path
#
def get_fname(f_name):
    list = f_name.split("/")
    list_size = len(list)
    if list_size > 0:
        return list[list_size - 1]

#
# check if os type is valid
#
def check_os_type(os_type):
    if os_type != "solx86" and os_type != "solsparc" and os_type != "linux":
	    print "Wrong os type, os type should be one of: linux, solx86 or solsparc "
	    return 1
    return 0

#
# check if agent file name is valid
#
def check_agent_name(os_type, agent_filename):
    if check_os_type(os_type) != 0:
        return 1
    else:
        fname = get_fname(agent_filename)
        if os_type == "solx86":
            if fname != "SUNWsolx86ag.pkg":
                print "Package name is incorrect"
                return 1
        if os_type == "solsparc":
            if fname != "SUNWsolsparcag.pkg":
                print "Package name is incorrect"
                return 1
        if os_type == "linux":
            if fname != "sunmc-linux-agent-1-1.i386.rpm":
                print "RPM name is incorrect"
                return 1
    return 0

#
# Print usage and exit
#
def print_usage_exit():
    print "USAGE:\n    agent-updater.py <agent-fullpath> <os_type> <server_name> <agent_ip>\n"
    print "    os_type: Possible values are:"
    print "             linux "
    print "             solx86 "
    print "             solsparc "
    sys.exit(1)

#
# Return True if agent is reachable
#
def is_agent_reachable():
    output = commands.getoutput('uname')
    if output != None and output == "SunOS":
        PING_CMD = 'ping '
    else:
        PING_CMD = 'ping -c 1 '
    status, output =  commands.getstatusoutput(PING_CMD + agent_ip)
    if status == 0:
        return True
    return False

#
# Deploy the new agent to the target
#
def deploy_new_agent():
    if os_type == "linux":
        cmd = ' n1sh load server ' + server_name + ' update sunmc-linux-agent-1-1.i386'
    elif os_type == "solx86":
        cmd = ' n1sh load server ' + server_name + ' update SUNWn1gcsolx86ag'
    elif os_type == "solsparc":
        cmd = ' n1sh load server ' + server_name + ' update SUNWn1gcsolsparcag'
    else:
        print "Wrong os type, os type should be one of: linux, solx86 or solsparc "
        sys.exit(1)

    print "Loading agent package:  " + cmd
    c_output = commands.getoutput(cmd)
    if wait_for_job_completion(c_output) != 0:
        print "Error: could not load update."
        sys.exit(1)

#
# Start the new agent
#
def start_new_agent():
    if os_type == "linux":
        cmd = 'n1sh start server ' + server_name + ' command \\"/etc/rc.d/rc3.d/S98SunMCLinuxAgentInstall.sh start\\" '
    elif os_type == "solx86":
        cmd = 'n1sh start server ' + server_name + ' command \\"/etc/rc3.d/S80SunMCInstall start\\" '
    elif os_type == "solsparc":
        cmd = 'n1sh start server ' + server_name + ' command \\"/etc/rc3.d/S80SunMCInstall start\\" '
    else:
        print "Wrong os type, os type should be one of: linux, solx86 or solsparc "
        sys.exit(1)

    print "Starting agent install..."
    c_output = commands.getoutput(cmd)
    if wait_for_job_completion(c_output) != 0:
        print "Error: could not install new agent."
        sys.exit(1)


#
# update os profiles and load new agent on the target
#
def update_os_profiles():
    commands.getoutput('cp ' +  agent_filename + ' /var/opt/sun/scs/data/swinstaller/pkgs/ ')
    commands.getoutput('cp ' +  agent_filename + ' /var/opt/SUNWscs/data/swinstaller/pkgs/ ')
    print "SCS updated with new Agent."

#
# Uninstall Agent
#
def uninstall_agent():
    cmd1 = 'n1sh start server  ' + server_name + ' command  \\"/opt/SUNWsymon/sbin/es-uninst -X\\" '
    cmd2 = 'n1sh start server  ' + server_name + ' command  \\" rpm -e sunmc-linux-agent \\" '
    cmd3 = 'n1sh start server  ' + server_name + ' command  \\"pkgrm -n SUNWn1gcsolx86ag \\" '
    cmd4 = 'n1sh start server  ' + server_name + ' command  \\"pkgrm -n SUNWn1gcsolsparcag \\" '
    print "Uninstall old agent: " + cmd1
    c_output = commands.getoutput(cmd1)
    print "Status: ", c_output
    wait_for_job_completion(c_output)

    c_output = commands.getoutput(cmd2)
    print "Status: ", c_output
    wait_for_job_completion(c_output)

    c_output = commands.getoutput(cmd3)
    print "Status: ", c_output
    wait_for_job_completion(c_output)

    c_output = commands.getoutput(cmd4)
    print "Status: ", c_output
    wait_for_job_completion(c_output)

    print "Agent uninstalled: "


#
# main() - Start Here
#
if __name__ == '__main__':
    print "N1SM Agent Updater 1.0"
    print "======================\n"
    if len(sys.argv) != 5:
        print_usage_exit()

    agent_filename = sys.argv[1]
    os_type = sys.argv[2]
    server_name = sys.argv[3]
    agent_ip = sys.argv[4]

    if check_os_type(os_type) != 0:
        sys.exit(1)

    if check_agent_name(os_type, agent_filename) !=0:
        sys.exit(1)

    print "New agent filename ==> " + agent_filename
    print "Server name ==> " + server_name
    print "Agent IPAddress ==> " + agent_ip

    if is_agent_reachable():   
	    print "Agent is reachable"
    else:
	    print "Agent is UNREACHABLE, exiting"
	    sys.exit(1)

    uninstall_agent()
    update_os_profiles()
    deploy_new_agent()
    start_new_agent()

    print "Agent updated successfully."
