/*
 * Copyright xxxx-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * uflash_if.h
 * User flash PROM user interface header file.
 */

#ifndef _SYS_UFLASH_IF_H
#define	_SYS_UFLASH_IF_H

#pragma ident	"@(#)uflash_if.h	1.4	02/11/24 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * IOCTL related stuff.
 */
/* TIOC ioctls for user flash PROM control and monitor */
#if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
	defined(__EXTENSIONS__)
#define	uflashIOC    ('u'<<8)
#endif /* (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))... */

#define	UIOCIBLK	(uflashIOC|0)	/* identify */
#define	UIOCQBLK	(uflashIOC|1)	/* query a block */
#define	UIOCLBLK	(uflashIOC|2)	/* lock a block */
#define	UIOCMLCK	(uflashIOC|3)	/* master lock */
#define	UIOCCLCK	(uflashIOC|4)	/* clear all locks */
#define	UIOCEBLK	(uflashIOC|5)	/* erase a block */
#define	UIOCEALL	(uflashIOC|6)	/* erase all unlocked blocks */
#define	UIOCEFUL	(uflashIOC|7)	/* erase full chip */

/*
 * PROM info structure.
 */
typedef struct {
	uint16_t	mfr_id;		 /* manufacturer id */
	uint16_t	dev_id;		 /* device id */
	/* allow future expansion */
	int8_t		blk_status[256]; /* blks status filled by driver */
	int32_t		blk_num;	 /* total # of blocks */
	int32_t		blk_size;	 /* # of bytes per block */
} uflash_info_t;


/*
 * uflash user interface structure.
 */
typedef struct {
	int		blk_num;
	int		num_of_blks;
	uflash_info_t	info;		/* to be filled by the driver */
} uflash_if_t;

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_UFLASH_IF_H */
