/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * uflash.h
 * User flash PROM header file.
 */

#ifndef _SYS_UFLASH_H
#define	_SYS_UFLASH_H

#pragma ident	"@(#)uflash.h	1.6	06/03/24 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * This header file is for flash memories:
 * Intel 28F016AS
 * Intel 28F320j5
 * Sharp LH16K55
 * and more...
 */

/* */

typedef	struct	{
	kmutex_t		mu;
	dev_info_t		*dip;
	ddi_acc_handle_t	handle;
	ddi_device_acc_attr_t	attr;
	int32_t			uflash_size;		/* size in bytes */
	int32_t		uflash_blk_size;	/* blk size in bytes */
	int8_t			uflash_num_blocks;	/* number of blks */
	int8_t			uflash_blks_per_bank;	/* blks per bank */
	int8_t			uflash_info_incr;	/* info increment */
	uint8_t			uflash_acc_jmpr;	/* access mode jumper */
	uint8_t			uflash_acc_mode;	/* access mode opened */
	uint8_t			uflash_buf_write;	/* buffered write : */
							/* 0 : unknown, */
							/* 1 : supported, */
							/* 2 : not supported. */
	uint8_t			uflash_suspend;
	caddr_t			uflash_cell;
} uflash_state_t;


/* uflash time out value for completing the commands */
#define	UFLASH_TIME_OUT		0xF00000
#define	UFLASH_MIN_TIME_OUT	0xF00
#define	UFLASH_SEC_WAIT		0x5			/* for erase cmd */


/*
 * Default # of blks, blk size & info incr,
 * the real sizes come from OBP.
 */
#define	UFLASH_NUM_BLK		0x40			/* 64 blks per PROM */
#define	UFLASH_BLK_SIZE		0x10000			/* blk is 64 k bytes */
#define	UFLASH_INFO_INCR	2			/* info increment */
#define	UFLASH_BLKS_PER_BANK	0x20			/* blks per bank */
#define	UFLASH_BLK_SHIFT	16			/* to get blk # */

#define	UFLASH_MIN_BLK		0			/* least blk # */
#define	UFLASH_BUF_SIZE		32			/* for buffered write */
#define	UFLASH_BLK_MASK		0xFF0000		/* blk # bits */

#define	UFLASH_SUSPEND		0xc			/* suspend flag */
#define	UFLASH_TEST_PAT		0xC5

/* bit defines for uflash_acc_jmpr */
#define	UFLASH_RDWR_JMPR	1			/* w/r jumper sel */
#define	UFLASH_RDONLY_JMPR	0			/* r only jumper sel */

/* bit defines for uflash_acc_mode (chosen by the user) */
#define	UFLASH_RDWR_MODE	1			/* w/r mode */
#define	UFLASH_RDONLY_MODE	0			/* r only mode */

/*
 * Command definitions.
 */
#define	UFLASH_READ		0xFF			/* read array */
#define	UFLASH_IDENTIFY		0x90			/* identifier */
#define	UFLASH_QUERY		0x98			/* get blk status */
#define	UFLASH_READ_CSR		0x70			/* read csr */
#define	UFLASH_CLEAR_CSR	0x50			/* clear status */
#define	UFLASH_FULL_ERASE	0x30			/* erase whole */
#define	UFLASH_WRITE		0x40			/* write array */
#define	UFLASH_BUF_WRITE	0xE8			/* write buffered */
#define	UFLASH_ALT_WRITE	0x10			/* alternate write */
#define	UFLASH_ERASE		0x20			/* erase block */
#define	UFLASH_ERASE_SUS	0xB0			/* erase suspend */
#define	UFLASH_LOCK_UNLOCK	0x60	/* lock/unlock/mater lock a blk */

#define	UFLASH_ERASE_SUS_DATA	0xD0			/* data to unlock */
#define	UFLASH_LOCK_DATA	0x1			/* data to lock */
#define	UFLASH_MSTR_LOCK_DATA	0xF1		/* data to master lock */
#define	UFLASH_UNLOCK_DATA	UFLASH_ERASE_SUS_DATA

/*
 * Bit defines for SR.
 */
#define	UFLASH_CSR_READY	(1 << 7)	/* write state ready */
#define	UFLASH_CSR_SUS		(1 << 6)	/* erase suspended */
#define	UFLASH_CSR_E_ERR	(1 << 5)	/* error in erase blk */
#define	UFLASH_CSR_E_DATA	(1 << 4)	/* error in data */
#define	UFLASH_CSR_ABORT	(1 << 3)	/* operation aborted */
#define	UFLASH_CSR_P_SUSPEND	(1 << 2)	/* program suspend */
#define	UFLASH_CSR_BLK_LOCKED	(1 << 1)	/* error: block locked */
#define	UFLASH_CSR_BIT45	0x30		/* Command Seq Err */

/*
 * Bit defines fro XSR.
 */
#define	UFLASH_XR_READY		(1 << 7)	/* multi write is available */

/*
 * Bit defines for block status reg.
 */
#define	BLOCK_IS_LOCKED		1			/* block is locked */
#define	BLOCK_ERZ_NOT_OK	1			/* last erase failed */

/*
 * Defines for info indexes.
 */
#define	MFR_ID			0		/* manufacturer id index */
#define	DEV_ID			1			/* device id index */
#define	BLK_STAT		2		/* block status index */

/*
 * Defines for buffered writes.
 */
#define	UFLASH_BUFWR_UNKNOWN	0			/* buf wr not known */
#define	UFLASH_BUFWR_SUPPORT	1		/* buffered wr support */
#define	UFLASH_NO_BUFWR_SUPPORT	2		/* no buf wr support */

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_UFLASH_H */
