/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *      Copyright (c) 2005 Sun Microsystems, Inc.
 *      All Rights Reserved.
 *
 *      Government Rights Notice
 *      Use, duplication, or disclosure by the U.S. Government is
 *      subject to restrictions set forth in the Sun Microsystems,
 *      Inc. license agreements and as provided in DFARS 227.7202-1(a)
 *      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
 *      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
 *      as applicable.  Sun Microsystems, Inc.
 *
 *    SAM-QFS_notice_end
 */

// ident	$Id: stage.js,v 1.2.2.1 2006/03/22 20:24:15 kilemba Exp $
var tablePrefix = "Stage.FilesTableView.StageFilesTable.";
var stageButton = "Stage.FilesTableView.stage";
var deselectHref = tablePrefix + "DeselectAllHref";
var theFormName = "StageForm";

var selectedIndex = null;

function handleStageFileSelection(field) {
  if (field.name != deselectHref) {
    ccSetButtonDisabled(stageButton, theFormName, 0);
    selectedIndex = field.value;
  } else {
    ccSetButtonDisabled(stageButton, theFormName, 1);
    selectedIndex = null;
  }
}

function launchStagePopup(field) {
  var fileNames = field.form.elements["Stage.fileNames"].value.split(";");
  var fileToStage = fileNames[selectedIndex];

  var params = "&file_to_stage=" + fileToStage;

  var name = "stage_file_popup";

  var uri = "/fs/StagePopup";
  
  // need to collect parameters : fs name, file name at the very least
  var win = launchPopup(uri, name, null, null, params);

  win.focus();

  return false;
}

function launchGoToDirectoryPopup(field) {
  var name = "stage_goto_popup";
  var uri = "/fs/StageGotoDirectory";
  var params = null;

  // launch the popup
  var win = launchPopup(uri, name, null, null, params);

  win.focus();
  return false;
}

function handleGoToDirectorySubmit() {
  // get the parent form
  var parentForm = window.opener.document.forms["StageForm"];
  var theForm = window.document.forms["StageGotoDirectoryPopupForm"];
  var directory = theForm.elements["StageGotoDirectory.directory"].value;

  // make sure that a directory value has been entered before proceeding
  if (directory == null || directory == "") {
    alert(theForm.elements["StageGotoDirectory.nodirmsg"].value);
    return false;
  }

  // set the value and handler
  parentForm.action = parentForm.action + "?Stage.GotoDirectoryHref=";
  parentForm.elements["Stage.GotoDirectory"].value = directory;

  // submit parent and close popup
  parentForm.submit();
  close();
}

function launchFilterPopup(field) {
  var formName = field.form.name;
  var returnValue = "Stage.filterReturnValue";
  var commandChild = "Stage.filterHandler=";
  var pageTitleText = field.form.elements["Stage.filterPageTitle"].value;
  var promptText = field.form.elements["Stage.filterPrompt"].value;
  var loadValue = field.form.elements["Stage.filterValue"].value;

  return showFilterSettingsPopup(formName,
                                 returnValue,
                                 commandChild,
                                 pageTitleText,
                                 promptText,
                                 loadValue);
}
