#!/bin/sh

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#      Copyright (c) 2006 Sun Microsystems, Inc.
#      All Rights Reserved.
#
#      Government Rights Notice
#      Use, duplication, or disclosure by the U.S. Government is
#      subject to restrictions set forth in the Sun Microsystems,
#      Inc. license agreements and as provided in DFARS 227.7202-1(a)
#      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
#      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
#      as applicable.  Sun Microsystems, Inc.
#
#    SAM-QFS_notice_end

# archiver.sh - template shell for processing archiver exceptional events.
# $Id: archiver.sh,v 1.4.16.1 2006/02/08 20:02:18 jdunn Exp $
#
# args:
#	1) calling program name
#	2) calling program pid
#	3) keyword identifying the 'syslog' level of the event.
# 		The keywords are:
# 		emerg, alert, crit, err, warning, notice, info, debug
#	4) message number from the message catalog.
#	5) the actual message.
#
#

case $3 in
	alert|crit|emerg|err)
		# These lines inform "root" that a serious error occured.
		mail root <<EOF
The SAM-FS $1 detected a level "${3}" exception condition.
Message number ${4}:
${5}
EOF
		;;

    warning)
		# Do not send default message for these, archiver already sent it.
		if [ $4 = 4020 ]; then
			#%s[%d] died - Not restarting
			exit
		fi

		if [ $4 = 4023 ]; then
			#Errors in archiver commands - no archiving will be done.
			exit
		fi
		;;

esac

#  The default action is to send the message to syslog

/usr/bin/logger -p local7.$3 -t "$1[$2]" $3\($4\) "$5"
