#
# ident "@(#)scmonitor-d.x 1.8     06/02/07 SMI"
#
# Copyright (c) 2006 by Sun Microsystems, Inc
# All rights reserved.
#
# File         : scmonitor-d.x
# Version      : 1.4
# Last Checkin : 03/01/99
#

[ requires package scmonitor ]
[ requires class scmonitor ]

[ use MANAGED-MODULE ]
[ load scmonitor-v2-m.x ]
[ requires template scmonitor-models-d ]

# Used for failover to move the module to a(n) down/ok state
# while the SC transitions to a(n) standby/active state.
availability = { [ use .classes.scmonitor ]
   type            = active
   refreshMode     = sync
   timeoutInterval = 120
   initInterval    = 0
   initHoldoff     = 2
   refreshInterval = 60
   refreshService  = _internal
   refreshCommand  = moduleAvailability

   alarmChecks             = "disabled-eq error-ne";
   alarmlimit:disabled-eq  = "UNAVAILABLE";
   alarmlimit:error-ne     = "AVAILABLE";

   disabledMessage = "- Module is on the Spare SC or required SMS daemon(s) is stopped"
   errorMessage    = "Fatal Error"

   statusActions(ok)               = forceok
   statusActions(error-ne)         = forcedown
   statusActions(disabled-eq)      = forcedown

   statusService(forcedown)        = _superior
   statusCommand(forcedown)        = forceModuleState down %[ toe_self ]

   statusService(forceok)          = _superior
   statusCommand(forceok)          = forceModuleState ok %[ toe_self ]
}

daq = { [ use .classes.scmonitor ]
}

processTable = {[ use templates.scmonitor-models-d.processTable .classes.scmonitor ]

	initInterval	= 50
	initHoldoff	= 50
	type = active
	activateActions(post) = register
	activateService(register) = _internal
	activateCommand(register) = SetPIDs
	refreshMode     = sync
	refreshService  = _internal
	refreshInterval = 60
	refreshCommand  = DoRefresh

}


[ load scmonitor-d.def ]
