Summary: The Sun Gigaswift product.
Name: sun-gigaswift-kernel
Version: 1.8.1
Release: 1
License: Copyright 2004 Sun Microsystems, Inc.  Released under the GPL.  Use is subject to license terms.	
Vendor: Sun Microsystems, Inc.
Group: Networking/Admin
URL: http://www.sun.com/software/download/network.html
Source0: sun-gigaswift-kernel-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot

%description 
The sun-gigaswift-kernel package provides the kernel module for the 
Sun Gigaswift product (Gigabit Ethernet NIC.)

%prep
%setup -q

%build

%ifos linux
make ROOT="$RPM_BUILD_ROOT" MVERSION=%(uname -r) buildOne
%endif

%install

%ifos linux
make ROOT="$RPM_BUILD_ROOT" MVERSION=%(uname -r) installOne
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)

%ifos linux
%attr(644, root, root) /lib/modules/%(uname -r)/kernel/drivers/net/cassini.o
%endif

%changelog

* Fri Jan 20 2006 Santwona Behera <santwona.behera@sun.com> 1.8.1-1
- Fixed rx descriptor alignment issue in pci_alloc_consistent.

* Fri Jul 22 2005 Bill Zaumen <william.zaumen@sun.com> 1.6-1
- MODULE_PARM to module_param change for new kernel API

* Wed Jul 20 2005 Bill Zaumen <william.zaumen@sun.com> 1.5-1
- conditional compilation for 2.6.9 & later due to function-signature change; separate 2.4 & 2.6 RPMs

* Fri Aug 20 2004 Bill Zaumen <william.zaumen@sun.com> 1.4-3
- fixed Makefile problem for 2.6.x for file suffix.

* Fri Aug 20 2004 Bill Zaumen <william.zaumen@sun.com> 1.4-1
- fixed Makefile problem for 2.6.x for cleanup

* Tue Aug 17 2004 Bill Zaumen <william.zaumen@sun.com> 1.4-1
- fixed ethtool GSTAT ioctl. Bumped minor version number for a new release.

* Mon Aug 16 2004 Bill Zaumen <william.zaumen@sun.com> 1.3.3-1
- fixed a counter problem

* Mon Aug 16 2004 Bill Zaumen <william.zaumen@sun.com> 1.3.2-1
- replaced cas_lock_all with cas_lock_all_save (irqsave flavor of spin lock)

* Mon Aug 16 2004 Bill Zaumen <william.zaumen@sun.com> 1.3.1-1
- Added ethtool ioctls for better diagnostics.

* Thu Aug 12 2004 Bill Zaumen <william.zaumen@sun.com> 1.3-1
- Fixed security hole in ioctl; debugging off for QA

* Wed Aug 11 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.9-1
- Possible LED fix for Saturn (register location was wrong)

* Wed Aug 11 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.8-1
- printk added to show when LEDs turned on.

* Wed Aug 11 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.7-1
- more printk calls in phy_init, where we set pin_cfg register

* Tue Aug 10 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.6-1
- Programmed PCI cache line to 0x20, printk calls in cas_check_pci_invariants

* Tue Aug 10 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.5-1
- Added printk for PCI cache line size, pin info, transceiver info in ioctl.

* Fri Aug 06 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.4-1
- Fixed CONFIG_CASSINI_QGE_DEBUG; more link-down code in cas_begin_auto_negotiation

* Fri Aug 06 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.3-1
- Added debugging CONFIG_CASSINI_QGE_DEBUG to see if interrupts getting through

* Fri Aug 06 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.2-1
- Added extra debugging for CONFIG_CASSINI_LDEBUG to trace resets.

* Wed Aug 04 2004 Bill Zaumen <william.zaumen@sun.com> 1.2.1-1
- Updated Saturn patch.

* Tue Aug 03 2004 Bill Zaumen <william.zaumen@sun.com> 1.2-1
- QA release; removed CONFIG_CASSINI_SPARE_CHECK test code (it was off anyway)

* Mon Aug 02 2004 Bill Zaumen <william.zaumen@sun.com> 1.1-1
- Going to new version after previous fixes were verified.

* Mon Aug 02 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.2-5
- fixed race condition & made locking more conservative for cas_spare_recover

* Fri Jul 30 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.2-4
- __list_for_each is redhat-only, so replaced it with list_for_each in tstcode

* Fri Jul 30 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.2-3
- Added some more CONFIG_CASSINI_SPARE_CHECK tests to diagnose crash

* Fri Jul 30 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.2-2
- Added some more CONFIG_CASSINI_SPARE_CHECK tests; fixed locking problem.

* Thu Jul 29 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.2-1
- LDEBUG off; optional null-pointer checks (see CONFIG_CASSINI_SPARE_CHECK.)

* Tue Jul 27 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.1-5
- atomic counter to ensure all tasks complete before a shutdown.

* Tue Jul 27 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.1-4
- Fixed bug in IOCTL for link speed and half/full duplex when a link is down

* Mon Jul 26 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.1-3
- Hopefully fixed a race cond. in use of cas_reset_task & reset_task_pending

* Mon Jul 26 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.1-2
- Added print statement to see how workaround is being triggered

* Fri Jul 23 2004 Bill Zaumen <william.zaumen@sun.com> 1.0.1-1
- Linkdown problem workaround added.

* Thu Jul 22 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-12
- Link down problem still present: more instrumentation added (..._LDEBUG)

* Wed Jul 21 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-11
- Possible Fix for PCS half-duplex problem with fiber cards (to be verified.)

* Tue Jul 20 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-10
- print when cas_pcs_link_check Returns nonzero in cas_link_timer (only when CONFIG_CASSINI_LDEBUG is turned on)

* Mon Jul 19 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-9
- added tracing of cas_begin_autonegotiation calls (only when CONFIG_CASSINI_LDEBUG is turned on)

* Thu Jul 15 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-8
- added 'locator' parameter to cas_init_hw to tag where called (only when CONFIG_CASSINI_LDEBUG is on); added delay on cas_init_hw.

* Thu Jul 15 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-7
- added more instrumentation in 1.0-5 &1.0-6, and then commented some out to avoid excessive printing

* Mon Jul 12 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-4
- fixed a makefile problem ; added instrumentation for debugging.

* Thu Jul 01 2004 Bill Zaumen <william.zaumen@sun.com> 1.0-1
- fixed PCS #define; spin_lock_irq -> spin_lock_irqsave; state maching dumping; debug error msg before certain resets

* Mon Jun 28 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.4-1
- 1000Mbit off, more fiber-link detection, inf. burst mode off for older chips, use of tiny bufs workaround for tx abort, set rx frame size to max, misc minor changes.

* Mon Jun 21 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.4-1
- Makefile turns on NAPI, ioctl fix, RX buf SMP safe, TX tiny bufs, netpoller interupt handling, 2.4 versus 2.6 issue.

* Fri Jun 18 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.3-2
- Makefile change to turn off NAPI for this build only.

* Mon Jun 14 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.3-1
- Adrian renamed some constants to make them cassini-specific; added assymetric pause support.

* Tue Jun 8 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.2-1
- Adrian: rx reset on overflow; page use for rx cleanup on reset; page-size/mtu stride now per instance.

* Mon Jun 7 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.1-1
- Adrian: init of BIM (global RST), high-load fix, and hard RST (drv resume.)

* Tue Jun 1 2004 Bill Zaumen <william.zaumen@sun.com> 0.9.0-1
- Driver fix from Adrian for initialization issues (tx_reset problem).

* Tue May 18 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.9-1
- Driver fix for ethtool stats.

* Mon May 17 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.8-1
- New driver from adrian (fixes for qge, a reset issue, chip/phi detection.)

* Tue May 06 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-7
- fixed Makefile due to bug in finding gcc-lib on 64-bit systems

* Tue May 06 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-6
- fixed Makefile so we get SuSE directories correctly.

* Tue May 04 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-5
- fixed Makefile syntax error

* Tue May 04 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-4
- changed gcc options for x86_64

* Tue May 04 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-3
- value of stdargs include dir for 64-bit system fixed in Makefile

* Tue May 04 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-2
- stdargs in different location for 64-bit systems, so Makefile changed.

* Tue May 04 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.5-1
- 9K Jumbo Frame support (module from Adrian).

* Fri Apr 22 2004 Bill Zaumen <william.zaumen@sun.com> 0.8.4-1
- Initial version for QA testing.
