/*
 * Copyright 05/14/03 Sun Microsystems, Inc. All Rights Reserved
 */


#ifndef _COLLECTORAPI_H
#define	_COLLECTORAPI_H

#if defined(__SUNPRO_C) || defined(__SUNPRO_CC)
#pragma ident "@(#)collectorAPI.h 1.1 03/05/14 SMI"
#endif

/*
 * This file contains function prototypes for the user-callable API
 * routines in libcollector.
 */

#ifdef	__cplusplus
extern "C" {
#endif

/* routine to record a sample in the experiment */
extern void	collector_sample(const char *name);

/* routine to suspend data collection during an experiment */
extern void	collector_pause(void);

/* routine to resume data collection during an experiment */
extern void	collector_resume(void);

/* routine to suspend per-thread data collection during an experiment */
extern void	collector_thread_pause(unsigned int tid);

/* routine to resume per-thread data collection during an experiment */
extern void	collector_thread_resume(unsigned int tid);

/* routine to close the experiment, and stop all data collection */
extern void	collector_terminate_expt(void);

typedef struct {
	unsigned int	offset;
	unsigned int	lineno;
} Lineno;

/* routines to let libcollector know about dynamically loaded functions */
extern void	collector_func_load(const char *name, const char *alias,
                                    const char *sourcename, void *vaddr,
		                    int size, int lntsize, Lineno *lntable);

extern void	collector_func_unload(void *vaddr);

#ifdef NEED_COLLECTOR_MODULE
extern void	collector_module_load(const char *modulename, void *vaddr);

extern void	collector_module_unload(void *vaddr);
#endif

#ifdef	__cplusplus
}
#endif

#endif	/* _COLLECTORAPI_H */
