############################################################################
#set -x
#
# patch the configuration files
# takes one argument - the PATCHDIR, typically underinstall/patch/<patchnum>
############################################################################

use Switch;
use File::Compare;
use File::Basename;

############################################################################
# utility routines
#. ${basedir}/lib/util.sh
############################################################################

########################################
# Return the timestamp
########################################

sub timestamp
{
$t = time;
$now = localtime($t);
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($t);
$year += 1900;
$mon = $mon + 1;
$_DATE = sprintf ("%d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);
}

########################################
# Initialize the LogFile
########################################

sub log_init
{
$CUR_DATE = sprintf ("%d-%02d-%02d::%02d %02d %02d", $mday, $mon, $year, $hour, $min, $sec);
open (LOG_OUT, ">>$LOGFILE");
print LOG_OUT "============ LOGFILE started $CUR_DATE ==========\n";
}

########################################
# Log a message to the LOGFILE
########################################

sub log_only
{
my($message) = @_;
print LOG_OUT "$message\n";
}

########################################
# Log a message to the screen and to the LOGFILE
########################################

sub log_msg
{
my($message) = @_;
print "$message\n";
print LOG_OUT "$message\n";
}


############################################################################
# usage
############################################################################
sub usage
{
print <<USAGE;

Usage:
   perl uninstall-newconfig.pl <option> <Server-Root Path> <base patch number>
   <option> : -f : For a forced replacing of files
   Server-Root Path : Path where MS is being installed
   patch number : the base patch number (<patchid>-<patchrev>),
   e.g. 116568-05
   
USAGE
}

############################################################################
# check to make sure config is accessible
#
#check_configaccess() {
#  if [ ! -w $basedir/config/imta_tailor ]; then
#    log_msg "-- Could not access the config area $basedir/config"
#    log_msg "-- This utility requires access to the config area"
#    exit 2
#  fi
#}
############################################################################

sub check_configaccess 
{
  if ( ! -w "$basedir/config/imta_tailor" ) { 
    &log_msg ("-- Could not access the config area $basedir\config");
    &log_msg ("-- This utility requires access to the config area");
    exit (2);
  }
}

############################################################################
# check to make sure servers are stopped
#
#check_servers() {
#  log_only "-- check_servers"
#  if [ -x $basedir/lib/msstart ]; then
#    $basedir/lib/msstart -l >> $LOGFILE 2>&1
#    stat=$?
#    log_only "-- msstart -l returned $stat"
#    case $stat in
#      0) log_only "-- No servers running";;
#      *)  log_msg "--"
#	   log_msg "-- Please stop the services before applying the patch"
#          log_msg "--"
#          exit 1;;
#    esac
#  fi
#}
############################################################################

sub check_servers
{
&log_only ("-- check_servers");
if ( -x "$ARGV[0]/sbin/stop-msg.bat" && -x "$ARGV[0]/lib/configutil.exe" ) {
    log_msg ("-- Stopping Messaging Server...");
    system("$ARGV[0]\\sbin\\stop-msg.bat");
    $stat=$?;
    &log_only ("-- stop-msg returned $stat");
}
}


############################################################################
# determine if configured for HA
# - set the variable isHAconfigured to 0 (false) or 1 (true)
#
#isHAconfigured() {
#  VCSCMD=/opt/VRTSvcs/bin/hares 
#  SC3CMD=/usr/cluster/lib/rgm/rtreg/SUNW.ims
#  IP_INTERFACE=`$basedir/lib/configutil -o service.listenaddr 2> $LOGFILE`
#  if [ $# -eq 0 -a \
#       ! \( -z "$IP_INTERFACE" -o "$IP_INTERFACE" = "INADDR_ANY" \) -a \
#       \( -f "$VCSCMD" -o -f "$SC2CMD" -o -f "$SC3CMD" \) ]; then
#    isHAconfigured=1
#  else
#    isHAconfigured=0
#  fi
#  log_only "-- isHAconfigured = $isHAconfigured"
#}
############################################################################

sub isHAconfigured
{
  $VCSCMD="/opt/VRTSvcs/bin/hares"; 
  $SC3CMD="/usr/cluster/lib/rgm/rtreg/SUNW.ims";
  $IP_INTERFACE = "$basedir\\lib\\tmpfile.txt";
  open(IP_OUT,"$IP_INTERFACE");
  system ("$basedir\\lib\\configutil -o service.listenaddr>$IP_INTERFACE");
  close(IP_OUT);
  open(IP_IN,"$IP_INTERFACE");
  $line = <IP_IN>;
  if ( @ARGV == 0 && ( ! -z "$IP_INTERFACE" || $line eq "INADDR_ANY" ) && ( -f "$VCSCMD" || -f "$SC2CMD" || -f "$SC3CMD" ) ) {
    	$isHAconfigured=1;
  } else {
    	$isHAconfigured=0;
  }
  close (IP_IN);
  &log_only ("-- isHAconfigured = $isHAconfigured");
}

############################################################################
# uninstall newconfig files
# - Restore files that were saved off the patch-config
#   i.e. files listed in newconfig.list
#   Note that although patch-config may have saved them off, it does not
#   necessarily mean that new versions were ever installed. It also does
#   not mean that all the config files at patch-config time are restored,
#   only those that patch-config generated new versions for.
#uninstall_newconfig() 
#{
#  # uninstall the file
#  NUMCOPIES=0
#  set `/bin/cat $PATCHDIR/newconfig.list`
#  while [ $# -ne 0 ]
#  do
#    cfile=$1
#    shift
#    file=$SAVEDIR/$cfile
#    if [ ! -f $file ]; then
#      log_msg "-- $file does not exist, skipping it"
#      continue
#    fi
#    # check if it is identical first
#    /usr/bin/cmp -s $SAVEDIR/$cfile $basedir/$cfile
#    stat=$?
#    if [ $stat -ne 0 ]; then
#      # save existing config file
#      if [ -f $basedir/$cfile ]; then
#        dir=`dirname $CONFIGBACKOUTDIR/$cfile`
#	if [ ! -d $dir ]; then
#	  /bin/mkdir -p $dir
#        fi
#	/bin/cp -p $basedir/$cfile $CONFIGBACKOUTDIR/$cfile
#      fi
#      # restore the old config file
#      #   no permissions being enforced by mkdir. Nuts.
#      dir=`dirname $basedir/$cfile`
#      if [ ! -d $dir ]; then
#	log_msg "-- /bin/mkdir -p $dir"
#        /bin/mkdir -p $dir
#      fi
#      if [ $fflag -ne 1 ]; then
#        log_msg "/bin/cp -pi $SAVEDIR/$cfile $basedir/$cfile"
#        /bin/cp -pi $SAVEDIR/$cfile $basedir/$cfile
#      else
#        log_msg "/bin/cp -pf $SAVEDIR/$cfile $basedir/$cfile"
#        /bin/cp -pf $SAVEDIR/$cfile $basedir/$cfile
#      fi
#      NUMCOPIES=`expr $NUMCOPIES + 1`
#    else
#      log_msg "-- $file is identical, skipping it"
#    fi
#  done
#  log_msg "-- Number of different files: $NUMCOPIES"
#  log_msg "-- Original files are backed up under $CONFIGBACKOUTDIR"
#}
############################################################################


sub uninstall_newconfig
{
$newfile_error=0;
$NewConfList = "$PATCHDIR\\newconfig.list";
open(NEWCONF,"$NewConfList");
$line = <NEWCONF>;
# uninstall the file
$NUMCOPIES=0;
seek(NEWCONF,0,0);
$line = <NEWCONF>;
while ( $line ne "" ) {
    chomp($line);	
    $cfile = $line;
    # check if it is identical first
    $stat=compare("$SAVEDIR\\$cfile","$basedir\\$cfile");
    if ( $stat != 0 ) {
   	   # save existing config file
   	   if ( -f "$basedir/$cfile" ) {
   		     $dir=dirname("$CONFIGBACKOUTDIR\\$cfile");
	       	     if ( ! -d "$dir" ) {
	  		use File::Path qw(mkpath);
    			mkpath $dir;
        	     }
	 	     system("copy $basedir\\$cfile $CONFIGBACKOUTDIR\\$cfile");
      	   }
      	   # install new config file
           #   no permissions being enforced by mkdir. Nuts.
           $dir=dirname("$basedir\\$cfile");
           if ( ! -d "$dir" ) {
	 	&log_msg ("-- mkdir $dir");
      		use File::Path qw(mkpath);
    		mkpath $dir;
           }
      	   if ( $fflag != 1 ) {
        	     &log_msg ("copy /-Y $SAVEDIR\\$cfile $basedir\\$cfile");
        	     system("copy /-Y $SAVEDIR\\$cfile $basedir\\$cfile");
      	   } else {
        	     &log_msg ("copy /Y $SAVEDIR\\$cfile $basedir\\$cfile");
        	     system("copy /Y $SAVEDIR\\$cfile $basedir\\$cfile");
      	   }
      	   $NUMCOPIES++;
    }
    $line = <NEWCONF>;
}  
&log_msg ("-- Number of different files: $NUMCOPIES");
&log_msg ("-- Original files are backed up under $CONFIGBACKOUTDIR");
}

############################################################################
# perform_checks
#
#perform_checks() {
#  log_only "-- perform_custom being run"
#
#  log_msg "-- Running clbuild, chbuild, cnbuild, test rewrite..."
#
#  log_only "--   $basedir/sbin/imsimta clbuild -image_file=IMTA_COMMAND_DATA IMTA_BIN:pmdf.cld"
#  $basedir/sbin/imsimta clbuild -image_file=IMTA_COMMAND_DATA IMTA_BIN:pmdf.cld >> $LOGFILE 2>&1
#  log_only "--   return status $?" >> $LOGFILE 2>&1
#
#  log_only "--   $basedir/sbin/imsimta chbuild"
#  $basedir/sbin/imsimta chbuild >> $LOGFILE 2>&1
#  log_only "--   return status $?" >> $LOGFILE 2>&1
#
#  log_only "--   $basedir/sbin/imsimta cnbuild"
#  $basedir/sbin/imsimta cnbuild >> $LOGFILE 2>&1
#  log_only "--   return status $?" >> $LOGFILE 2>&1
#
#  log_only "--   $basedir/sbin/imsimta version"
#  $basedir/sbin/imsimta version >> $LOGFILE 2>&1
#  log_only "     return status $?" >> $LOGFILE 2>&1
#
#  log_only "--   $basedir/sbin/imsimta test -rewrite -debug postmaster"
#  $basedir/sbin/imsimta test -rewrite -debug postmaster >> $LOGFILE 2>&1
#  log_only "--   return status $?" >> $LOGFILE 2>&1
#}
############################################################################

sub perform_checks
{
  &log_only ("-- perform_custom being run");

  &log_msg ("-- Running clbuild, chbuild, cnbuild, test rewrite...");
  
  $tmp_copyfile = "C:\\tmplogfile.txt";
  open(TEMP,"$tmp_copyfile");

  &log_only ("--   $basedir\\sbin\\imsimta.bat clbuild -image_file=IMTA_COMMAND_DATA IMTA_BIN:pmdf.cld");
  system("$basedir\\sbin\\imsimta.bat clbuild -image_file=IMTA_COMMAND_DATA IMTA_BIN:pmdf.cld 2>> $tmp_copyfile");
  &log_only ("--   return status $?");

  &log_only ("--   $basedir\\sbin\\imsimta.bat chbuild");
  system("$basedir\\sbin\\imsimta.bat chbuild >> $tmp_copyfile");
  &log_only ("--   return status $?");

  &log_only ("--   $basedir\\sbin\\imsimta.bat cnbuild");
  system("$basedir\\sbin\\imsimta.bat cnbuild >> $tmp_copyfile");
  &log_only ("--   return status $?");

  &log_only ("--   $basedir\\sbin\\imsimta.bat version");
  system("$basedir\\sbin\\imsimta.bat version >> $tmp_copyfile");
  &log_only ("     return status $?");

  &log_only ("--   $basedir\\sbin\\imsimta.bat test -rewrite -debug postmaster");
  system("$basedir\\sbin\\imsimta.bat test -rewrite -debug postmaster >> $tmp_copyfile");
  &log_only ("--   return status $?");
  
  close(TEMP);
}


############################################################################
# main program
#
#
# utility routines
#. ${basedir}/lib/util.sh
#
# get args
#fflag=0;
#while getopts hf c
#do
#    case $c in
#    f)
#	fflag=1;;
#    h)
#        usage;;
#    \?)
#        usage;;
#    esac
#done
#shift `expr $OPTIND - 1 `
#
#if [ $# -ne 1 ]; then
#  usage
#fi
#PATCHDIR=$*
#
# must be root
#
#set `/usr/bin/id`
#if [ $1 != "uid=0(root)" ]; then
#  echo
#  echo "Utility to uninstall the new config files at patch-config time\n"
#  echo "I.e. restores the new config files that patch-config generated\n"
#  echo "     but not necessarily installed\n"
#  echo "To use this utility you need to be the system's root user. \n"
#  echo 
#  exit 1
#fi
# initialize logging
#LOGFILE=$PATCHDIR/uninstall-newconfig_`date +%Y%m%d%H%M%S`.log
#log_init
#
# save directory created by patchadd and patch-config
#if [ ! -d $PATCHDIR/save ]; then
#  echo "Invalid PATCHDIR, $PATCHDIR/save is not a directory"
#  usage
#fi
#SAVEDIR=$PATCHDIR/save
# backout directory created by patchadd
#if [ ! -d $PATCHDIR/backout ]; then
#  echo "Invalid PATCHDIR, $PATCHDIR/backout is not a directory"
#  usage
#fi
#BACKOUTDIR=$PATCHDIR/backout
# file containing list of new config files
#if [ ! -f $PATCHDIR/newconfig.list ]; then
#  echo "$PATCHDIR/newconfig.list not found, Please run patch-config first"
#  usage
#fi
# where original config files will be backed up
#CONFIGBACKOUTDIR=$PATCHDIR/config_`date +%Y%m%d%H%M%S`
#/bin/mkdir -p $CONFIGBACKOUTDIR
#
# check to make sure config is accessible
#check_configaccess
#isHAconfigured
#if [ $isHAconfigured -eq 1 ]; then
#  log_msg "Warning an HA configuration is detected on your systems,"
#  ans=`ckyorn -Q -d n -p "Continue (default: n)"` || exit $?
#  log_only "Continue (default: n) [y,n,?] $ans"
#  if [ "$ans" = n -o "$ans" = no ]
#  then
#    log_msg "-- Okay, terminating. Rerun at your convenience"
#    exit 3
#  fi
#fi
#check_servers
#uninstall_newconfig
#perform_checks
#log_msg "-- Note that ldif files"
#log_msg "--   $basedir/lib/patch/cfgdir_diff.ldif and"
#log_msg "--   $basedir/lib/patch/ugdir_diff.ldif"
#log_msg "-- that you may have applied to the config and user/group"
#log_msg "-- Directory respectively may also have to be undone."
#log_msg "-- There is no tool to do this currently."
#log_msg "-- Nor are there any backups of the previous ldap entries".
############################################################################


$basedir=$ARGV[0];

if (@ARGV < 1) {
	print "Incorrect no: of arguments\n";
	&Usage;
	exit(1);
}

$fflag = 0;
if($ARGV[0] eq "-f") {
	$fflag = 1;
	$ARGV[0] = $ARGV[1];
}

$PATCHDIR = "$ARGV[0]\\install\\patch\\$ARGV[1]";
$tstamp = &timestamp;
$LOGFILE = "$PATCHDIR\\uninstall-newconfig_$tstamp.log";
&log_init;

# save directory created by patchadd and patch-config
if ( ! -d "$PATCHDIR/save" ) {
  print "Invalid PATCHDIR, $PATCHDIR\save is not a directory";
  &Usage;
}
$SAVEDIR="$PATCHDIR\\save";
# backout directory created by patchadd
if ( ! -d "$PATCHDIR/backout" ) {
  print "Invalid PATCHDIR, $PATCHDIR\backout is not a directory";
  &Usage;
}
$BACKOUTDIR="$PATCHDIR\\backout";
# file containing list of new config files
if ( ! -f "$PATCHDIR/newconfig.list" ) {
  print "$PATCHDIR\newconfig.list not found, Please run patch-config first";
  &Usage;
}
# where original config files will be backed up
$CONFIGBACKOUTDIR="$PATCHDIR\\config_$tstamp.log";
use File::Path qw(mkpath);
mkpath $CONFIGBACKOUTDIR;

# check to make sure config is accessible
&check_configaccess;
&isHAconfigured;
if ( $isHAconfigured == 1 ) {
  	&log_msg ("Warning an HA configuration is detected on your systems,");
        &log_msg ("Continue [y,n] :");
  	$ans = <STDIN>;
  	if ( $ans eq "n" || $ans eq "N" || $ans eq "no" || $ans eq "No" || $ans eq "NO" ) {
  		  &log_msg ("-- Okay, terminating. Rerun at your convenience");  
  	  	  exit (3);
  	}
}
&check_servers;
&uninstall_newconfig;
&perform_checks;
&log_msg ("-- The final step is to apply the ldif files");
&log_msg ("-- $basedir/lib/patch/cfgdir_diff.ldif and");
&log_msg ("-- $basedir/lib/patch/ugdir_diff.ldif");
&log_msg ("-- to the config Directory and the user/group Directory respectively");
&log_msg ("-- This is not performed automatically, you must do this manually");

