#
# Pre Backout Script
#
#############################################
#
# main program starts here
#
# Do I need to do stop-msg?
# determine server-root
# do_backout
#
#############################################
use File::Basename;

if (@ARGV != 2) {
	print "Incorrect no: of arguments\n";
	&Usage;
	exit(1);
}

$PATCHDIR = "$ARGV[0]\\install\\patch\\$ARGV[1]";
$BACKOUTDIR = "$PATCHDIR\\backout";
use File::Path qw(mkpath);
mkpath $PATCHDIR;
$tstamp = &timestamp;
$LOGFILE = "$PATCHDIR\\prebackout_$tstamp.log";
&log_init;
&do_backout;



#######################################
#
# Usage
#
########################################
sub Usage
{
print <<USAGE;

Usage:
	prepatch.pl <Server-Root Path> <base patch number>
	
	Server-Root Path : Path where MS is being installed
	patch number : the base patch number (<patchid>-<patchrev>),
        e.g. 116568-05
	
USAGE
}

########################################
#
# Return the timestamp
#
########################################
sub timestamp
{
$t = time;
$now = localtime($t);
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($t);
$year += 1900;
$mon = $mon + 1;
$_DATE = sprintf ("%d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);
}

########################################
#
# Initialize the LogFile
#
########################################
sub log_init
{
$CUR_DATE = sprintf ("%d-%02d-%02d::%02d %02d %02d", $mday, $mon, $year, $hour, $min, $sec);
open (LOG_OUT, ">>$LOGFILE");
print LOG_OUT "============ LOGFILE started $CUR_DATE ==========\n";
}

########################################
#
# Log a message to the LOGFILE
#
########################################
sub log_only
{
my($message) = @_;
print LOG_OUT "$message\n";
}

########################################
#
# Log a message to the screen and to the LOGFILE
#
########################################
sub log_msg
{
my($message) = @_;
print "$message\n";
print LOG_OUT "$message\n";
}

########################################
#
# do_backout
#
########################################
sub do_backout
{
&log_only ("-- do_backout being run");
if ( -f "$PATCHDIR/file.list" ) {
    open(IN,"$PATCHDIR\\file.list");
    $f = <IN>;
    while($f ne "") {
    	chomp($f);
    	$_ = $f;
	$f = ~s/\//\\/g;
    	$f = $_;
    	if ( -f "$BACKOUTDIR/$f" ) {
		&log_only ("move $BACKOUTDIR\\$f $ARGV[0]\\$f");
		system("move $BACKOUTDIR\\$f $ARGV[0]\\$f");
      	}
      	$f = <IN>;
    }
}  
close(IN);
}