#
# Post Patch Script
#
############################################
#
# main program starts here
#
############################################
#
# Do I need to do stop-msg?
# determine server-root
# create patch staging area (for backout and new files to apply)
# determine ifConfigured
# if configured
#   - read saveState
#     - get schema type, comp list, iMS.UserId, iMS.GroupId
#   - generate config.ins and devtypes.txt
#   - run devinstall
#   - install new files, backup old ones.
#   - do custom stuff
# endif
#
#############################################
use File::Basename;

if (@ARGV != 2) {
	print "Incorrect no: of arguments\n";
	&Usage;
	exit(1);
}

$PATCHDIR = "$ARGV[0]\\install\\patch\\$ARGV[1]";
use File::Path qw(mkpath);
mkpath $PATCHDIR;
$tstamp = &timestamp;
$LOGFILE = "$PATCHDIR\\postpatch_$tstamp.log";
&log_init;
&create_staging_area;
&filter_special_files;
&get_isConfigAccessible;
if ( $wasConfigured == 1 ) {
# &read_saveState;
  &getUserAndGroupID;	
  &create_configins;
  &run_devinstall;
}
if ( $isConfigAccessible == 1 ) {
  &perform_custom;
}
if ( $wasConfigured == 1 ) {
  &log_msg ("--");
  &log_msg ("-- To generate updated config files, run");
  &log_msg ("-- $ARGV[0]\\sbin\\patch-config.pl");
}



#######################################
#
# Usage
#
########################################
sub Usage
{
print <<USAGE;

Usage:
	prepatch.pl <Server-Root Path> <base patch number>
	
	Server-Root Path : Path where MS is being installed
	patch number : the base patch number (<patchid>-<patchrev>),
        e.g. 116568-05
	
USAGE
}

########################################
#
# Return the timestamp
#
########################################
sub timestamp
{
$t = time;
$now = localtime($t);
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($t);
$year += 1900;
$mon = $mon + 1;
$_DATE = sprintf ("%d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);
}

########################################
#
# Initialize the LogFile
#
########################################
sub log_init
{
$CUR_DATE = sprintf ("%d-%02d-%02d::%02d %02d %02d", $mday, $mon, $year, $hour, $min, $sec);
open (LOG_OUT, ">>$LOGFILE");
print LOG_OUT "============ LOGFILE started $CUR_DATE ==========\n";
}

########################################
#
# Log a message to the LOGFILE
#
########################################
sub log_only
{
my($message) = @_;
print LOG_OUT "$message\n";
}

########################################
#
# Log a message to the screen and to the LOGFILE
#
########################################
sub log_msg
{
my($message) = @_;
print "$message\n";
print LOG_OUT "$message\n";
}

########################################
#
# create the patch staging area
# - input: PATCHDIR
# - sets the variables: BACKOUTDIR SAVEDIR
#
########################################
sub create_staging_area
{
$BACKOUTDIR = "$PATCHDIR\\backout";
$SAVEDIR = "$PATCHDIR\\save";
use File::Path qw(mkpath);
mkpath $BACKOUTDIR;
mkpath $SAVEDIR;
}

#########################################
#
# these set of files are always filtered regardless of whether there is
# a configuration. This is from postinstall.install
#
#########################################
sub filter_special_files
{
$tmp_copyfile = "C:\\tmplogfile.txt";
open(TEMP,"$tmp_copyfile");
&log_only ("-- filter special files");
# @FILTERFILES = ("$ARGV[0]\\lib\\config-templates\\DevsetupDefaults.properties", "$ARGV[0]\\lib\\config-templates\\installer.properties", "$ARGV[0]\\sbin\\configure", "$ARGV[0]\\sbin\\useconfig");
@FILTERFILES = ("$ARGV[0]\\lib\\config-templates\\DevsetupDefaults.properties", "$ARGV[0]\\lib\\config-templates\\installer.properties");
foreach $f (@FILTERFILES) {
	# use cp to preserve permissions
	chomp($f);
        system("copy $f $f.orig >> $tmp_copyfile");
        $TmpFile1 = "$f.orig";
	$TmpFile2 = "$f.orig.temp";
	open(IN,"$TmpFile1");
	open(OUT,">$TmpFile2");
	$eachline = <IN>; 
	while($eachline ne "") {
	        $_ = $eachline ;
        	$TmpFile1 = ~s/<msg.RootPath>/$ARGV[0]/g;
        	$TmpFile1 = ~s/<INSTALLER_TYPE>/PKGADD/g;
        	$TmpFile1 = $_;
        	print OUT $TmpFile1;
		$eachline = <IN>;
	}
	close(IN);
	close(OUT);
        system("move $f.orig.temp $f"); 
        system("del $f.orig");
}
close(TEMP);
}

########################################
#
# was configure run? (not necessarily accessible)
#
# - sets the variable wasConfigured to either 0 or 1
# - requires basedir
#
########################################
sub get_wasConfigured
{
if ( -f "$ARGV[0]/sbin/start-msg.bat" ) {
	$wasConfigured = 1;
} else {
	$wasConfigured = 0;
}
&log_only ("-- wasConfigured = $wasConfigured");
}

########################################
#
# Is configuration accessible?
#
# - calls get_wasConfigured, see that subroutine for details
# - sets the variable isConfigAccessible to either 0 or 1
# - requires basedir
#
# checks to see if config/... is accessible
# if -R is passed then consider this system as not having an accessible
#    configuration.
#
########################################
sub get_isConfigAccessible
{
&get_wasConfigured;
if( $wasConfigured == 1) {
	if ( -f "$ARGV[0]/config/imta_tailor" ) {
		$isConfigAccessible=1;
	} else {
      		$isConfigAccessible=0;
	}
} else {
	$isConfigAccessible=0;
}
&log_only ("-- isConfigAccessible = $isConfigAccessible");
}

#########################################
#
# read saveState file for configuration variables
# - given basedir
# - get iMS.UserId, iMS.GroupId
# - set the shell variables
#   saveState         shell variable
#   ---------         --------------
#   iMS.UserId     -> user
#   iMS.GroupId    -> group
# - set the variable "saveState" for the location of the saveState file
#
#########################################
sub read_saveState
{
# determine saveState file
# have to use the latest install/configure_YYYYMM... directory
$TmpFile = "$ARGV[0]\\lib\\config-templates\\tmpfile.txt";
open(TEMP,"$TmpFile");
system("dir /B $ARGV[0]\\install\\configure_*>$TmpFile");
close(TEMP);
if ( -z "$TmpFile" ) {
	&log_only ("-- WARNING: no configure_YYYYMM... directory found");
	&log_only ("-- Hard coding mailsrv user and group for devinstall utility");
	$saveState="none";
	# user is not relevant as of now, there are not files that I can examine
	# to determine what the mailsrv user is. As long as nothing in
	# config.ins.template requires it, I am okay
	$user = bin;
	&log_only ("-- user: $user");
	$group = mail;
    	&log_only ("-- group: $group");
} else {
	open(CONFIGDIRS,"<$TmpFile");
	$line = <CONFIGDIRS>;
	while ($line ne "") {
		$saveState = "$line\\saveState";
		if ( -f "$saveState" ) {
		  next;
		}
		$line = <CONFIGDIRS>;
        }
        &log_only ("-- saveState file: $saveState");
        open(S_IN,"$saveState");
        $line = <S_IN>;
        while($line ne "") {
        	@l = grep(/iMS.UserId/,$line);
		foreach $u (@l) {
			@u_arr = split(/[\t ]+/,$u);
			$user = $u_arr[3];
			log_only ("-- user: $user");
		}
		@t = grep(/iMS.GroupId/,$line);
		foreach $v (@t) {
			@g_arr = split(/[\t ]+/,$v);
			$group = $g_arr[3];
			log_only ("-- group: $group");
		}
    		$line = <S_IN>;
	}
}
close(S_IN);
close(TEMP);
close(CONFIGDIRS);
system("del $TmpFile");
}

##########################################
#
# To get the User name and Group ID
#
##########################################
sub getUserAndGroupID
{
$DevSetupFile = "$ARGV[0]\\sbin\\DevsetupDefaults.properties";
open(DSF,$DevSetupFile);
$line = <DSF>;
while($line ne "") {
	$_ = $line;
	@l = grep(/iMS.UserId/,$line);
	foreach $u (@l) {
		@u_arr = split(/=/,$u);
		$user = $u_arr[1];
		log_only ("-- user: $user");
	}
	@t = grep(/iMS.GroupId/,$line);
	foreach $v (@t) {
		@g_arr = split(/=/,$v);
		$group = $g_arr[1];
		log_only ("-- group: $group");
	}
	$line = <DSF>;
}
close(DSF);
}

##########################################
#
# create config.ins and devtypes.txt
# substitute for msg.RootPath, local.serveruid, local.servergid
# - variables used $basedir, $user, $group
#
##########################################
sub create_configins
{
&log_only ("-- creating config.ins and devtypes.txt");
&log_only ("mkdir $BACKOUTDIR\\lib\\config-templates");
use File::Path qw(mkpath);
mkpath "$BACKOUTDIR\\lib\\config-templates";
# devtypes.txt.template
if ( ! -f "$BACKOUTDIR/lib/config-templates/devtypes.txt" ) {
    &log_only ("copy $ARGV[0]\lib\config-templates\devtypes.txt $BACKOUTDIR\lib\config-templates\devtypes.txt");
    system("copy $ARGV[0]\\lib\\config-templates\\devtypes.txt $BACKOUTDIR\\lib\\config-templates\\devtypes.txt");
}  
&log_only ("s/<local.serveruid>/$user/ s/<local.servergid>/$group/ s:<msg\.RootPath>:$ARGV[0]: from $ARGV[0]\\lib\\config-templates\\devtypes.txt.template to $ARGV[0]\\lib\\config-templates\\devtypes.txt");
$TmpFile1 = "$ARGV[0]\\lib\\config-templates\\devtypes.txt.template";
$TmpFile2 = "$ARGV[0]\\lib\\config-templates\\devtypes.txt.template.temp";
open(IN1,"$TmpFile1");
open(OUT1,">$TmpFile2");
$eachline = <IN1>; 
while($eachline ne "") {
        $_ = $eachline ;  
	$TmpFile1 = ~s/<local.serveruid>/$user/g;
	$TmpFile1 = ~s/<local.servergid>/$group/g;
	$TmpFile1 = ~s/<msg.RootPath>/$ARGV[0]/g;
	$TmpFile1 = $_;
	print OUT1 $TmpFile1;
	$eachline = <IN1>;
}
close(IN1);
close(OUT1);
system("move $ARGV[0]\\lib\\config-templates\\devtypes.txt.template.temp $ARGV[0]\\lib\\config-templates\\devtypes.txt");
# config.ins.template
if ( ! -f "$BACKOUTDIR/lib/config-templates/config.ins" ) {
    &log_only ("copy $ARGV[0]\\lib\\config-templates\\config.ins $BACKOUTDIR\\lib\\config-templates\\config.ins");
    system("copy $ARGV[0]\\lib\\config-templates\\config.ins $BACKOUTDIR\\lib\\config-templates\\config.ins");
}
&log_only ("s/<local.serveruid>/$user/ s/<local.servergid>/$group/ s:<msg\.RootPath>:$ARGV[0]: from $ARGV[0]\\lib\\config-templates\\config.ins.template to $ARGV[0]\\lib\\config-templates\\config.ins");
$TmpFile1 = "$ARGV[0]\\lib\\config-templates\\config.ins.template";
$TmpFile2 = "$ARGV[0]\\lib\\config-templates\\config.ins.template.temp";
open(IN2,"$TmpFile1");
open(OUT2,">$TmpFile2");
$eachline = <IN2>; 
while($eachline ne "") {
        $_ = $eachline ;  
	$TmpFile1 = ~s/<local.serveruid>/${user}/g;
	$TmpFile1 = ~s/<local.servergid>/${group}/g;
	$TmpFile1 = ~s/<msg.RootPath>/$ARGV[0]/g;
	$TmpFile1 = $_;
	print OUT2 $TmpFile1;
	$eachline = <IN2>;
}
close(IN2);
close(OUT2);
system("move $ARGV[0]\\lib\\config-templates\\config.ins.template.temp $ARGV[0]\\lib\\config-templates\\config.ins");
}

#############################################
#
# run_devinstall
# - uses several variable for input
#
#############################################
sub run_devinstall
{
&log_only ("----- Running devinstall");
$pkglist="sepadmsvr:pkgcfg:config";
$tmp_copyfile = "C:\\tmplogfile.txt";
open(TEMP,"$tmp_copyfile");
$Patch_instList = "$PATCHDIR\\install.list";
open(IN3,"$PATCHDIR\\install.list");
&log_only ("$ARGV[0]\\lib\\devinstall.exe -n -m -P -v -l $pkglist -i $ARGV[0]\\lib\\config-templates\\config.ins $ARGV[0]\\lib\\config-templates $ARGV[0]\\lib\\jars $ARGV[0]\\lib>$PATCHDIR\\install.list");
system("$ARGV[0]\\lib\\devinstall.exe -n -m -P -v -l $pkglist -i $ARGV[0]\\lib\\config-templates\\config.ins $ARGV[0]\\lib\\config-templates $ARGV[0]\\lib\\jars $ARGV[0]\\lib>$Patch_instList");
&log_only ("--   return status $?");
close(IN3);
open(IN3,"$PATCHDIR\\install.list");
open(OUT3,">$PATCHDIR\\file.list");
$line = <IN3>;
while($line ne "") {
	@list=grep(/^=F/,$line);
	foreach $f (@list) {
		@cols = split(/[\t ]+/,$f);
		$fifth = $cols[2];
		$_ = $fifth;
		$fifth = ~s/[\:\\]//g;
		$fifth = $_;
		$var = "$ARGV[0]";
		$_ = $var;
		$var = ~s/[\:\\]//g;
		$var = $_;
		$_ = $fifth;
		$fifth = ~s/^$var\///gi;
		$fifth = $_;
		$r = grep(/^\//, $fifth);
		if($r == 0) {
			print OUT3 "$fifth";
		}
	}
	$line = <IN3>;
}
close(OUT3);
open(FILELIST,"$PATCHDIR\\file.list");
$fn = <FILELIST>;
while($fn ne "") {
    chomp($fn);	
    $_ = $fn;
    $fn = ~s/\//\\/g;
    $fn = $_;
    $dir = dirname("$BACKOUTDIR\\$fn");
    if ( ! -d "$dir" ) {
      &log_only ("mkdir $dir");
      use File::Path qw(mkpath);
      mkpath $dir;
    }
    if ( ! -f "$BACKOUTDIR/$fn" ) {
      &log_only ("copy $ARGV[0]\\$fn $BACKOUTDIR\\$fn");
      system("copy $ARGV[0]\\$fn $BACKOUTDIR\\$fn >> $tmp_copyfile");
    }
    $fn = <FILELIST>;
}
&log_only ("$ARGV[0]\\lib\\devinstall.exe -m -P -v -l $pkglist -i $ARGV[0]\\lib\\config-templates\\config.ins $ARGV[0]\\lib\\config-templates $ARGV[0]\\lib\\jars $ARGV[0]\\lib");
system("$ARGV[0]\\lib\\devinstall.exe -m -P -v -l $pkglist -i $ARGV[0]\\lib\\config-templates\\config.ins $ARGV[0]\\lib\\config-templates $ARGV[0]\\lib\\jars $ARGV[0]\\lib");
&log_only ("--   return status $?");
close(IN3);
close(FILELIST);
close(TEMP);
}


#############################################
#
# perform_custom
#
#############################################
sub perform_custom
{
&log_only ("-- perform_custom being run");

&log_only ("--");

$tmp_copyfile = "C:\\tmplogfile.txt";
open(TEMP,"$tmp_copyfile");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat clbuild");
system("$ARGV[0]\\sbin\\imsimta.bat clbuild -image_file=IMTA_COMMAND_DATA IMTA_BIN:pmdf.cld 2>> $tmp_copyfile");
&log_only ("--   return status $?");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat chbuild");
system("$ARGV[0]\\sbin\\imsimta.bat chbuild >> $tmp_copyfile");
&log_only ("--   return status $?");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat cnbuild");
system("$ARGV[0]\\sbin\\imsimta.bat cnbuild >> $tmp_copyfile");
&log_only ("--   return status $?");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat version");
system("$ARGV[0]\\sbin\\imsimta.bat version >> $tmp_copyfile");
&log_only ("     return status $?");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat test -rewrite -debug postmaster");
system("$ARGV[0]\\sbin\\imsimta.bat test -rewrite -debug postmaster >> $tmp_copyfile");
&log_only ("--   return status $?");

close(TEMP);
}
