#
# Post Backout Script
#
###########################################
#
# main program starts here
#
# determine basedir
# determine ifConfigured
# if configAccessible
#   perform_custom
#
###########################################
use File::Basename;

if (@ARGV != 2) {
	print "Incorrect no: of arguments\n";
	&Usage;
	exit(1);
}

$PATCHDIR = "$ARGV[0]\\install\\patch\\$ARGV[1]";
use File::Path qw(mkpath);
mkpath $PATCHDIR;
$tstamp = &timestamp;
$LOGFILE = "$PATCHDIR\\postbackout_$tstamp.log";
&log_init;
&get_isConfigAccessible;
if ( $isConfigAccessible == 1 ) {
  	&perform_custom;
}
&log_msg ("--");
&log_msg ("-- Note that you should consider restoring your config files");
&log_msg ("-- to their version prior to application of this patch");
&log_msg ("-- saved versions (if any) are kept under $PATCHDIR/save");
&log_msg ("--");



#######################################
#
# Usage
#
########################################
sub Usage
{
print <<USAGE;

Usage:
	prepatch.pl <Server-Root Path> <base patch number>
	
	Server-Root Path : Path where MS is being installed
	patch number : the base patch number (<patchid>-<patchrev>),
        e.g. 116568-05
	
USAGE
}

########################################
#
# Return the timestamp
#
########################################
sub timestamp
{
$t = time;
$now = localtime($t);
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($t);
$year += 1900;
$mon = $mon + 1;
$_DATE = sprintf ("%d%02d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min, $sec);
}

########################################
#
# Initialize the LogFile
#
########################################
sub log_init
{
$CUR_DATE = sprintf ("%d-%02d-%02d::%02d %02d %02d", $mday, $mon, $year, $hour, $min, $sec);
open (OUT, ">>$LOGFILE");
print OUT "============ LOGFILE started $CUR_DATE ==========\n";
}

########################################
#
# Log a message to the LOGFILE
#
########################################
sub log_only
{
my($message) = @_;
print OUT "$message\n";
}

########################################
#
# Log a message to the screen and to the LOGFILE
#
########################################
sub log_msg
{
my($message) = @_;
print "$message\n";
print OUT "$message\n";
}

########################################
#
# was configure run? (not necessarily accessible)
#
# - sets the variable wasConfigured to either 0 or 1
# - requires basedir
#
########################################
sub get_wasConfigured
{
if ( -f "$ARGV[0]/sbin/start-msg.bat" ) {
	$wasConfigured = 1;
} else {
	$wasConfigured = 0;
}
&log_only ("-- wasConfigured = $wasConfigured");
}

########################################
#
# Is configuration accessible?
#
# - calls get_wasConfigured, see that subroutine for details
# - sets the variable isConfigAccessible to either 0 or 1
# - requires basedir
#
# checks to see if config/... is accessible
# if -R is passed then consider this system as not having an accessible
#    configuration.
#
########################################
sub get_isConfigAccessible
{
&get_wasConfigured;
if( $wasConfigured == 1) {
	if ( -f "$ARGV[0]/config/imta_tailor" ) {
		$isConfigAccessible=1;
	} else {
      		$isConfigAccessible=0;
	}
} else {
	$isConfigAccessible=0;
}
&log_only ("-- isConfigAccessible = $isConfigAccessible");
}

#########################################
#
# perform_custom
# - should only be executed if config is accessible
#
#########################################
sub perform_custom
{
&log_only ("-- perform_custom being run");

$tmp_copyfile = "C:\\tmplogfile.txt";
open(TEMP,"$tmp_copyfile");

&log_msg ("--");
&log_msg ("-- Removing the compiled configuration...");
&log_msg ("-- Use imsimta cnbuild to create a compiled configuration");
&log_msg ("--");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat cnbuild -remove");
system("$ARGV[0]\\sbin\\imsimta.bat cnbuild -remove >> $tmp_copyfile");
&log_only ("--   return status $?");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat version");
system("$ARGV[0]\\sbin\\imsimta.bat version >> $tmp_copyfile");
&log_only ("     return status $?");

&log_only ("--   $ARGV[0]\\sbin\\imsimta.bat test -rewrite -debug postmaster");
system("$ARGV[0]\\sbin\\imsimta.bat test -rewrite -debug postmaster >> $tmp_copyfile");
&log_only ("--   return status $?");
}
