#
# Post Patch Script for DA
#
#######################################
#
# 1. Start the WebServer Instance
#
# 2. Restore the statefile.properties and IscliCfgDeafults.properties
#
# 3. Undeploy /da and /commcli
#
#######################################

if (@ARGV != 2) {
	print "Incorrect no: of arguments\n";
	&Usage;
	exit(1);
}
&startWS;
&restorePropFiles;
&editThePropFile;
&unDeployDA;
&unDeployCommcli;


########################################
#
# Usage
#
########################################
sub Usage
{
print <<USAGE;

Usage:
	postpatch.pl <WebServer-Root Path> <instance-name>
	
	WebServer-Root Path : Path where WebServer is being installed
	instance-name : The instance where DA is been deployed, without 'https-'
	
USAGE
}

#######################################
#
# Start WebServer
#
#######################################
sub startWS
{
	$StartWebServerCmd = "$ARGV[0]\\https-$ARGV[1]\\startsvr.bat";
	system($StartWebServerCmd);
}


#######################################
#
# Backup two properties file
#
#######################################
sub restorePropFiles
{
	$DALibPath = "$ARGV[0]\\..\\DelegatedAdmin\\lib";
	system("move \"$DALibPath\\IscliCfgDefaults.properties.orig\" \"$DALibPath\\IscliCfgDefaults.properties\"");
	system("move \"$DALibPath\\statefile.properties.orig\" \"$DALibPath\\statefile.properties\"");
}


#######################################
#
# Edit the IscliCfgDefaults.properties file for putting double slash
#
#######################################
sub editThePropFile
{
	$IsCliCfgFile = "$ARGV[0]\\..\\DelegatedAdmin\\lib\\IscliCfgDefaults.properties";
	$IsCliCfgFileTemp = "$ARGV[0]\\..\\DelegatedAdmin\\lib\\IscliCfgDefaults.properties.tmp";
	open(IN,"$IsCliCfgFile");
	open(OUT,">$IsCliCfgFileTemp");
	$line = <IN>;
	while($line ne "")
	{
		$_ = $line;
		if(/WS.InstallPath/)
		{
			chomp($line);
			($dummy,$path)=split(/=/,$line);
			$_ = $path;
			$_ =~ s/\\/\\\\/g;
			$path = $_;
			$line = $dummy."=".$path."\n";
		}
		print OUT $line;
		
		$line = <IN>;
	}
	
	close(IN);
	close(OUT);
	
	system("move \"$IsCliCfgFileTemp\" \"$IsCliCfgFile\"");
}


#######################################
#
# UnDeploy DA
#
#######################################
sub unDeployDA
{
	print "UnDeploying DA .... \n";
	$wDeployCmd = "$ARGV[0]\\bin\\https\\httpadmin\\bin\\wdeploy.bat";
	$unDeployDACmd = $wDeployCmd." delete -u /da -i ".$ARGV[1]." -v https-".$ARGV[1]." soft";
	system($unDeployDACmd);
}


#######################################
#
# UnDeploy Commcli
#
#######################################
sub unDeployCommcli
{
	print "UnDeploying Commcli .... \n";
	$wDeployCmd = "$ARGV[0]\\bin\\https\\httpadmin\\bin\\wdeploy.bat";
	$unDeployCommcliCmd = $wDeployCmd." delete -u /commcli -i ".$ARGV[1]." -v https-".$ARGV[1]." soft";
	system($unDeployCommcliCmd);
}
