#!/bin/sh
# Copyright(c) 2002 Sun Microsystems, Inc.
# All rights reserved.

#pragma ident "@(#)session_help.sh   1.2     05/01/18 SMI"

#============================================================
# This help script is to launch Session Manager Help in mozilla
#============================================================

type mozilla >/dev/null 2>&1

if [ $? -ne 0 ]; then

  echo Could not invoke mozilla to display online help.
  echo Please set the mozilla Path in your machine.
  if [ -n "$DISPLAY" ]; then
    if (type xterm >/dev/null 2>&1); then
      xterm -e  sh -c  '
       echo; echo; 
       echo Could not invoke mozilla to display Session online help.;
       echo Please set the mozilla Path in your machine.;
       echo Press Any Key to dismiss this window.;
       read ch'  &
    fi
  fi   
  exit 1

fi

LANG_DIR=$LANG
if [ -z "$LANG_DIR" ]; 
then
  LANG_DIR=C
fi

VTS_INST=`/usr/bin/pwd`
VTS_BASE=`dirname $VTS_INST`

# If help files are not installed for that LANG, display
# the one in C lang dir.
if [ ! -f $VTS_BASE/lib/locale/$LANG_DIR/help/Session_Help.html ];
then
  LANG_DIR=C
fi

mozilla $VTS_BASE/lib/locale/$LANG_DIR/help/Session_Help.html &

exit 0
