#!/bin/sh
#
# Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Helper script to check in execution plans, into the
# N1GSPS Master Server (MS), setup targetted vars,
# and addition of a n1gc virtual host for internal
# plan runs.
#

. /opt/sun/n1gc/bin/n1hss_common.sh

CLUI_USER=admin
CLUI_PASS=admin

# new HD only host type
HD_VHOST_TYPE=HD_VHOST_TYPE

# target substitution variables
HID=HOST_ID
PKG_LIST=PKG_LIST
CMD=FULL_CMD_STRING
SRVR_URL=SERVER_URL
PARM_FILE=PARM_FILE
PARM_KEY=PARM_KEY
SERVER_NAME=SERVER_NAME
APPLIANCE_ID=APPLIANCE_ID
FORCE=FORCE
JOBID_KEY=JOBID_KEY
INSTALLER_HOME=INSTALLER_HOME
INSTALL_PATH=INSTALL_PATH
RCMD_KEY=RCMD_KEY
JOBDELETIONCMD_KEY=JOBDELETIONCMD_KEY
SETAGENTIPCMD_KEY=SETAGENTIPCMD_KEY
SCS_BASE=SCS_BASE
SPS_BASE=SPS_BASE
PKGDEPLOY_KEY=PKGDEPLOY_KEY
PKGUNINSTALL_KEY=PKGUNINSTALL_KEY
CACAO_BASE=CACAO_BASE
CACAO_LIB=CACAO_LIB
JDMK_BASE=JDMK_BASE
APPDEPLOYINFRA_KEY=APPDEPLOYINFRA_KEY

# checkin the appropriate HD (internal) plans
PLAN1=/cr/OSDeployPlan.xml
PLAN2=/cr/PkgDeployPlan.xml
PLAN3=/cr/PkgUninstallPlan.xml
PLAN7=/cr/DiscoveryPlan.xml
PLAN8=/cr/CreateDistroPlan.xml
PLAN9=/cr/ServerResetPlan.xml
PLAN10=/cr/ServerPowerOffPlan.xml
PLAN11=/cr/ServerPowerOnPlan.xml
PLAN12=/cr/ServerRefreshPlan.xml
PLAN13=/cr/FWDeployPlan.xml
PLAN14=/cr/RemoteCmdPlan.xml
PLAN16=/cr/JobDeletionCmdPlan.xml
PLAN15=/cr/SetAgentIPJobPlan.xml
PLAN17=/cr/AppDeployJobPlan.xml
PLAN18=/cr/AddServerOSMJobPlan.xml
PLAN19=/cr/RemoveServerOSMJobPlan.xml
PLAN20=/cr/SetAgentIPCoreJobPlan.xml
PLAN21=/cr/SetAgentIPOsmJobPlan.xml

$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN1
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN2
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN3
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN7
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN8
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN9
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN10
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN11
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN12
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN13
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN14
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN16
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN15
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN17
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN18
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN19
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN20
$CR_CLI -cmd pdb.p.ci -u $CLUI_USER -p $CLUI_PASS -path $PLAN21

# add a HD host type
$CR_CLI -cmd hdb.ht.add -u $CLUI_USER -p $CLUI_PASS -name $HD_VHOST_TYPE -attr $SRVR_URL\;$HID\;$PKG_LIST\;$CMD\;$PARM_FILE\;$PARM_KEY\;$SERVER_NAME\;$FORCE\;$JOBID_KEY\;$INSTALLER_HOME\;$INSTALL_PATH\;$RCMD_KEY\;$APPLIANCE_ID\;$JOBDELETIONCMD_KEY\;$SETAGENTIPCMD_KEY\;$SCS_BASE\;$SPS_BASE\;$PKGDEPLOY_KEY\;$PKGUNINSTALL_KEY\;$CACAO_BASE\;$CACAO_LIB\;$JDMK_BASE\;$APPDEPLOYINFRA_KEY

exit 0
