/**
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to
 * license terms. Copyright  2001 Sun Microsystems, Inc.
 * Some preexisting portions Copyright  2001 Netscape Communications Corp.
 * All rights reserved.
 */
/*
 * csect.h: Cache section handling
 *
 *
 *
 *
 *
 * Ari Luotonen
 * Copyright (c) 1995 Netscape Communcations Corporation
 *
 */

#ifndef NS_CACHE_SECTION_H
#define NS_CACHE_SECTION_H

#define CACHE_MAX_SECTIONS	256	/* Enough for 32 GB of data */


typedef struct _CSect {
    char *	root;
    int		open;
    int		part_idx;
    int		still_used;
    long	chng;		/* used by gc*/
    long	cur_blks;	/* used by gc */
    PRLock      *lock;
} CSect;


/* Cache sections */
extern CSect	sects[CACHE_MAX_SECTIONS];

int open_section (char *root, int sect_idx, int part_idx);
NSAPI_PUBLIC int open_sections(char *root, int part_idx);
int close_section(int idx);


#endif

