#!/bin/sh

# Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
#
# Sun Microsystems, Inc. has intellectual property rights relating to
# technology embodied in the product that is described in this document.
# In particular, and without limitation, these intellectual property rights
# may include one or more of the U.S. patents listed at
# http://www.sun.com/patents and one or more additional patents or pending
# patent applications in the U.S. and in other countries.
#
# U.S. Government Rights - Commercial software.  Government users are subject
# to the Sun Microsystems, Inc. standard license agreement and applicable
# provisions of the FAR and its supplements.
#
# Use is subject to license terms.
#
# This distribution may include materials developed by third parties.Sun,
# Sun Microsystems and  the Sun logo are trademarks or registered trademarks
# of Sun Microsystems, Inc. in the U.S. and other countries.  
#
# Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
# Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
#  la technologie incorpore dans le produit qui est dcrit dans ce document.
# En particulier, et ce sans limitation, ces droits de proprit
# intellectuelle peuvent inclure un ou plus des brevets amricains lists
#  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
# ou les applications de brevet en attente aux Etats - Unis et dans les
# autres pays.
#
# L'utilisation est soumise aux termes du contrat de licence.
#
# Cette distribution peut comprendre des composants dvelopps par des
# tierces parties.
#
# Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
# marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
# d'autres pays.

ROOT_REALM_DELEGATION_POLICIES=${XML_DIR}/rootRealmPolicy.txt
SUB_REALM_DELEGATION_POLICIES=${XML_DIR}/subRealmPolicy.txt
DEFAULT_DELEGATION_POLICIES=${XML_DIR}/defaultDelegationPolicies.xml

# find all the organization DNs.
${PKGDIR}/bin/ldapsearch -h "$DS_HOST" -p "$DS_PORT" \
    -D "$AMADMIN_DN" -w "$ADMINPASSWD" -b "$ROOT_AM_SUFFIX" -B -1 \
    "(objectclass=sunISManagedOrganization)" dn > orgs.ldif

# Add the beginning xml tags into the xml file
$NECHO "<?xml version=\"1.0\" encoding=\"XML_ENCODING\"?>" > $DEFAULT_DELEGATION_POLICIES 
$NECHO "<!DOCTYPE Requests" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "    PUBLIC \"-//iPlanet//Sun Java System Access Manager 2005Q4 Admin CLI DTD//EN\"" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "\"jar://com/iplanet/am/admin/cli/amAdmin.dtd\">" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "<Requests>" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "<RealmRequests>" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "<CreateRealm realm=\"/sunamhiddenrealmdelegationservicepermissions\" />" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "</RealmRequests>" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "<RealmRequests>" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "<RealmCreatePolicy realm=\"/sunamhiddenrealmdelegationservicepermissions\">" >> $DEFAULT_DELEGATION_POLICIES

if [ -f orgs.ldif  -a  -s orgs.ldif ] 
then
    for ORGNAME in `$CAT orgs.ldif`
    do
        if [ -n "$ORGNAME" ] 
        then  
            if [ "$ORGNAME" = "$ROOT_AM_SUFFIX" ]
            then
                POLICIES=`cat $ROOT_REALM_DELEGATION_POLICIES`
            else
                POLICIES=`cat $SUB_REALM_DELEGATION_POLICIES`
            fi 
            ORGID=$ORGNAME
            ORGID=`$ECHO $ORGID | tr ',' '^'`
            POLICIES=`$ECHO "$POLICIES"|$SED -e "s/ORGSUFFIX/$ORGNAME/g"`
            POLICIES=`$ECHO "$POLICIES"|$SED -e "s/ORGID/$ORGID/g"`
            $ECHO "$POLICIES" >> $DEFAULT_DELEGATION_POLICIES
        fi
    done 
fi

# Add the closing xml tags into the xml files
$NECHO "</RealmCreatePolicy>" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "</RealmRequests>" >> $DEFAULT_DELEGATION_POLICIES
$NECHO "</Requests>" >> $DEFAULT_DELEGATION_POLICIES

# remove the orgs.ldif
$RM orgs.ldif

