# Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
#
# Sun Microsystems, Inc. has intellectual property rights relating to
# technology embodied in the product that is described in this document.
# In particular, and without limitation, these intellectual property rights
# may include one or more of the U.S. patents listed at
# http://www.sun.com/patents and one or more additional patents or pending
# patent applications in the U.S. and in other countries.
#
# U.S. Government Rights - Commercial software.  Government users are subject
# to the Sun Microsystems, Inc. standard license agreement and applicable
# provisions of the FAR and its supplements.
#
# Use is subject to license terms.
#
# This distribution may include materials developed by third parties.Sun,
# Sun Microsystems and  the Sun logo are trademarks or registered trademarks
# of Sun Microsystems, Inc. in the U.S. and other countries.  
#
# Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
# Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
#  la technologie incorpore dans le produit qui est dcrit dans ce document.
# En particulier, et ce sans limitation, ces droits de proprit
# intellectuelle peuvent inclure un ou plus des brevets amricains lists
#  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
# ou les applications de brevet en attente aux Etats - Unis et dans les
# autres pays.
#
# L'utilisation est soumise aux termes du contrat de licence.
#
# Cette distribution peut comprendre des composants dvelopps par des
# tierces parties.
#
# Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
# marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
# d'autres pays.

### This awk script takes preMigrationNamedConf.ldif and parses it line by
#   line. Generates postMigrationNamedConf.ldif to be loaded into the 
#   directory server. The script has the logic to create a named 
#   configurations for all the orgs.

BEGIN {
    # Variables that maintain state across lines of ldif file being processed.
    rec_type="NONE";
    dn_count=0;
    prev_config_dn="";
    prev_org_name="";
    prev_admin_modules="";
    prev_org_config="";
}
{
    if ( $0 ~ /^dn:/) {
        dn_count=dn_count+1;
        if (rec_type == "SK") { #if previous line was sunkeyvalue and current starts with dn: 
            if (prev_org_name != root_org) { #non-root org
                # We will add the two org units for all orgs other than 
                # root org which already has these.
                printf "\n\ndn: ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
                printf "\nchangetype: add";
                printf "\nobjectclass: top";
                printf "\nobjectclass: SunService";
                printf "\n\ndn: ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
                printf "\nchangetype: add";
                printf "\nobjectclass: top";
                printf "\nobjectclass: SunService";
            }
            # Add org units so that we can create auth configuration.
            printf "\n\ndn: ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: organizationalunit";
            printf "\n\ndn: ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: sunServiceComponent";
            printf "\n\ndn: ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: sunServiceComponent";
            # Create the auth configuration and put the value obtained from 
            # iplanet-am-auth-org-config attribute in 6.3 instance
            printf "\n\ndn: ou=%s-authconfig,ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_org_name,prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectClass: top";
            printf "\nobjectClass: sunServiceComponent";
            printf "\nsunserviceid: NamedConfiguration";
            # Create the admin auth configuration and put the value obtained 
            # from iplanet-am-auth-admin-auth-module attribute in 6.3 instance
            printf "\nsunkeyvalue: iplanet-am-auth-configuration=%s",prev_org_config;
            printf "\n\ndn: ou=%s-admin-authconfig,ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_org_name,prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectClass: top";
            printf "\nobjectClass: sunServiceComponent";
            printf "\nsunserviceid: NamedConfiguration";
            printf "\nsunkeyvalue: iplanet-am-auth-configuration=%s",prev_admin_modules;
        }
        if (dn_count == 1) {
            # If this is the root org then set the org name as set by value 
            # passed into the script.
            curr_org=root_org;
            prev_org_name=curr_org;
        }
        else {
            # Else get it from the input line 
            indxOfOEqual=index($0, "ORG_NAMING_ATTR=") ;
            orgname_len=length("ORG_NAMING_ATTR=");
            nohead=substr($0,indxOfOEqual);
            indxOfComma=index(nohead, ",") ;
            curr_org=substr(nohead,(orgname_len+1),(indxOfComma-(orgname_len+1)));
            prev_org_name=curr_org;
        }
        rec_type="DN";

        prev_config_dn=substr($0,69); # String after ou=services
        # detels all sunkey value entries for this dn.
        printf "\n\n%s",$0;
        printf "\nchangetype: modify";
        printf "\ndelete:sunkeyvalue";
        printf "\n-";
        # adds org and admin org config for this dn
        printf "\nadd:sunkeyvalue";
        printf "\nsunkeyvalue: iplanet-am-auth-org-config=%s-authconfig",curr_org;
        printf "\nsunkeyvalue: iplanet-am-auth-admin-auth-module=%s-admin-authconfig",curr_org;

    }
    else if ( $0 ~ /^sunkeyvalue: iplanet-am-auth-allowed-modules/) {
	rec_type="SK";
    }
    else if ( $0 ~ /^sunkeyvalue: iplanet-am-auth-admin-auth-module/) {
        rec_type="SK";
        # if the 6.3 DIT had iplanet-am-auth-admin-auth-module, this is 
        # the name of admin auth configuration
        prev_admin_modules=substr($0,48); #Value for this attribute
    }
    else if ($0 ~ /^sunkeyvalue: iplanet-am-auth-org-config/) {
        # if the 6.3 DIT had iplanet-am-auth-org-config, this is 
        # the name of  org auth configuration
        rec_type="SK";
        prev_org_config=substr($0,41);  #Value for this attribute
    }
    else if ($0 ~ /^sunkeyvalue:/){
        # if sunkeyvalue has none of above attributes, let it go into 
        # 7.0 unaltered.
        rec_type="SK";
        printf "\n%s",$0;
    }
}

END {
    # This is written to create the org and admin auth configuration for 
    # the last org in the input ldif file. Since the config creation for a dn 
    # happens after we enter the next dn. And there is no next dn for the 
    # last one

    if (prev_org_name != root_org) { #non-root org
        printf "\n\ndn: ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
        printf "\nchangetype: add";
        printf "\nobjectclass: top";
        printf "\nobjectclass: SunService";
        printf "\n\ndn: ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
        printf "\nchangetype: add";
        printf "\nobjectclass: top";
        printf "\nobjectclass: SunService";
    }
    printf "\n\ndn: ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
    printf "\nchangetype: add";
    printf "\nobjectclass: top";
    printf "\nobjectclass: organizationalunit";
    printf "\n\ndn: ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
    printf "\nchangetype: add";
    printf "\nobjectclass: top";
    printf "\nobjectclass: sunServiceComponent";
    printf "\n\ndn: ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
    printf "\nchangetype: add";
    printf "\nobjectclass: top";
    printf "\nobjectclass: sunServiceComponent";
    printf "\n\ndn: ou=%s-authconfig,ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_org_name,prev_config_dn;
    printf "\nchangetype: add";
    printf "\nobjectClass: top";
    printf "\nobjectClass: sunServiceComponent";
    printf "\nsunserviceid: NamedConfiguration";
    printf "\nsunkeyvalue: iplanet-am-auth-configuration=%s",prev_org_config;
    printf "\n\ndn: ou=%s-admin-authconfig,ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_org_name,prev_config_dn;
    printf "\nchangetype: add";
    printf "\nobjectClass: top";
    printf "\nobjectClass: sunServiceComponent";
    printf "\nsunserviceid: NamedConfiguration";
    printf "\nsunkeyvalue: iplanet-am-auth-configuration=%s",prev_admin_modules;
    printf "\n";
    fflush(""); 
}
