# Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
#
# Sun Microsystems, Inc. has intellectual property rights relating to
# technology embodied in the product that is described in this document.
# In particular, and without limitation, these intellectual property rights
# may include one or more of the U.S. patents listed at
# http://www.sun.com/patents and one or more additional patents or pending
# patent applications in the U.S. and in other countries.
#
# U.S. Government Rights - Commercial software.  Government users are subject
# to the Sun Microsystems, Inc. standard license agreement and applicable
# provisions of the FAR and its supplements.
#
# Use is subject to license terms.
#
# This distribution may include materials developed by third parties.Sun,
# Sun Microsystems and  the Sun logo are trademarks or registered trademarks
# of Sun Microsystems, Inc. in the U.S. and other countries.  
#
# Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
# Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
#  la technologie incorpore dans le produit qui est dcrit dans ce document.
# En particulier, et ce sans limitation, ces droits de proprit
# intellectuelle peuvent inclure un ou plus des brevets amricains lists
#  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
# ou les applications de brevet en attente aux Etats - Unis et dans les
# autres pays.
#
# L'utilisation est soumise aux termes du contrat de licence.
#
# Cette distribution peut comprendre des composants dvelopps par des
# tierces parties.
#
# Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
# marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
# d'autres pays.

### This awk script takes preMigrationNamedConf_role.ldif and parses it line by
#   line. Generates postMigrationNamedConf_role.ldif to be loaded into the 
#   directory server. The script has the logic to create a named 
#   configurations for all the orgs.

BEGIN {
    # Variables that maintain state across lines of ldif file being processed.
    rec_type="NONE";
    dn_count=0;
    prev_config_dn="";
    prev_role_name="";
    prev_succ_url="";
    prev_fail_url="";
    prev_plugin_class="";
    prev_auth_config="";
}
{
    if ( $0 ~ /^cn="cn=/) {
        dn_count=dn_count+1;
        if (rec_type == "IP") { #if previous line was sunkeyvalue and current starts with dn: 
            printf "\n\ndn: ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: SunService";
            printf "\n\ndn: ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: SunService";
            # Add org units so that we can create auth configuration.
            printf "\n\ndn: ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: organizationalunit";
            printf "\n\ndn: ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: sunServiceComponent";
            printf "\n\ndn: ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: sunServiceComponent";
            # Create the auth configuration and put the value obtained from 
            # iplanet-am-auth-org-config attribute in 6.3 instance
            printf "\n\ndn: ou=%s-roleauthconfig,ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_role_name,prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectClass: top";
            printf "\nobjectClass: sunServiceComponent";
            printf "\nsunserviceid: NamedConfiguration";
            # Create the admin auth configuration and put the value obtained 
            # from iplanet-am-auth-admin-auth-module attribute in 6.3 instance
            printf "\nsunkeyvalue: iplanet-am-auth-configuration=%s",prev_auth_config;
            printf "\nsunkeyvalue: iplanet-am-auth-login-success-url=%s",prev_succ_url;
            printf "\nsunkeyvalue: iplanet-am-auth-login-failure-url=%s",prev_fail_url;
            printf "\nsunkeyvalue: iplanet-am-auth-post-login-process-class=%s",prev_plugin_class;
        }
        indxOfComma=index($0, ",") ;
        lengthOfDNStr=length("cn=\"cn=");
	curr_role=substr($0,lengthOfDNStr+1,(indxOfComma-(lengthOfDNStr+1)));
        prev_role_name=curr_role;
        rec_type="DN";

        indexOfService=index($0, "cn=iPlanetAMAuthConfiguration");
        lenghtOfService=length("cn=iPlanetAMAuthConfiguration");
        prev_config_dn="ou=services,"substr($0,(indexOfService+lenghtOfService+1)); 
        printf "\n\ndn: %s",$0;
        printf "\nchangetype: modify";
        printf "\nreplace:iplanet-am-auth-configuration";
        printf "\niplanet-am-auth-configuration: %s-roleauthconfig",curr_role;

    }
    else if ( $0 ~ /^iplanet-am-auth-login-success-url/) {
	rec_type="IP";
        indxOfColon=index($0, ":");
        prev_succ_url=substr($0,indxOfColon+1);
    }
    else if ( $0 ~ /^iplanet-am-auth-login-failure-url/) {
	rec_type="IP";
        indxOfColon=index($0, ":");
        prev_fail_url=substr($0,indxOfColon+1);
    }
    else if ($0 ~ /^iplanet-am-auth-post-login-process-class/) {
	rec_type="IP";
        indxOfColon=index($0, ":");
        prev_plugin_class=substr($0,indxOfColon+1);
    }
    else if ($0 ~ /^iplanet-am-auth-configuration/){
	rec_type="IP";
        indxOfColon=index($0, ":");
        prev_auth_config=substr($0,indxOfColon+1);
    }
}

END {
        if (dn_count > 0) { #non-root org
            printf "\n\ndn: ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: SunService";
            printf "\n\ndn: ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: SunService";
            printf "\n\ndn: ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: organizationalunit";
            printf "\n\ndn: ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: sunServiceComponent";
            printf "\n\ndn: ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectclass: top";
            printf "\nobjectclass: sunServiceComponent";
            # Create the auth configuration and put the value obtained from 
            # iplanet-am-auth-org-config attribute in 6.3 instance
            printf "\n\ndn: ou=%s-roleauthconfig,ou=configurations,ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthConfiguration,%s",prev_role_name,prev_config_dn;
            printf "\nchangetype: add";
            printf "\nobjectClass: top";
            printf "\nobjectClass: sunServiceComponent";
            printf "\nsunserviceid: NamedConfiguration";
            # Create auth configuration and put the value obtained 
            # from iplanet-am-auth-configuration attribute in 6.3 instance
            printf "\nsunkeyvalue: iplanet-am-auth-configuration=%s",prev_auth_config;
            printf "\nsunkeyvalue: iplanet-am-auth-login-success-url=%s",prev_succ_url;
            printf "\nsunkeyvalue: iplanet-am-auth-login-failure-url=%s",prev_fail_url;
            printf "\nsunkeyvalue: iplanet-am-auth-post-login-process-class=%s",prev_plugin_class;
            printf "\n";
        }
}
