/**
 * $Id: SampleTokenListener.java,v 1.7 2005/06/24 16:54:05 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import com.iplanet.sso.*;

/** 
 * This is the SSO token listener class to listen for sso token events. 
 * Token events are received when the token state changes. The ssoTokenChanged
 * is the method that gets called when the event arrives.
 */
public class SampleTokenListener implements SSOTokenListener {

    public void ssoTokenChanged(SSOTokenEvent event) {
        try {
            SSOToken token = event.getToken();
            int type = event.getType();
            long time = event.getTime();

            SSOTokenID id = token.getTokenID();
            
            System.out.println("Token id is: " + id.toString());

            if (SSOTokenManager.getInstance().isValidToken(token)) {
                System.out.println("Token is Valid");
            } else {
                System.out.println("Token is Invalid");
            }

            switch(type) {
            case SSOTokenEvent.SSO_TOKEN_IDLE_TIMEOUT:
                System.out.println("Token Idel Timeout event");
                break;
            case SSOTokenEvent.SSO_TOKEN_MAX_TIMEOUT:
                System.out.println("Token Max Timeout event");
                break;
            case SSOTokenEvent.SSO_TOKEN_DESTROY:
                System.out.println("Token Destroyed event");
                break;
            default:
                System.out.println("Unknown Token event");
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}
