/**
 * $Id: SSOTokenSample.java,v 1.9 2005/06/24 16:54:05 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.net.*;
import com.iplanet.sso.*;

/**
 * This sample serves as a basis for using SSO API. It demonstrates creating
 * a SSO Token, calling various methods from the token, setting up event 
 * listeners and getting called on event listeners. Refer to the Readme.txt for 
 * detailed info on how to use this sample.
 *
 * @see com.iplanet.sso.SSOToken
 * @see com.iplanet.sso.SSOTokenID
 * @see com.iplanet.sso.SSOTokenManager
 * @see com.iplanet.sso.SSOTokenEvent
 * @see com.iplanet.sso.SSOTokenListener
 */

public class SSOTokenSample {
    public static void main(String[] args) {

        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();

            SSOToken token = manager.createSSOToken(args[0]);

            /* use isValid method to check if the token is valid or not
             * this method retuns true for valid token, false otherise
             */
            if (manager.isValidToken(token)) {
                /* let us get all the values from the token */

                String host = token.getHostName();
                java.security.Principal principal = token.getPrincipal();
                String authType = token.getAuthType();
                int level = token.getAuthLevel();
                InetAddress ipAddress = token.getIPAddress();
                long maxTime = token.getMaxSessionTime();
                long idleTime = token.getIdleTime();
                long maxIdleTime = token.getMaxIdleTime();
                System.out.println("SSOToken host name: " + host); 
                System.out.println("SSOToken Principal name: " + 
                                   principal.getName());
                System.out.println("Authentication type used: " + authType);
                System.out.println("IPAddress of the host: " + 
                                   ipAddress.getHostAddress());
            }  
            /* let us try to validate the token again, with another method 
             * if token is invalid, this method throws an excpetion
             */
            manager.validateToken(token);

            /* let us get the SSOTokenID associated with the token */
            SSOTokenID id = token.getTokenID();
             
            String tokenId = id.toString();

            /* print the string representation of the token */

            System.out.println("The token ID is " + tokenId);

            /* let us set some properties in the token. We can get the values
             * of set properties later
             */
            token.setProperty("TimeZone", "PST");
            token.setProperty("County", "SantaClara");
            String tZone = token.getProperty("TimeZone");
            String county = token.getProperty("County");

            System.out.println("Property: TimeZone is - " + tZone); 
            System.out.println("Property: County is - " + county); 

            System.out.println("SSO Token Validation test Succeeded");
        } catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}
