/**
 * $Id: SDKCommandLineSSO.java,v 1.5 2005/06/24 16:54:04 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.util.*;
import java.io.*;

import com.iplanet.sso.*;
import javax.security.auth.callback.*;
import com.sun.identity.authentication.internal.*;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.*;
import com.iplanet.am.sdk.*;


public class SDKCommandLineSSO {


    public static void main(String args[]) throws Exception {

        String orgName = args[0];
        System.out.println("orgname is : " + orgName);

        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken token = getAuthcontext(orgName).getSSOToken();

        String userDN = token.getPrincipal().getName();
        System.out.println("User : " + userDN);

        // Get a connection to the Identity Store and retrieve the attributes for
        // the user DN in the token. The userDN could be any user DN to which the
        // user in the SSOToken has read access. We use the authenticated user
        // as a sample.

        try {
            AMStoreConnection conn = new AMStoreConnection(token);
            AMUser user = conn.getUser(userDN);
            Map attrs = user.getAttributes();
            System.out.println("Attrs: " + attrs);
        } catch (Exception e) {
            System.out.println("Exception Message: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            manager.destroyToken(token);
            System.out.println("Logged Out!!");
        } catch (SSOException ssoe) {
            System.out.println("Exception Message: " + ssoe.getMessage());
            ssoe.printStackTrace();
        }
        System.exit(1);
    }

    // Creates AuthContext and submits requirements
    private static AuthContext getAuthcontext(String orgName) {
        String indexName = "";
        AuthContext.IndexType indexType;
        // Initialize LoginContext
        AuthContext lc = null;
        try {
            lc = new AuthContext(orgName);
            indexType = AuthContext.IndexType.MODULE_INSTANCE;
            indexName = "LDAP";
            System.out.println("LDAPLogin: Obtained login context");
            lc.login(indexType, indexName);
        } catch (AuthLoginException le) {
            le.printStackTrace();
            System.out.println("Login failed!!");
            System.exit(0);
        }

        Callback[] callback = null;
        try {
            callback = lc.getRequirements();
            for (int loop =0 ; loop < callback.length ; loop ++) {
                if (callback[loop] instanceof NameCallback) {
                    NameCallback name = (NameCallback) callback[loop];
                    System.err.print(name.getPrompt());
                    System.err.flush();
                    name.setName((new BufferedReader
                             (new InputStreamReader(System.in))).readLine());
                }
                if (callback[loop] instanceof PasswordCallback) {
                    PasswordCallback pass = (PasswordCallback) callback[loop];
                    System.err.print(pass.getPrompt());
                    System.err.flush();
                    pass.setPassword(readPassword(System.in));
                }
            }
        } catch (Exception e) {
            System.out.println("Exception Message: " + e.getMessage());
            e.printStackTrace();
            System.exit(0);
        }

        lc.submitRequirements(callback);
        if (lc.getStatus() == AuthContext.Status.SUCCESS) {
             System.out.println("Successful authentication ...");
        } else {
             System.out.println("Authentication Failed ....... ");
             System.exit(0);
        }
        return lc;
    }

    // Reads user password from given input stream.
    private static char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf;
        int i;

        buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        int c;

        loop:
            while (true) {
                switch (c = in.read()) {
                    case -1:
                    case '\n':
                        break loop;

                    case '\r':
                        int c2 = in.read();
                        if ((c2 != '\n') && (c2 != -1)) {
                            if (!(in instanceof PushbackInputStream)) {
                                in = new PushbackInputStream(in);
                            }
                            ((PushbackInputStream)in).unread(c2);
                        } else
                            break loop;

                    default:
                        if (--room < 0) {
                            buf = new char[offset + 128];
                            room = buf.length - offset - 1;
                            System.arraycopy(lineBuffer, 0, buf, 0, offset);
                            Arrays.fill(lineBuffer, ' ');
                            lineBuffer = buf;
                        }
                        buf[offset++] = (char) c;
                        break;
                }
            }

            if (offset == 0) {
                return null;
            }

            char[] ret = new char[offset];
            System.arraycopy(buf, 0, ret, 0, offset);
            Arrays.fill(buf, ' ');

            return ret;
    }
}
