/**
 * $Id: Utils.java,v 1.7 2005/06/24 16:53:58 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


package com.iplanet.am.samples.saml.sso;

import java.io.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.*;

import com.iplanet.am.util.Debug;

import com.sun.identity.saml.common.*;


public class Utils {
    public static Debug debug = Debug.getInstance("samlSample");


    /**
     * Gets the value of an element. This method returns a concatenated String
     * from all its TEXT children.
     * @param element a DOM tree element.
     * @return A String that contained in its TEXT children;
     *          or null if an error occurred.
     */
    public static String getElementValue(Element element) {
        StringBuffer sb = new StringBuffer(1000);
        try {
            NodeList nl = element.getChildNodes();
            Node child = null;
            int length = nl.getLength();
            for (int i = 0; i < length; i++) {
                child = nl.item(i);
                if (child.getNodeType() == Node.TEXT_NODE ) {
                    sb.append(child.getNodeValue());
                }
            }
        } catch (Exception e) {
	    if (debug.messageEnabled()) {
	        debug.message("Ustils::getElementValue", e);
	    }
            return null;
        }

        return sb.toString().trim();
    }


    /**
     * Converts the XML document from a String format to DOM Document format.
     *
     * @param xmlString is the XML document in a String format
     * @return Document is the DOM object obtained by converting the String XML
     *         Returns null if xmlString is null.
     *         Returns null if there are any parser errores.
     * @exception SAMLException
     */
    public static Document toDOMDocument(String xmlString)
					throws SAMLException {
        if (xmlString == null) {
	    debug.message("Utils: The input string is null.");
            return null;
        }

        DocumentBuilderFactory dbFactory = null;
        try {
	    // Assign new debug object 
            dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
        } catch (Exception e) {
	    debug.error("Utils.DocumentBuilder init failed:", e);
            throw new SAMLResponderException(e.getMessage());
        }

        try {    
            DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
            
            if (documentBuilder == null) {
	        debug.message("Utils.toDOM:null builder instance");
                return null;
            }

            ByteArrayInputStream is = new ByteArrayInputStream(
                xmlString.getBytes(SAMLConstants.DEFAULT_ENCODING));
            return documentBuilder.parse(is);
        } catch (Exception e){
	    debug.error("Can't parse the document:", e);
            throw new SAMLRequesterException(e.getMessage());
        }
    }
}
