/**
 * $Id: SAMLClientSample.java,v 1.8 2005/06/24 16:53:55 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.io.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.sun.identity.saml.SAMLClient; 
import com.sun.identity.saml.common.*; 
import com.sun.identity.saml.assertion.*; 
import com.sun.identity.saml.protocol.*; 
import com.iplanet.sso.*;
import com.sun.identity.saml.*; 
import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * This Sample serves as a basis for using SAMLClient API. This servlet runs on 
 * on a client site. It calls SAMLClient API to retrieve the Assertion from the 
 * server site. 
 * For detailed info refer to the README file 
 *
 * @see com.sun.identity.saml.assertion.*
 * @see com.sun.identity.saml.protocol.*
 * @see com.sun.identity.saml.SAMLClient
 * @see com.sun.identity.saml.AssertionManager
 * @see com.sun.identity.saml.common.*
 */

public class SAMLClientSample extends HttpServlet { 
    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response)
                      throws IOException {      
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            /*If the user chooses different Artifact name, please modify the  
              line below */
            String artifactName = "SAMLart";
            String artifact = request.getParameter(artifactName);
            Assertion assertion = SAMLClient.getAssertionByArtifact(artifact);  
            out.println("<html>\n");
            out.println("<head>\n");
            out.println("<title>SAMLClientSample servlet on machine 2 " + 
                        "</title>\n");
            out.println("</head>\n");
            out.println("<body>\n");
            out.println("<H1> SampleClientSample on machine 2 </H1>\n"); 
            out.println("<P>\n");
            out.println("An Assertion has been retrieved from machine 1 " + 
                        "using AssertionArtifact " + artifact + "\n<BR>\n");
            out.println("The Assertion is displayed as below: \n");
            out.println("<HR>\n");
            out.println(displayXML(assertion.toString()));  
            out.println("</P>\n");
            out.println("</body>\n");
            out.println("</html>\n");    
            out.flush();
        } catch (Exception e) {
            out.println("Exception in SAMLClientSample: " + e.getMessage()); 
            out.flush();
            return; 
        }
    } 
    
    /*This is a utility function used to hack up an HTML display of an XML 
      string.*/
    private String displayXML(String input) {
        StringCharacterIterator iter = new StringCharacterIterator(input);
        StringBuffer buf = new StringBuffer();    
        for(char c = iter.first();c != CharacterIterator.DONE;c = iter.next()) {       
            if (c=='>') {
                buf.append("&gt;");
            } else if (c=='<') {
                buf.append("&lt;");
            } else if (c=='\n'){
                buf.append("<BR>\n");
            } else {
                buf.append(c);
            }
        }
        return buf.toString();
    }
}