<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@page 
import="java.io.*, 
java.util.*,
java.security.Principal,
com.iplanet.sso.SSOToken,
com.iplanet.sso.SSOTokenManager,
com.iplanet.sso.SSOException,
com.iplanet.am.util.XMLUtils,
com.sun.identity.saml.common.*,
com.sun.identity.liberty.ws.disco.*,
com.sun.identity.liberty.ws.disco.jaxb.*,
com.sun.identity.liberty.ws.disco.plugins.Default64ResourceIDMapper,
com.sun.liberty.LibertyManager,
org.w3c.dom.*,
javax.xml.bind.*,
javax.xml.transform.stream.*"
%>

<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <head><title>Discovery Service Boot Strapping</title></head>
    <body bgcolor="white">
	<h1>Discovery Service Boot Strapping Resource Offering</h1>
<%
    try {
        // WSC-SP Provider ID
        String providerID = "http://www.sp1.com";
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        if(ssoToken != null && manager.isValidToken(ssoToken)) {
            NodeList offerings = LibertyManager.
            getDiscoveryBootStrapResourceOfferings(request, providerID, "SP");
	    if(offerings == null) {
                %>ERROR: no resource offering in AttributeStatement.<%
            } else {
		org.w3c.dom.Element offeringEle = 
                    (org.w3c.dom.Element) offerings.item(0);
                ResourceOffering offering = new ResourceOffering(offeringEle);
                String remoteProvider = 
                       offering.getServiceInstance().getProviderID(); 
		String fnSuffix = remoteProvider.replace('/','_');
		String fileName = "/tmp/RO_" + fnSuffix;
		FileOutputStream ais = new FileOutputStream(new File(fileName));
                com.sun.org.apache.xml.security.utils.XMLUtils.outputDOM(
                                offeringEle, ais);
                // get reourceID
                    %>
<pre><%= SAMLUtils.displayXML(offering.toString()) %></pre>

<form method="GET" action="discovery-query.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='discoveryResourceOffering' value='<%= fileName %>'>
<input type="submit" name="Submit" value="Send Discovery Lookup" />
</form>
<p>
<form method="GET" action="discovery-modify.jsp">
<input type='hidden' name='providerID' value='<%= providerID %>'>
<input type='hidden' name='discoveryResourceOffering' 
    value='<%= fileName %>'>
<input type="submit" name="Submit" value="Add PP Resource Offering" />
</form>
		   <%
	    }
        } else {
	    %>ERROR: user not logged in.<%
        }
    } catch (Exception ex) {
        StringWriter bufex = new StringWriter();
        ex.printStackTrace(new PrintWriter(bufex));
        %>
            ERROR: caught Exception:
            <pre>
        <%
            out.println(bufex.toString());
        %>
            </pre>
        <%
    }
%>
	<hr/>
    </body>
</html>
