<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@page import="java.io.*,java.util.*,com.sun.identity.saml.common.*,com.sun.identity.liberty.ws.dst.*,com.sun.identity.liberty.ws.disco.jaxb.*,com.sun.identity.liberty.ws.disco.*,javax.xml.bind.*,javax.xml.transform.stream.*, com.sun.identity.liberty.ws.idpp.*, com.sun.identity.liberty.ws.idpp.jaxb.*, com.sun.identity.liberty.ws.interaction.*, com.sun.identity.liberty.ws.soapbinding.*,com.iplanet.sso.*,com.sun.identity.liberty.ws.security.*, com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken, com.iplanet.am.util.*, org.w3c.dom.*" %>
<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<head><title>IDPP Query</title></head>
<body bgcolor="white">
    <h1>IDPP Query</h1>
<%
    if (request.getMethod().equals("GET")) {
        // First check if there is a need for interaction.
        String resend = request.getParameter(
                        InteractionManager.RESEND_MESSAGE);
        if (resend != null) {
            // resend requet after interaction happened
            try {
                // resend message
                Message ret = InteractionManager.getInstance().resendRequest(
                    request.getRequestURL().toString(), request, response);
                %>
                    <pre><%= SAMLUtils.displayXML(ret.toString()) %></pre>
                    <p><a href="index.jsp">Return to index.jsp</a></p>
                <%
            } catch (Throwable t) {
                t.printStackTrace();
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                %>
                    ERROR: caught exception:
                    <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                <%
            }
        } else {
            String soapEndPoint = "";
            List mechs = null; 
            String providerID = request.getParameter("providerID");
	    String fnSuffix = providerID.replace('/', '_');
	    String securityAssertion = 
                   request.getParameter("securityAssertion");
	    String resOffFN = request.getParameter("resOffFN");
            try {
                ResourceOffering ro = null;
		BufferedInputStream bir =
                    new BufferedInputStream(new FileInputStream(resOffFN));
		org.w3c.dom.Document doc =
                    com.iplanet.am.util.XMLUtils.toDOMDocument(bir, null);
		org.w3c.dom.Element elem = doc.getDocumentElement();
		ro = new ResourceOffering(elem);
		ServiceInstance si = ro.getServiceInstance();
		Description desc = (Description)si.getDescription().get(0);
		mechs = desc.getSecurityMechID();
 
	    } catch(Exception ex) {
		  %>ERROR: Unable to parse resource offering<%
		  ex.printStackTrace();
            }

            %>
            <form method="POST">
		<input type='hidden' name='resOffFN' value=<%=resOffFN %>
            <table>
                <tr>
                    <td>Authentication Mechanism</td>
                    <td>
            <%
            int len = mechs.size(); 
            for (int i = 0; i < len; i++) {
                %>
                <input type='radio' name="authMech"
                    value='<%= mechs.get(i) %>'/> <%= mechs.get(i) %><br>
                <% 
            } 
            %>
                    </td>
                </tr>
                <tr>
                    <td>XPath Expression</td>
                    <td><input type="text" name="queryStr" 
                        value="/PP/CommonName/AnalyzedName/FN"/></td>
                </tr>
            </table>
            <input type="hidden" name="providerID" value="<%= providerID %>" />
	    <input type='hidden' name='securityAssertion' 
                   value='<%= securityAssertion %>'/>
            <input type="submit" value="send PPQueryRequest" />
            </form>
            <%
        }
    } else {
        String queryString = request.getParameter("queryStr");
        String providerID = request.getParameter("providerID");
	String resOffFN = request.getParameter("resOffFN");
        String secAss = request.getParameter("secAssertion");
        String authMech = request.getParameter("authMech");
        if(resOffFN == null || resOffFN.equals("")) {
           %>ERROR: resource offering missing<%
        } else {  
          try {
            ResourceOffering ro = null;
	    BufferedInputStream bir = 
                 new BufferedInputStream(new FileInputStream(resOffFN));
	    org.w3c.dom.Document doc = 
                 com.iplanet.am.util.XMLUtils.toDOMDocument(bir, null);
	    org.w3c.dom.Element elem = doc.getDocumentElement();
	    ro = new ResourceOffering(elem);

            SecurityAssertion secAssertion = null;
            if(secAss != null && !secAss.equals("") && !secAss.equals("null")) {
	       BufferedInputStream secIn =
                   new BufferedInputStream(new FileInputStream(secAss));
	       org.w3c.dom.Element elem2 =
                   com.iplanet.am.util.XMLUtils.toDOMDocument(
                   secIn, null).getDocumentElement();
	       secAssertion = new SecurityAssertion(elem2);
            }
            SSOToken ssoToken = 
                 SSOTokenManager.getInstance().createSSOToken(request);
           
	    DSTClient client =
	        new DSTClient(ro, providerID, ssoToken, request, response);
            if(secAssertion != null) {
               client.setSecurityAssertion(secAssertion);
            }
        
            if(authMech != null && !authMech.equals("null")) {
               client.setSecurityMech(authMech);
            }

            if ((queryString == null) 
                 || (queryString.equals("")) || (queryString.equals("null"))) {
                %>ERROR: Query String can not be null<%
                 return;
            }

            List items = new ArrayList();
            DSTQueryItem item = new DSTQueryItem(queryString, 
                         DSTConstants.IDPP_SERVICE_TYPE);
            item.setItemID("query-item-#1");
            items.add(item);
            List data = null;
                    
            ServiceInstanceUpdateHeader siuHeader =  null;
            try {
                data = client.getData(items);
            } catch (DSTException de) {
                siuHeader = client.getServiceInstanceUpdateHeader(); 
            }
            siuHeader  =  client.getServiceInstanceUpdateHeader();
            if(siuHeader != null) {
               String newEndpoint = siuHeader.getEndpoint();
               client.setSOAPEndPoint(newEndpoint);
               List secs = siuHeader.getSecurityMechIDs();
               String newSec = null;
               if(secs != null && secs.size() != 0) {
                  newSec = (String)secs.get(0);
               }

               if(newSec != null && 
                  newSec.equals("urn:liberty:security:2003-08:TLS:X509")) {
                  SecurityTokenManager securityTokenManager = 
                        new SecurityTokenManager(ssoToken);
                  BinarySecurityToken authToken = 
                        securityTokenManager.getX509CertificateToken(); 

                  DSTClient newClient1 = new DSTClient(authToken,
                   newEndpoint, providerID, request, response);
                  newClient1.setResourceID(ro.getResourceID().getResourceID());
                  data = newClient1.getData(items);
               } else {
                  DSTClient newClient2 = 
                   new DSTClient(newEndpoint, providerID, request, response);
                  newClient2.setResourceID(ro.getResourceID().getResourceID());
                  data = client.getData(items);
               }
            }

            if(data == null || data.size() == 0) {
                       %> No data found. <%
                  
            } else {
                   Iterator iter = data.iterator();
                   while (iter.hasNext()) {
                        DSTData dstData = (DSTData)iter.next();
                        %>
                            <h2>Got result:</h2>
                            <pre><%= SAMLUtils.displayXML(dstData.toString()) %>
                            </pre>
                        <%
                    }
            }
      } catch (Throwable t) {
                t.printStackTrace();
                StringWriter buf = new StringWriter();
                t.printStackTrace(new PrintWriter(buf));
                %>
                    ERROR: caught exception:
                    <pre><%= SAMLUtils.displayXML(buf.toString()) %></pre>
                <%
      }
     }
%>
        <p><a href="index.jsp">Return to index.jsp</a></p>
<%
    } 
%>
    <hr/>
    </body>
</html>
