/**
 * $Id: PAOSClientServlet.java,v 1.4 2005/06/24 16:53:41 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import java.util.*;
import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.sun.identity.liberty.ws.paos.*;

import com.sun.identity.liberty.ws.idpp.jaxb.*;

public class PAOSClientServlet extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException {
      
      PAOSHeader paosHeader = null;
      try {
	paosHeader = new PAOSHeader(req);
      } catch (PAOSException pe1) {
	pe1.printStackTrace();
	
	String msg = "No PAOS header\n";
	res.setContentType("text/plain");
	res.setContentLength(1+msg.length());
	PrintWriter out = new PrintWriter(res.getOutputStream());
	out.println(msg);
	out.close();
	
	throw new ServletException(pe1.getMessage());
      }

      HashMap servicesAndOptions = paosHeader.getServicesAndOptions();

      Set services = servicesAndOptions.keySet();

      String thisURL = req.getRequestURL().toString();
      String[] queryItems = { "/IDPP/Demographics/Birthday" };
      PAOSRequest paosReq = null;
      try {
	paosReq = new PAOSRequest(thisURL,
				  (String)(services.iterator().next()),
				  thisURL,
				  queryItems);
      } catch (PAOSException pe2) {
	pe2.printStackTrace();
	throw new ServletException(pe2.getMessage());
      }
      System.out.println("PAOS request to User Agent side --------------->");
      System.out.println(paosReq.toString());
      paosReq.send(res, true);
  }
  
  public void doPost(HttpServletRequest req, HttpServletResponse res)
    throws ServletException, IOException {
      
      PAOSResponse paosRes = null;
      try {
	paosRes = new PAOSResponse(req);
      } catch (PAOSException pe) {
	pe.printStackTrace();
	throw new ServletException(pe.getMessage());
      }	

      System.out.println("PAOS response from User Agent side -------------->");
      System.out.println(paosRes.toString());

      System.out.println("Data output after parsing -------------->");

      String dataStr = null;
      try {
	dataStr = paosRes.getPPResponseStr();
      } catch (PAOSException paose) {
	paose.printStackTrace();
	throw new ServletException(paose.getMessage());
      }
      System.out.println(dataStr);

      String msg = "Got the data: \n" + dataStr;

      res.setContentType("text/plain");
      res.setContentLength(1+msg.length());

      PrintWriter out = new PrintWriter(res.getOutputStream());
      
      out.println(msg);

      out.close();
  }      
}      
	

