/**
 * $Id: PlainClient.java,v 1.2 2005/06/24 16:53:40 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */


import com.sun.identity.liberty.ws.authnsvc.*;
import com.sun.identity.liberty.ws.disco.*;
import com.sun.identity.liberty.ws.security.*;
import com.sun.identity.liberty.ws.authnsvc.protocol.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * This class <code>PlainClient</code> is a sample client for the 
 * liberty authentication  service. This sample uses a plain authentication
 * mechanism.
 */
public class PlainClient {

    public static void main( String[] args) {

        if(args.length < 3) {
           System.out.println("Usage: java PlainClient <url> <uid> <password>");
        }

        String url = args[0];
        String userID = args[1];
        String password = args[2]; 

	try {
            // create a sasl request
	    SASLRequest saslReq =
                        new SASLRequest(AuthnSvcConstants.MECHANISM_PLAIN);
            saslReq.setAuthzID(userID);
            saslReq.setAdvisoryAuthnID(password);

            System.out.println("Sending first sasl request");
            SASLResponse saslResp = AuthnSvcClient.sendRequest(saslReq, url);
            String statusCode = saslResp.getStatusCode();
            System.out.println("Response code = " + statusCode);
            if (!statusCode.equals(SASLResponse.CONTINUE)) {
		System.exit(0);
            }

            String serverMechanism = saslResp.getServerMechanism();
            System.out.println("Response serverMechanism = "+ serverMechanism);

            // Here, the data string depends on sasl response, but assume
            //  a plain authentication mechanism for this sample.

            saslReq  = new SASLRequest(serverMechanism);
            String dataStr = userID + "\0" + userID + "\0" + password;
            saslReq.setData(dataStr.getBytes("UTF-8"));
            saslReq.setRefToMessageID(saslResp.getMessageID());

            System.out.println("Sending second request");
            saslResp = AuthnSvcClient.sendRequest(saslReq, url);
            statusCode = saslResp.getStatusCode();
            System.out.println("Response code = " + statusCode);

            // Get the discovery resource offering from the sasl response.
            ResourceOffering ro = saslResp.getResourceOffering();
            System.out.println("ResourceOffering = " + ro);

            //Look for the credentials from the sasl response.
            List list = saslResp.getCredentials();
            SecurityAssertion assertion = null;

            if (list != null && !list.isEmpty()) {

		Element assertionE = (Element)list.get(0);
		assertion = new SecurityAssertion(assertionE);
		System.out.println("\n\nAssertion = " +
                                   assertion.toString(true,true));
		System.out.println("Assertion is bearer " +
                                   assertion.isBearer());
            }

            ResourceID roID = ro.getResourceID();
            RequestedService rs =
                    new RequestedService(null, "urn:liberty:id-sis-pp:2003-08");

            List rss = new ArrayList();
            rss.add(rs);
            Query query = new Query(roID, rss);

            String soapURI =
		((Description)ro.getServiceInstance().getDescription().get(0))
				.getEndpoint();

            DiscoveryClient discoClient = null;
            if(assertion != null) {
               discoClient = new DiscoveryClient(assertion, soapURI, null);
            } else {
               discoClient = new DiscoveryClient(soapURI, null);
            }

            System.out.println("Sending Query " + query);
            QueryResponse qResp = discoClient.getResourceOffering(query);

            System.out.println("\n\nQueryResponse = " + qResp);


	} catch (Throwable ex) {
            ex.printStackTrace();
	}
        System.exit(0);
    }

}

