/**
 * $Id: LogSampleUtils.java,v 1.2 2005/06/24 16:53:37 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */



import java.io.*;
import java.util.*;
import java.lang.Integer;

import com.iplanet.sso.SSOTokenManager;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;

import com.sun.identity.log.LogConstants;
import com.sun.identity.log.Logger;
import com.sun.identity.log.LogRecord;

import java.util.logging.LogManager;
import com.sun.identity.log.LogManagerUtil;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.share.AuthXMLTags;
import com.sun.identity.authentication.util.ISAuthConstants;
import javax.security.auth.callback.*;
import java.security.Principal;


/**
 * This class 
 *
 *
 * @author 
 */
public class LogSampleUtils {

    static AuthContext lc = null;
    static String userID = null;

    public static SSOToken ldapLogin (
	    String userid, String password, String orgDN)
	throws SSOException, AuthLoginException, Exception
    {
	SSOTokenManager mgr;
	String adminDN;
	String adminPassword;
	SSOToken ssoToken = null;
	AuthContext.IndexType authType = AuthContext.IndexType.MODULE_INSTANCE;
	String authName = "LDAP";

	try {
	    lc = new AuthContext(orgDN);
	} catch (AuthLoginException le) {
	    System.err.println(
		"LogSampleUtils: could not get AuthContext for orgDN " +
		orgDN);
	    throw le;
	}

	try {
	    lc.login(authType, authName);
	} catch (AuthLoginException le) {
	    System.err.println("LogSampleUtils: Failed to start login " +
		"for authName = " + authName);
	    throw le;
	}

	userID = userid;
	Callback[]  callbacks = null;
	Hashtable values = new Hashtable();
	values.put(AuthXMLTags.NAME_CALLBACK, userid);
	values.put(AuthXMLTags.PASSWORD_CALLBACK, password);

	while (lc.hasMoreRequirements()) {
	    callbacks = lc.getRequirements();
	    try {
		fillCallbacks(callbacks, values);
		lc.submitRequirements(callbacks);
	    } catch (Exception e) {
		System.err.println( "Failed to submit callbacks!"); 
		e.printStackTrace();
		return null;
	    }
	}

	AuthContext.Status istat = lc.getStatus();
	if (istat == AuthContext.Status.SUCCESS) {
	    System.out.println("==>Authentication SUCCESSFUL for user " +
		userid);
	} else if (istat == AuthContext.Status.COMPLETED) {
	    System.out.println("==>Authentication Status for user " +
		userid+ " = " + istat);
	    return null;
	}

	try {
	    ssoToken = lc.getSSOToken();
	} catch (Exception e) {
	    System.err.println( "Failed to get SSO token!"); 
	    throw e;
	}

	return ssoToken;
    }

    public static void logout () throws AuthLoginException {
	try {
	    lc.logout();
	} catch (AuthLoginException alexc) {
	    System.err.println ("LogSampleUtils: logout failed for user '" +
		userID + "'");
	    throw alexc;
	}
    }

    
    protected static void fillCallbacks(Callback[] callbacks, Hashtable values) 
	throws Exception
    {
	for (int i = 0; i < callbacks.length; i++) {
	    if (callbacks[i] instanceof NameCallback) {
		NameCallback nc = (NameCallback) callbacks[i];
		nc.setName((String)values.get(AuthXMLTags.NAME_CALLBACK));
	    } else if (callbacks[i] instanceof PasswordCallback) {
		PasswordCallback pc = (PasswordCallback) callbacks[i];
		pc.setPassword(((String)values.get(
		    AuthXMLTags.PASSWORD_CALLBACK)).toCharArray());
	    } else if (callbacks[i] instanceof TextInputCallback) {
		TextInputCallback tic = (TextInputCallback) callbacks[i];
		tic.setText((String)values.get(
		    AuthXMLTags.TEXT_INPUT_CALLBACK));
	    } else if (callbacks[i] instanceof ChoiceCallback) {
		ChoiceCallback cc = (ChoiceCallback) callbacks[i];
		cc.setSelectedIndex(Integer.parseInt((String)values.get(
		    AuthXMLTags.CHOICE_CALLBACK)));
            }
	}
    }

    public static String getLine() {
	StringBuffer buf = new StringBuffer(80);
	int c;

	try {
	    while ((c = System.in.read()) != -1) {
		char ch = (char)c;
		if (ch == '\n') {
		    break;
		}
		buf.append(ch);
	    }
	} catch (IOException e) {
	    System.err.println ("getLine: " + e.getMessage());
	}
	return (buf.toString());
    }

    public static String getLine (String prompt) {
	System.out.print (prompt);
	return (getLine());
    }

    public static void waitForReturn() {
	System.out.print ("Hit <return> when ready: ");
	String answer = getLine();
    }
}


