/**
 * $Id: LogReaderSample.java,v 1.2 2005/06/24 16:53:37 vs125812 Exp $
 * Copyright  2005 Sun Microsystems, Inc.  All rights reserved.
 *
 * Sun Microsystems, Inc. has intellectual property rights relating to
 * technology embodied in the product that is described in this document.
 * In particular, and without limitation, these intellectual property rights
 * may include one or more of the U.S. patents listed at
 * http://www.sun.com/patents and one or more additional patents or pending
 * patent applications in the U.S. and in other countries.
 *
 * U.S. Government Rights - Commercial software.  Government users are subject
 * to the Sun Microsystems, Inc. standard license agreement and applicable
 * provisions of the FAR and its supplements.
 *
 * Use is subject to license terms.
 *
 * This distribution may include materials developed by third parties.Sun,
 * Sun Microsystems and  the Sun logo are trademarks or registered trademarks
 * of Sun Microsystems, Inc. in the U.S. and other countries.  
 *
 * Copyright  2005 Sun Microsystems, Inc. Tous droits rservs.
 * Sun Microsystems, Inc. dtient les droits de proprit intellectuels relatifs
 *  la technologie incorpore dans le produit qui est dcrit dans ce document.
 * En particulier, et ce sans limitation, ces droits de proprit
 * intellectuelle peuvent inclure un ou plus des brevets amricains lists
 *  l'adresse http://www.sun.com/patents et un ou les brevets supplmentaires
 * ou les applications de brevet en attente aux Etats - Unis et dans les
 * autres pays.
 *
 * L'utilisation est soumise aux termes du contrat de licence.
 *
 * Cette distribution peut comprendre des composants dvelopps par des
 * tierces parties.
 *
 * Sun,  Sun Microsystems et  le logo Sun sont des marques de fabrique ou des
 * marques dposes de Sun Microsystems, Inc. aux Etats-Unis et dans
 * d'autres pays.
 */



import java.io.*;
import java.util.*;
import java.lang.reflect.Array;
import java.lang.Integer;

import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.util.ISAuthConstants;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOException;

import com.sun.identity.log.LogConstants;
import com.sun.identity.log.Logger;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.QueryElement;

import java.util.logging.LogManager;
import com.sun.identity.log.LogManagerUtil;


/**
 * This class 
 *
 *
 * @author 
 */
public class LogReaderSample {

    private static String USAGE =
	"Usage: LogReaderSample -u <userid> -p <passwd> -o <orgDN> " +
	"[-n <logName>]";

    static final int INVALID  = 0;
    static final int USER_ID  = 1;
    static final int PASSWD   = 2;
    static final int ORG_DN   = 3;
    static final int LOG_NAME = 4;

    static Map OPTIONS = new HashMap();

    static {
	OPTIONS.put("-u", new Integer (USER_ID));
	OPTIONS.put("-p", new Integer (PASSWD));
	OPTIONS.put("-o", new Integer (ORG_DN));
	OPTIONS.put("-n", new Integer (LOG_NAME));
    }

    static final String fldRetrieve = "Fields/Columns available to retrieve:";
    static final String fldSort = "Fields/Columns available to sort on:";

    static final int SINGLE_FILE_CANNED = 0;
    static final int SINGLE_NAMED_FILE  = 1;
    static final int MULTI_FILE		= 2;

    static Set allFields = null;
    static Set displayFields = null;
    static ArrayList requestFields = null;

    static java.util.logging.LogManager manager =
    	LogManagerUtil.getLogManager();

    private static int getToken(String arg) {
	try {
	    return(((Integer)OPTIONS.get(arg)).intValue());
	} catch (Exception e) {
	    return 0;
	}
    }

    private static void showUsage() {
	System.err.println(USAGE);
	System.exit(1);
    }

    private static QueryElement getQueryElement() {
	String fName = null;
	String fVal = null;
	String fRelStr = null;
	int fRel = QueryElement.GT - 1;
	QueryElement qe;

	System.out.print ("Enter QueryElement FieldName: ");
	fName = LogSampleUtils.getLine();
	System.out.print ("Enter QueryElement FieldValue: ");
	fVal = LogSampleUtils.getLine();
	System.out.print ("Enter QueryElement Relation:\n" +
	    "\t1: >\t2: <\t3: =\t\t4: !=\t5: >=\t6: <=\n" +
	    "\t7: contains\t8: starts with\t9: ends with\n" +
	    "\t    Relation [1..9]:  ");
	fRelStr = LogSampleUtils.getLine();
	try {
	    fRel = Integer.parseInt (fRelStr);
	} catch (NumberFormatException e) {
	    System.err.println ("'" + fRelStr +
		"' doesn't appear to be an integer.");
	    System.exit(2);
	}
	if ((fRel < QueryElement.GT) || (fRel > QueryElement.EW)) {
	    System.err.println ("'" + fRel +
		"' is not a valid query relation value.");
	    System.exit(3);
	}

	qe = new QueryElement(fName, fVal, fRel);
	return (qe);
    }


    private static void printResults(String [][] results) {

	System.out.println("size of results = " +
	    Array.getLength(results));
	int numRecords = Array.getLength(results);
	//
	//  first record contains column names
	//
	System.out.println ("Row 0 (Column names) =");
	int ii = Array.getLength(results[0]);
	String tempS;
	for (int i = 0; i < ii; i ++) {
	    tempS = results[0][i];
	    System.out.print ("  " + tempS + "\t");
	}

	for (int i = 1; i < numRecords; i++) {
	    System.out.println("\nsize of row " + i + " = " + ii +
		"\nrecord " + i + " =");
	    for (int j = 0; j < ii; j++) {
		System.out.println ("  " + results[0][j] +
		    ":\t" + results[i][j]);
	    }
	    System.out.println("");
	}
	return;
    }

    private static LogQuery getLogQuery () {
	String tmpStr;
	String sortBy = null;
	int maxrecs = 0;
	int matchcondx = 0;

	System.out.print("Enter Maximum Records:\n\t" +
	    "a: ALL Records\tb: Most Recent Max Records\n\t" +
	    "<#>: max number of records\n\t" +
	    "    Max Records [a, b, <#>]: ");
	tmpStr = LogSampleUtils.getLine();
	if (tmpStr.equals("a")) {
	    maxrecs = LogQuery.ALL_RECORDS;
	} else if (tmpStr.equals("b")) {
	    maxrecs = LogQuery.MOST_RECENT_MAX_RECORDS;
	} else {
	    try {
		maxrecs = Integer.parseInt (tmpStr);
	    } catch (NumberFormatException e) {
		System.err.println ("'" + tmpStr +
		    "' doesn't appear to be an integer.");
		System.exit(2);
	    }
	}

	System.out.print("Enter Match Conditions:\n\t" +
	    "a: ALL Conditions\tb: ANY Conditions\n\t" +
	    "    Match Conditions [a, b]: ");
	tmpStr = LogSampleUtils.getLine();
	if (tmpStr.equals("a")) {
	    matchcondx = LogQuery.MATCH_ALL_CONDITIONS;
	} else if (tmpStr.equals("b")) {
	    matchcondx = LogQuery.MATCH_ANY_CONDITION;
	} else {
	    System.err.println ("Invalid selection (" +
		tmpStr + ") for Match Conditions.");
	    System.exit(3);
	}

	System.out.print("Enter Field to Sort By:\n\t" +
	    "a: <NONE>\t<Field>\n\t" +
	    "    Sort Field [a, <Field>]: ");
	tmpStr = LogSampleUtils.getLine();
	if (tmpStr.equals("a")) {
	    sortBy = null;
	} else {
	    sortBy = tmpStr;
	}

	ArrayList sS = getColumns(fldRetrieve, true);
	LogQuery lq = new LogQuery(maxrecs, matchcondx, sortBy);

	if (sS.size() > 1) {
	    lq.setColumns(sS);
	}

	QueryElement qe;
	while (true) {
	    System.out.print("Query to specify? [y/n]: ");
	    tmpStr = LogSampleUtils.getLine();
	    if (tmpStr.equalsIgnoreCase("n")) {
		break;
	    }
	    qe = getQueryElement();
	    lq.addQuery(qe);
	}

	return lq;
    }


    private static ArrayList getColumns(String prompt, boolean allToo) {
	//
	//  requestFields is the Set containing the fields/columns
	//  selected in the Logging service template.
	//

	System.out.println(prompt);
	int rlen = requestFields.size();

	String [] rFields = new String[rlen];
	int jj = 0;
	for (Iterator it = requestFields.iterator(); it.hasNext(); jj++) {
	    rFields[jj] = (String)it.next();
	}
	
	for (int i = 0; i < rlen; i++) {
	    if (rFields[i].length() < 5) {
		if (allToo) {
		    System.out.print(i + ": " + rFields[i] + " ");
		} else {
		    System.out.print(rFields[i] + " ");
		}
	    } else {
		if (allToo) {
		    System.out.print(i + ": " + rFields[i]);
		} else {
		    System.out.print(rFields[i]);
		}
	    }
	    if ((i+1) < rlen) {
		if (((i+1) % 3) == 0) {
		    System.out.println("");
		} else {
		    System.out.print("\t");
		}
	    }
	}

	ArrayList fldS = new ArrayList();
	if (allToo) {
	    System.out.println("\n" + rlen + ": * (all)");

	    System.out.print("Enter fields to retrieve (space-separated): ");
	    String tmpStr = LogSampleUtils.getLine();
	    String tj = Integer.toString(rlen);
	    boolean getAllFields = true;

	    //
	    //  "*" (all) is specified with a null columns value,
	    //  also affected by not calling setColumns();
	    //
	    if (!tmpStr.equals(tj)) {
		getAllFields = false;
		StringTokenizer stok = new StringTokenizer(tmpStr);
		while (stok.hasMoreTokens()) {
		    String sel = stok.nextToken();
		    try {
			int ians = Integer.parseInt(sel);
			fldS.add(rFields[ians]);
		    } catch (NumberFormatException e) {
			System.err.println(sel + " doesn't look like an int");
	    		System.exit(7);
		    }
		}
	    }
	} else {
	    System.out.println("");
	}
	return fldS;
    }


    private static void getColumns(String prompt) {
	//
	//  requestFields is the Set containing the fields/columns
	//  selected in the Logging service template.
	//

	System.out.println(prompt);
	int rlen = requestFields.size();

	String [] rFields = new String[rlen];
	int jj = 0;
	for (Iterator it = requestFields.iterator(); it.hasNext(); jj++) {
	    rFields[jj] = (String)it.next();
	}
	
	for (int i = 0; i < rlen; i++) {
	    if (rFields[i].length() < 8) {
		System.out.print(rFields[i] + "\t");
	    } else {
		System.out.print(rFields[i]);
	    }
	    if ((i+1) < rlen) {
		if (((i+1) % 5) == 0) {
		    System.out.println("");
		} else {
		    System.out.print("\t");
		}
	    }
	}
	System.out.println("");
    }

    //
    //  sFields is a String array of fields ("time", "data", ...
    //  ..., "all") to pick from.  returns a Set of the selections.
    //

    static Set getDisplayFields(String[] sFields) {
	Set dFields = new HashSet();

	int count = Array.getLength(sFields);
	System.out.println("\nFields to display:");
	for (int i = 0; i < count; i++) {
	    System.out.print(i + ": " + sFields[i] + "\t");
	    if ((i+1)%3 == 0) {
		System.out.println();
	    }
	}

	System.out.print ("\n\tEnter selections (space-separated): ");
	String answer = LogSampleUtils.getLine();
	StringTokenizer tanswer = new StringTokenizer(answer);
	int ians;
	String ansS;

	if (tanswer.countTokens() == 1) {
	    ansS = (String)tanswer.nextElement();
	    try {
		ians = Integer.parseInt(ansS);
		if (sFields[ians].equals("all")) {
		    dFields = allFields;
		} else {
		    dFields.add(sFields[ians]);
		}
	    } catch (NumberFormatException e) {
		System.err.println("'" + ansS +
		    "' doesn't look like an integer.");
		System.exit(5);
	    }
	} else {
	    while (tanswer.hasMoreElements()) {
		ansS = (String)tanswer.nextToken();
		try {
		    ians = Integer.parseInt(ansS);
		    dFields.add(sFields[ians]);
		} catch (NumberFormatException e) {
		    System.err.println("'" + ansS +
			"' doesn't look like an integer.");
		    System.exit(5);
		}
	    }
	}

	return (dFields);
    }

    public static void main(String[] args) {

	int userID = 0;
	int userPWD = 0;
	int orgDN = 0;
	int logName = 0;
	int i = 0;
	while (i < args.length) {
            int opt = getToken(args[i]);

            switch(opt) {
		case USER_ID:
		    i++;
		    userID = i;
		    break;
		case PASSWD:
		    i++;
		    userPWD = i;
		    break;
		case ORG_DN:
		    i++;
		    orgDN = i;
		    break;
                case LOG_NAME:
                    i++;
                    logName = i;
                    break;
                default:
                    showUsage();
            }
            i++;
        }

	if (userID == 0) {
	    System.err.println ("LogReaderSample: userID is null.");
	    showUsage();
	}
	if (userPWD == 0) {
	    System.err.println("LogReaderSample: userPASSWORD is null");
	    showUsage();
	}
	if (orgDN == 0 ) {
	    System.err.println("LogReaderSample: orgDN is null");
	    showUsage();
	}

	//
	//  login and get the SSOToken
	//

        SSOToken ssoToken = null;

	try {
	    ssoToken = LogSampleUtils.ldapLogin(args[userID],
		args[userPWD], args[orgDN]);
	} catch (SSOException ssoe) {
	    System.err.println ("LogReaderSample: could not get SSOToken: " +
	    ssoe.getMessage());
	    System.exit(3);
	} catch (AuthLoginException ale) {
	    System.err.println ("LogReaderSample: could not authenticate: " +
	    ale.getMessage());
	    System.exit(4);
	} catch (Exception e) {
	    System.err.println (
		"LogReaderSample: exception getting SSOToken: " +
		e.getMessage());
	    System.exit(5);
	}
	

	try {
	    manager.readConfiguration();
	} catch (IOException iox) {
	    System.err.println ("IOEx while reading LogManager config" +
		iox.getMessage());
	}

	String logStorageType = manager.getProperty(LogConstants.BACKEND);
	if ((logStorageType == null) || logStorageType.equals("")) {
	    System.out.println (LogConstants.BACKEND +
		" is null.");
	} else {
	    System.out.println (LogConstants.BACKEND +
		" is = '" + logStorageType + "'");
	}

	String fileOrTable = "file";
	String sizeUnit = "bytes";
	int i3 = LogConstants.NUM_BYTES;
	try {
	    i3 = LogReader.getSizeUnits();
	} catch (Exception ex) {
	    System.out.println("Error in getSizeUnits(): " + ex.getMessage());
	}

	if (i3 == LogConstants.NUM_RECORDS) {
	    fileOrTable = "table";
	    sizeUnit = "rows";
	}

	String selFldsStr = manager.getProperty(LogConstants.LOG_FIELDS);

	//
	//  selFldsStr will be a comma and space separated string
	//
	//  "time" and "data" need to be added; those are "required"
	//  and not in the list.  also add "all" to the end.
	//

	StringTokenizer stoken = new StringTokenizer(selFldsStr, ", ");
	String [] sFields = new String[stoken.countTokens() + 3];
	Set allFields = new HashSet();

	allFields.add("time");
	allFields.add("data");

	sFields[0] = "time";
	sFields[1] = "data";
	int count = 2;

	String temp = "";
	while (stoken.hasMoreElements()) {
	    temp = stoken.nextToken();
	    sFields[count++] = (temp.toLowerCase());
	    allFields.add(temp.toLowerCase());
	}
	sFields[count] = "all";

	Set filesThereAre = LogReader.getLogNames();
	//
	//  find out the longest named filename for later
	//  display reasons.
	//
	int longestFileName = 0;
	for (Iterator it=filesThereAre.iterator(); it.hasNext(); ) {
	    String xxx = (String)it.next();
	    if (xxx.length() > longestFileName) {
		longestFileName = xxx.length();
	    }
	}
	//
	//  make longestFileName to nearest multiple of 8 (tab length)
	//
	int pseudoLongFile = longestFileName;
	int tmpi = pseudoLongFile/8;
	pseudoLongFile = (tmpi+1)*8;


	if (filesThereAre.size() > 0) {
	    System.out.println("Available " + fileOrTable + "s:");
	    int i2 = 0;
	    for (Iterator it=filesThereAre.iterator(); it.hasNext(); ) {
		String fileName = (String)it.next();
		long li = 0;
		try {
		    li = LogReader.getSize(fileName);
		} catch (Exception ex) {
		    System.out.println("got exception on file " +
			fileName + ". " + ex.getMessage());
		}

		System.out.println (fileOrTable + " " + (i2++) +
		    " = " + fileName + " contains " + li + " " +
		    sizeUnit + ".");
	    }
	}
	System.out.println();

	String [] filesArray = new String[filesThereAre.size()];
	i = 0;
	for(Iterator it = filesThereAre.iterator(); it.hasNext(); ) {
	    filesArray[i++] = (String)it.next();
	}

	requestFields = LogReader.getLogFields();

	//
	//  see what type of read to use
	//

	//
	//  readType
	//    SINGLE_FILE_CANNED = 0:  single table canned
	//    SINGLE_NAMED_FILE  = 1:  "-n tablename" format
	//    MULTI_FILE         = 2:  multiple table
	//

	int readType = SINGLE_FILE_CANNED;

	if (logName == 0) {
	    System.out.print (
		"Single (s) or multiple (m) file/table read: [s] ");
	    String answer = LogSampleUtils.getLine();
	    if ((answer != null) && (answer.length() > 0)) {
		if (answer.startsWith("m")) {
		    readType = MULTI_FILE;
		}
	    }
	} else {
	    readType = SINGLE_NAMED_FILE;
	}

	switch (readType) {
	    case SINGLE_FILE_CANNED:	// single table canned report
	    	System.out.print ("What type of audit report to generate:\n" +
		    "  1. all records from file/table\n" +
		    "  2. authentication successes\n" +
		    "  3. authentication failures\n" +
		    "  4. login/logout activity\n" +
		    "  5. policy allows\n" +
		    "  6. policy denies\n" +
		    "  7. amAdmin CLI activity\n" +
		    "  8. amAdmin console activity\n" +
		    "  9. Federation access\n" +
		    " 10. Federation errors\n" +
		    " 11. Liberty access\n" +
		    " 12. Liberty errors\n" +
		    " 13. SAML access\n" +
		    " 14. SAML error\n" +
		    "     enter type [1..14]:  ");
		break;
	    case SINGLE_NAMED_FILE:	// "-n tablename" format
		System.out.print ("What type of read to use on " +
		    args[logName] + ":\n" +
		    "  1. read all records\n" +
		    "  2. specify logType\n" +
		    "  3. specify logType and timeStamp\n" +
		    "  4. specify logType and logQuery\n" +
		    "  5. specify logType, timeStamp, and logQuery\n" +
		    "  6. specify logQuery\n" +
		    "     enter type [1..6]:  ");
		break;
	    case MULTI_FILE:	// multi-table
		//
		//  print out available files/tables
		//
		int numFiles = Array.getLength(filesArray);

		int filesPerRow = 80/pseudoLongFile;
		System.out.println("\nAvailable " + fileOrTable + "s:");
		int j = 1;
		for (i = 0; i < numFiles; i++) {
		    int lengthDiff = pseudoLongFile - filesArray[i].length();
		    String padding = "";
		    if (lengthDiff > 0) {
			int numTab = lengthDiff/8;
			int numSpace = lengthDiff % 8;
			for (int ii = 0; ii < numSpace; ii++) {
			    padding += " ";
			}
			for (int ii = 0; ii < numTab; ii++) {
			    padding += "\t";
			}
		    }
		    System.out.print(i + ": " + filesArray[i]);
		    if (j % filesPerRow == 0) {
			System.out.println("");
		    } else {
			System.out.print(padding + "\t");
		    }
		    j++;
		}
		System.out.print("\n\tEnter selections (space-separated): ");
		break;
	}
	
	String answer = LogSampleUtils.getLine();

	int ians = 0;
	StringTokenizer stk = null;
	Set fileHashSet = new HashSet();

	if (readType != MULTI_FILE) {
	    try {
		ians = Integer.parseInt (answer);
	    } catch (NumberFormatException e) {
		System.err.println ("'" + answer +
		    "' doesn't appear to be an integer.");
		System.exit(2);
	    }
	} else {
	    stk = new StringTokenizer(answer);
	    while (stk.hasMoreTokens()) {
		String ansS = (String)stk.nextToken();
		try {
		    ians = Integer.parseInt(ansS);
		    fileHashSet.add(filesArray[ians]);
		} catch (NumberFormatException e) {
		    System.err.println("'" + ansS +
			"' doesn't look like an integer.");
		    System.exit(5);
		}
	    }
	    System.out.print ("What type of read to use:\n" +
		"  1. read all records\n" +
		"  2. specify logQuery\n" +
		"     enter type [1 or 2]:  ");
	    answer = LogSampleUtils.getLine();
	    try {
		ians = Integer.parseInt (answer);
	    } catch (NumberFormatException e) {
		System.err.println ("'" + answer +
		    "' doesn't appear to be an integer.");
		System.exit(2);
	    }
	}

	//
	//  get the fields to display out of those (all) returned
	//

	switch (readType) {
	    case SINGLE_FILE_CANNED:
		doCannedAudit(ians, ssoToken);
	    break;

	    case SINGLE_NAMED_FILE:
		doQuery(ians, args[logName], ssoToken);
	    break;

	    case MULTI_FILE:
		doMultiTable(ians, fileHashSet, ssoToken);
	    break;

	    default:
		System.err.println ("xxx");
	}

	//
	//  all done, now logout
	//

	try {
	    LogSampleUtils.logout();
	} catch (AuthLoginException alexc) {
	    System.err.println ("LogReaderSample: logout failed for user '" +
		args[userID] + "'");
	    alexc.printStackTrace();
	    System.exit(10);
	}


    }

    static void getEntireTable (String tblName, SSOToken ssoToken) {
	String[][] result = new String[1][1];
	int numRecords;

	try {
	    result = LogReader.read(tblName, ssoToken);
	} catch (IOException ioex) {
	    System.err.println ("IOException: " + ioex.getMessage());
	} catch (NoSuchFieldException nsfex) {
	    System.err.println ("NoSuchFieldException: " +
		nsfex.getMessage());
	} catch (IllegalArgumentException iaex) {
	    System.err.println ("IllegalArgumentException: " +
		iaex.getMessage());
	} catch (RuntimeException rtex) {
	    System.err.println ("RuntimeException: " +
		rtex.getMessage());
	    System.err.println ("RuntimeException: " + rtex);
	} catch (Exception ex) {
	    System.err.println ("Exception: " + ex.getMessage());
	}

	System.out.println("size of result = " +
	    Array.getLength(result));
	numRecords = Array.getLength(result);

	printResults(result);
    }

    static void doCannedAudit (int ians, SSOToken ssoToken) {

	String[] fileNames = {	"amAuthLog",			// 0
				"amPolicy.access",		// 1
				"amAuthentication.access",	// 2
				"amAuthentication.error",	// 3
				"amAdmin.access",		// 4
				"amAdmin.error",		// 5
				"amConsole.access",		// 6
				"amPasswordReset.access",	// 7
				"amFederation.access",		// 8
				"amFederation.error",		// 9
				"amLiberty.access",		// 10
				"amLiberty.error",		// 11
				"amSAML.access",		// 12
				"amSAML.error",			// 13
				"amSSO.access",			// 14
				"Other"};			// 15
	String[][] result = new String[1][1];
	LogQuery lq = null;
	QueryElement qe = null;
	int numRecords6;

	switch (ians) {
	    case 1:
		//
		//  all records from specified file/table
		//

		System.out.print ("Which file/table:\n" +
		    "\t1.  " + fileNames[0] + "\t2.  " + fileNames[1] + "\n" +
		    "\t3.  " + fileNames[2] + "\t4.  " + fileNames[3] + "\n" +
		    "\t5.  " + fileNames[4] + "\t6.  " + fileNames[5] + "\n" +
		    "\t7.  " + fileNames[6] + "\t8.  " + fileNames[7] + "\n" +
		    "\t9.  " + fileNames[8]+"\t10. "+fileNames[9]+"\n" +
		    "\t11. " + fileNames[10]+"\t12. "+fileNames[11]+"\n" +
		    "\t13. " + fileNames[12]+"\t14. "+fileNames[13]+"\n" +
		    "\t15. " + fileNames[14]+"\t16. "+fileNames[15]+"\n" +
		    "     enter file/table [1..16]:  ");
		String answer = LogSampleUtils.getLine();
		int ianswer = 0;
		try {
		    ianswer = Integer.parseInt (answer);
		} catch (NumberFormatException e) {
		    System.err.println ("'" + answer +
			"' doesn't appear to be an integer.");
		    System.exit(2);
		}

		String fileName = null;
		if ((ianswer >= 1) && (ianswer <= 15)) {
		    fileName = fileNames[ianswer - 1];
		} else if (ianswer == 16) {
		    System.out.print ("Enter file/table name:  ");
		    fileName = LogSampleUtils.getLine();
		} else {
		    System.err.println ("'" + ianswer +
			"' is not a valid selection.");
		    System.exit(3);
		}

		getEntireTable (fileName, ssoToken);
		break;

	    case 2:
		//
		//  authentication successes
		//
		//  data field starts with "Login Success"
		//
		//  very similar to TYPE 6 query; just fewer options for
		//  operator.
		//

		fileName = "amAuthentication.access";
		lq = new LogQuery(LogQuery.ALL_RECORDS,
					   LogQuery.MATCH_ANY_CONDITION,
					   null);
		qe  = new QueryElement("Data",
				       "Login Success",
				       QueryElement.SW);
		lq.addQuery(qe);

		try {
		    result = LogReader.read(fileName, lq, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		printResults(result);

		break;
	    case 3:
		//
		//  authentication failures
		//
		//  just all records from amAuthentication_error
		//

		fileName = "amAuthentication.error";
		getEntireTable (fileName, ssoToken);

		break;

	    case 4:
		//
		//  login/logout activity
		//
		fileName = "amAuthentication.access";
		lq = new LogQuery(LogQuery.ALL_RECORDS,
					   LogQuery.MATCH_ANY_CONDITION,
					   null);
		qe  = new QueryElement("Data", "Login", QueryElement.SW);
		lq.addQuery(qe);

		qe = new QueryElement("Data", "Logout", QueryElement.SW);
		lq.addQuery(qe);

		try {
		    result = LogReader.read(fileName, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		printResults(result);

		break;

	    case 5:
		//
		//  policy allows
		//

		fileName = "amPolicy.access";
		getEntireTable (fileName, ssoToken);

		break;

	    case 6:
		//
		//  policy denies
		//

		fileName = "amAuthLog";
		getEntireTable (fileName, ssoToken);

		break;

	    case 7:
		//
		//  amAdmin CLI activity
		//

		fileName = "amAdmin.access";
		getEntireTable (fileName, ssoToken);

		break;

	    case 8:
		//
		//  amAdmin console activity
		//

		fileName = "amConsole.access";
		getEntireTable (fileName, ssoToken);

		break;

	    case 9:
		//
		//  Federation access
		//
		//

		fileName = "amFederation.access";
		getEntireTable (fileName, ssoToken);

		break;

	    case 10:
		//
		//  Federation errors
		//

		fileName = "amFederation.error";
		getEntireTable (fileName, ssoToken);

		break;

	    case 11:
		//
		//  Liberty access
		//

		fileName = "amLiberty.access";
		getEntireTable (fileName, ssoToken);

		break;

	    case 12:
		//
		//  Liberty errors
		//

		fileName = "amLiberty.error";
		getEntireTable (fileName, ssoToken);

		break;

	    case 13:
		//
		//  SAML access
		//
		//  two different files... can't do it yet.
		//

		fileName = "amSAML.access";
		getEntireTable (fileName, ssoToken);

		break;

	    case 14:
		//
		//  SAML errors
		//
		//  two different files... can't do it yet.
		//

		fileName = "amSAML.error";
		getEntireTable (fileName, ssoToken);

		break;

	    default:
		System.err.println("'" + ians + "' is not a valid selection.");
		break;
	}
    }

    static void doQuery (int ians, String logName, SSOToken ssoToken) {
	String[][] result = new String[1][1];

	switch (ians) {
	    case 1:	// TYPE 1
		//
		//  read all the records from the specified logfile
		//

		System.out.println ("logName = " + logName);

		try {
		    result = LogReader.read(logName, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		printResults(result);

		break;
	    case 2:	// TYPE 2
		//
		//  result = LogReader.read(
		//	logName,
		//	String logType,
		//	ssoToken);
		//
		//  logType is something like "access" or "error"
		//

		System.out.println ("logName = " + logName);
		String logName2 = null;
		if (logName.endsWith(".access") ||
			logName.endsWith(".error"))
		{
		    //
		    //  if already has a suffix, remove it and
		    //  get it again.
		    //
		    StringTokenizer st = new StringTokenizer(logName, ".");
		    logName2 = st.nextToken();
		} else {
		    logName2 = logName;
		}

		System.out.print(
		    "Enter Log Type (e.g., 'error' or 'access'): ");
		String tmpStr2 = LogSampleUtils.getLine();

		try {
		    result = LogReader.read(logName2, tmpStr2, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		System.out.println("just about to print results.");
		printResults(result);
		break;
	    case 3:	// TYPE 3
		//
		//  result = LogReader.read(
		//	logName,
		//	String logType,
		//	String timeStamp,
		//	ssoToken);
		//
		//  logType is something like "access" or "error"
		//
		//  timeStamp (which is appended to
		//  filename) is a Secure ELF thing.  timeStamp
		//  should have this format: ddmmyyyyhhmmss
		//
		//  if called with nonsecure ELF or DB logging,
		//  should get a file/table doesn't exist error.
		//

		System.out.print(
		    "Enter Log Type (e.g., 'error' or 'access'): ");
		String tmpStr3 = LogSampleUtils.getLine();

		System.out.print(
		    "Enter TimeStamp [ddmmyyyyhhmmss]: ");
		String tmpStr3a = LogSampleUtils.getLine();

		try {
		    result = LogReader.read(logName, tmpStr3,
			tmpStr3a, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		System.out.println("just about to print results.");
		printResults(result);

		break;

	    case 4:	// TYPE 4
		//
		//  result = LogReader.read(
		//	logName,
		//	String logType,
		//	LogQuery logQuery,
		//	ssoToken);
		//
		//  logType is something like "access" or "error"
		//

		System.out.print(
		    "Enter Log Type (e.g., 'error' or 'access'): ");
		String tmpStr4 = LogSampleUtils.getLine();

		LogQuery logquery4 = getLogQuery();

		try {
		    result = LogReader.read(logName, tmpStr4,
			logquery4, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		System.out.println("just about to print results.");
		printResults(result);

		break;

	    case 5:	// TYPE 5
		//
		//  result = LogReader.read(
		//	logName,
		//	String logType,
		//	String timeStamp,
		//	LogQuery logQuery,
		//	ssoToken);
		//
		//  logType is something like "access" or "error"
		//
		//  timeStamp (which is appended to
		//  filename) is a secure ELF thing
		//
		System.out.print(
		    "Enter Log Type (e.g., 'error' or 'access'): ");
		String tmpStr5 = LogSampleUtils.getLine();

		System.out.print(
		    "Enter TimeStamp [ddmmyyyyhhmmss]: ");
		String tmpStr5a = LogSampleUtils.getLine();

		LogQuery lq5 = getLogQuery();

		try {
		    result = LogReader.read(logName, tmpStr5,
			tmpStr5a, lq5, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		System.out.println("just about to print results.");
		printResults(result);

		break;

	    case 6:	// TYPE 6
		//
		//  result = LogReader.read(
		//	logName,
		//	LogQuery logQuery,
		//	ssoToken);
		//
		//  can have:
		//    LogQuery(), which sets:
		//      maxRecord = LogQuery.MOST_RECENT_MAX_RECORDS
		//      globalOperand = LogQuery.MATCH_ANY_CONDITION
		//      queries = null
		//      sortBy = null
		//    LogQuery(int max_record), which sets:
		//      maxRecord = max_record
		//      globalOperand = LogQuery.MATCH_ANY_CONDITION
		//      queries = null
		//      sortBy = null
		//    LogQuery(int max_record,
		//	       int matchCriteria,
		//	       String sortingBy), which sets:
		//      maxRecord = max_record
		//	globalOperand = matchCriteria
		//      sortBy = sortingBy
		//      queries = null
		//	
		//  use lq.addQuery(QueryElement qryElement) to
		//  add query elements to the LoqQuery's list of queries
		//
		//  QueryElement(String fld, String val, int rel)
		//    fieldName = fld
		//    fieldValue = val
		//    relation = rel
		//  QueryElement()
		//    fieldName = new String()
		//    fieldValue = new String()
		//    relation = QueryElement.EQ
		//  use:
		//    QueryElement.setFieldName(String field)
		//    QueryElement.setFieldValue(String value)
		//    QueryElement.setRelation(int value)
		//
		//

		String tmpStr;
		String sortBy = null;
		int maxrecs = 0;
		int matchcondx = 0;

		System.out.print("Enter Maximum Records:\n\t" +
		    "a: ALL Records\tb: Most Recent Max Records\n\t" +
		    "<#>: max number of records\n\t" +
		    "    Max Records [a, <#>]: ");
		tmpStr = LogSampleUtils.getLine();
		if (tmpStr.equals("a")) {
		    maxrecs = LogQuery.ALL_RECORDS;
		} else if (tmpStr.equals("b")) {
		    maxrecs = LogQuery.MOST_RECENT_MAX_RECORDS;
		} else {
		    try {
			maxrecs = Integer.parseInt (tmpStr);
		    } catch (NumberFormatException e) {
			System.err.println ("'" + tmpStr +
			    "' doesn't appear to be an integer.");
			System.exit(2);
		    }
		}

		System.out.print("Enter Match Conditions:\n\t" +
		    "a: ALL Conditions\tb: ANY Conditions\n\t" +
		    "    Match Conditions [a, b]: ");
		tmpStr = LogSampleUtils.getLine();
		if (tmpStr.equals("a")) {
		    matchcondx = LogQuery.MATCH_ALL_CONDITIONS;
		} else if (tmpStr.equals("b")) {
		    matchcondx = LogQuery.MATCH_ANY_CONDITION;
		} else {
		    System.err.println ("Invalid selection (" +
			tmpStr + ") for Match Conditions.");
		    System.exit(3);
		}

		System.out.print("Enter Field to Sort By:\n\t" +
		    "a: <NONE>\t<Field>\n\t" +
		    "    Sort Field [a, <Field>]: ");
		tmpStr = LogSampleUtils.getLine();
		if (tmpStr.equals("a")) {
		    sortBy = null;
		} else {
		    sortBy = tmpStr;
		}

		LogQuery lq = new LogQuery(maxrecs, matchcondx, sortBy);

		QueryElement qe;
		while (true) {
		    System.out.print("Query to specify? [y/n]: ");
		    tmpStr = LogSampleUtils.getLine();
		    if (tmpStr.equalsIgnoreCase("n")) {
			break;
		    }
		    qe = getQueryElement();
		    lq.addQuery(qe);
		}

		try {
		    result = LogReader.read(logName, lq, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		System.out.println("size of result = " +
		    Array.getLength(result));
		int numRecords6 = Array.getLength(result);

		printResults(result);

		break;

	    default:
		System.err.println("'" + ians + "' is not a valid selection.");
		break;
	}
    }
    
    static void doMultiTable (int ians, Set logNames, SSOToken ssoToken) {
	String[][] result = new String[1][1];

	switch (ians) {
	    case 1:	// TYPE 1
		//
		//  read all the records from the specified logfile
		//

		//
		//  don't have a read(Set fileNames, Object userCredential)
		//  method, so use the one with LogQuery, and set it to null
		//
		try {
		    result = LogReader.read(logNames, null, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		printResults(result);

		break;

	    case 2:	// TYPE 2
		//
		//  result = LogReader.read(
		//	logNames,
		//	LogQuery logQuery,
		//	ssoToken);
		//
		//  can have:
		//    LogQuery(), which sets:
		//      maxRecord = LogQuery.MOST_RECENT_MAX_RECORDS
		//      globalOperand = LogQuery.MATCH_ANY_CONDITION
		//      queries = null
		//      sortBy = null
		//    LogQuery(int max_record), which sets:
		//      maxRecord = max_record
		//      globalOperand = LogQuery.MATCH_ANY_CONDITION
		//      queries = null
		//      sortBy = null
		//    LogQuery(int max_record,
		//	       int matchCriteria,
		//	       String sortingBy), which sets:
		//      maxRecord = max_record
		//	globalOperand = matchCriteria
		//      sortBy = sortingBy
		//      queries = null
		//	
		//  use lq.addQuery(QueryElement qryElement) to
		//  add query elements to the LoqQuery's list of queries
		//
		//  QueryElement(String fld, String val, int rel)
		//    fieldName = fld
		//    fieldValue = val
		//    relation = rel
		//  QueryElement()
		//    fieldName = new String()
		//    fieldValue = new String()
		//    relation = QueryElement.EQ
		//  use:
		//    QueryElement.setFieldName(String field)
		//    QueryElement.setFieldValue(String value)
		//    QueryElement.setRelation(int value)
		//
		//

		String tmpStr;
		String sortBy = null;
		int maxrecs = 0;
		int matchcondx = 0;

		System.out.print("Enter Maximum Records:\n\t" +
		    "a: ALL Records\tb: Most Recent Max Records\n\t" +
		    "<#>: max number of records\n\t" +
		    "    Max Records [a, <#>]: ");
		tmpStr = LogSampleUtils.getLine();
		if (tmpStr.equals("a")) {
		    maxrecs = LogQuery.ALL_RECORDS;
		} else if (tmpStr.equals("b")) {
		    maxrecs = LogQuery.MOST_RECENT_MAX_RECORDS;
		} else {
		    try {
			maxrecs = Integer.parseInt (tmpStr);
		    } catch (NumberFormatException e) {
			System.err.println ("'" + tmpStr +
			    "' doesn't appear to be an integer.");
			System.exit(2);
		    }
		}

		System.out.print("Enter Match Conditions:\n\t" +
		    "a: ALL Conditions\tb: ANY Conditions\n\t" +
		    "    Match Conditions [a, b]: ");
		tmpStr = LogSampleUtils.getLine();
		if (tmpStr.equals("a")) {
		    matchcondx = LogQuery.MATCH_ALL_CONDITIONS;
		} else if (tmpStr.equals("b")) {
		    matchcondx = LogQuery.MATCH_ANY_CONDITION;
		} else {
		    System.err.println ("Invalid selection (" +
			tmpStr + ") for Match Conditions.");
		    System.exit(3);
		}

		getColumns(fldSort);
		System.out.print("Enter Field to Sort By:\n\t" +
		    "a: <NONE>\t<Field>\n\t" +
		    "    Sort Field [a, <Field>]: ");
		tmpStr = LogSampleUtils.getLine();
		if (tmpStr.equals("a")) {
		    sortBy = null;
		} else {
		    sortBy = tmpStr;
		}

		ArrayList sS = getColumns(fldRetrieve, true);
		LogQuery lq = new LogQuery(maxrecs, matchcondx, sortBy);

		if (sS.size() > 1) {
		    lq.setColumns (sS);
		}

		QueryElement qe;
		while (true) {
		    System.out.print("Query to specify? [y/n]: ");
		    tmpStr = LogSampleUtils.getLine();
		    if (tmpStr.equalsIgnoreCase("n")) {
			break;
		    }
		    qe = getQueryElement();
		    lq.addQuery(qe);
		}

		try {
		    result = LogReader.read(logNames, lq, ssoToken);
		} catch (IOException ioex) {
		    System.err.println ("IOException: " + ioex.getMessage());
		} catch (NoSuchFieldException nsfex) {
		    System.err.println ("NoSuchFieldException: " +
			nsfex.getMessage());
		} catch (IllegalArgumentException iaex) {
		    System.err.println ("IllegalArgumentException: " +
			iaex.getMessage());
		} catch (RuntimeException rtex) {
		    System.err.println ("RuntimeException: " +
			rtex.getMessage());
		    System.err.println ("RuntimeException: " + rtex);
		} catch (Exception ex) {
		    System.err.println ("Exception: " + ex.getMessage());
		}

		System.out.println("size of result = " +
		    Array.getLength(result));
		int numRecords6 = Array.getLength(result);

		printResults(result);

		break;

	    default:
		System.err.println("'" + ians + "' is not a valid selection.");
		break;
	}
    }

}




