<%--
    Copyright (c) 2005 Sun Microsystems, Inc. All rights reserved
    Use is subject to license terms.
--%>



<%@page
import="java.io.*,org.w3c.dom.Element,org.w3c.dom.Document,com.iplanet.am.util.XMLUtils,com.iplanet.am.util.Debug,com.sun.identity.federation.common.FSUtils,com.sun.identity.federation.common.IFSConstants,com.sun.identity.saml.assertion.NameIdentifier,com.sun.identity.federation.message.common.EncryptedNameIdentifier"
%>

<html xmlns="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<head><title>Decrypt the Mapped Name Identifier</title></head>

<%
    if (request.getMethod().equals("POST")) {

	if (FSUtils.debug.messageEnabled()) {
	    FSUtils.debug.message(
		"entering DecryptNameID...");
	}
	
	String nameIdStr = "nothing";
	
	try {
	    
	    String niStr = request.getParameter("ni");
	    String targetNS = request.getParameter("targetNameSpace");
	    
	    if (FSUtils.debug.messageEnabled()) {
		FSUtils.debug.message(
		    "DecryptNameID: input name id element in string="+niStr);
	    }

	    //Debug debug = Debug.getInstance("/var/opt/SUNWam/debug/amFederation");
	    
	    Document doc = XMLUtils.toDOMDocument(niStr, null); //debug);
	    
	    if (doc != null) {
						      
		Element el = doc.getDocumentElement();
		if (el != null) {
		    
		    NameIdentifier ni = new NameIdentifier(el);
	    
		    if (ni.getFormat() != null &&
			ni.getFormat().equals(IFSConstants.NI_ENCRYPTED_FORMAT_URI)) {
			
			ni = EncryptedNameIdentifier.
			    getDecryptedNameIdentifier(
				ni, targetNS);
		    }

		    nameIdStr = ni.toString();
	
		    if (FSUtils.debug.messageEnabled()) {
			FSUtils.debug.message(
			    "Received Name Identifier="+
			    nameIdStr);
		    }
		} else {
		    if (FSUtils.debug.messageEnabled()) {
			FSUtils.debug.message(
			    "could not get dom element");
		    }
		}   
	    } else {
		if (FSUtils.debug.messageEnabled()) {
		    FSUtils.debug.message(
			"could not get dom doc");
		}
	    }
		
	} catch (Exception e) {
	    FSUtils.debug.error("DecryptNameID: ", e);
	    %>
		<body>Got exception: <%= e.getMessage() %></body></html>
	    <%
	    return;	    
	}

	%>
	<body><pre><%= nameIdStr %></pre></body></html>
	<%
    }
%>
	     
